/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.internal.ab;
import com.google.android.gms.internal.dt;
import com.google.android.gms.internal.du;
import com.google.android.gms.internal.ea;
import com.google.android.gms.internal.x;
import com.google.android.gms.internal.y;
import com.google.android.gms.plus.PlusClient;
import com.google.android.gms.plus.PlusOneButton;

public class dz
extends LinearLayout
implements GooglePlayServicesClient.ConnectionCallbacks,
GooglePlayServicesClient.OnConnectionFailedListener {
    private static final int hr = Color.parseColor((String)"#666666");
    protected boolean hs;
    protected int ht = 0;
    protected final LinearLayout hu;
    protected final FrameLayout hv;
    protected final CompoundButton hw;
    private final ProgressBar hx;
    protected final ea hy;
    private final dt[] hz = new dt[4];
    protected int bi = 1;
    private int hA = 2;
    private int K = 3;
    private Uri[] hB;
    private String[] hC;
    private String[] hD;
    protected String hE;
    protected PlusClient gY;
    protected du hF;
    protected final Resources hG;
    protected final LayoutInflater hH;
    private b hI = new b();

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.gY != null) {
            if (!this.gY.isConnectionCallbacksRegistered(this)) {
                this.gY.registerConnectionCallbacks(this);
            }
            if (!this.gY.isConnectionFailedListenerRegistered(this)) {
                this.gY.registerConnectionFailedListener(this);
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.gY != null) {
            if (this.gY.isConnectionCallbacksRegistered(this)) {
                this.gY.unregisterConnectionCallbacks(this);
            }
            if (this.gY.isConnectionFailedListenerRegistered(this)) {
                this.gY.unregisterConnectionFailedListener(this);
            }
        }
    }

    public dz(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Context context2;
        x.b(context, (Object)"Context must not be null.");
        if (GooglePlayServicesUtil.isGooglePlayServicesAvailable(context) != 0) {
            this.hG = null;
            this.hH = null;
        } else {
            context2 = this.k(context);
            this.hG = context2.getResources();
            this.hH = (LayoutInflater)context2.getSystemService("layout_inflater");
        }
        this.K = this.a(context, attributeSet);
        this.hA = this.b(context, attributeSet);
        context2 = new Point();
        this.a((Point)context2);
        if (this.isInEditMode()) {
            TextView textView = new TextView(context);
            textView.setGravity(17);
            textView.setText((CharSequence)"[ +1 ]");
            this.addView((View)textView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(context2.x, context2.y));
            this.hy = null;
            this.hx = null;
            this.hw = null;
            this.hv = null;
            this.hu = null;
            return;
        }
        this.setFocusable(true);
        this.hu = new LinearLayout(context);
        this.hu.setGravity(17);
        this.hu.setOrientation(0);
        this.addView((View)this.hu);
        this.hw = new c(context);
        this.hw.setBackgroundDrawable(null);
        this.hy = this.n(context);
        this.hv = this.l(context);
        this.hv.addView((View)this.hw, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(context2.x, context2.y, 17));
        this.b((Point)context2);
        this.hx = this.m(context);
        this.hx.setVisibility(4);
        this.hv.addView((View)this.hx, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(context2.x, context2.y, 17));
        int n2 = this.hz.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.hz[i2] = this.o(this.getContext());
        }
        this.bm();
    }

    private int a(Context context, AttributeSet attributeSet) {
        String string2 = ab.a("http://schemas.android.com/apk/lib/com.google.android.gms.plus", "size", context, attributeSet, true, false, "PlusOneButton");
        return "SMALL".equalsIgnoreCase(string2) ? 0 : ("MEDIUM".equalsIgnoreCase(string2) ? 1 : ("TALL".equalsIgnoreCase(string2) ? 2 : ("STANDARD".equalsIgnoreCase(string2) ? 3 : 3)));
    }

    private int b(Context context, AttributeSet attributeSet) {
        String string2 = ab.a("http://schemas.android.com/apk/lib/com.google.android.gms.plus", "annotation", context, attributeSet, true, false, "PlusOneButton");
        return "INLINE".equalsIgnoreCase(string2) ? 2 : ("NONE".equalsIgnoreCase(string2) ? 0 : ("BUBBLE".equalsIgnoreCase(string2) ? 1 : 1));
    }

    private Context k(Context context) {
        try {
            return this.getContext().createPackageContext("com.google.android.gms", 4);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            if (Log.isLoggable((String)"PlusOneButton", (int)5)) {
                Log.w((String)"PlusOneButton", (String)"Google Play services is not installed");
            }
            return null;
        }
    }

    public void initialize(PlusClient plusClient, String url, int activityRequestCode) {
        x.b(plusClient, (Object)"Plus client must not be null.");
        x.b(url, (Object)"URL must not be null.");
        x.a(activityRequestCode >= 0 && activityRequestCode <= 65535, "activityRequestCode must be an unsigned 16 bit integer.");
        this.ht = activityRequestCode;
        this.hE = url;
        if (plusClient != this.gY) {
            if (this.gY != null) {
                this.gY.unregisterConnectionCallbacks(this);
                this.gY.unregisterConnectionFailedListener(this);
            }
            this.gY = plusClient;
            this.gY.registerConnectionCallbacks(this);
            this.gY.registerConnectionFailedListener(this);
            int n2 = this.hz.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.hz[i2].a(plusClient);
            }
        } else if (this.gY.isConnected()) {
            this.onConnected(null);
        }
        this.bi();
    }

    public void onConnected(Bundle connectionHint) {
        if (this.hE != null) {
            this.gY.a(this.hI, this.hE);
        }
    }

    public void onConnectionFailed(ConnectionResult status) {
        this.bl();
    }

    public void onDisconnected() {
    }

    public void setOnPlusOneClickListener(PlusOneButton.OnPlusOneClickListener listener) {
        this.setOnClickListener(new a(listener));
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.hw.setOnClickListener(listener);
        this.hy.setOnClickListener(listener);
    }

    public boolean performClick() {
        return this.hw.performClick();
    }

    private void a(Uri[] uriArray) {
        this.hB = uriArray;
        this.bq();
    }

    private void d(String[] stringArray) {
        this.hC = stringArray;
        this.bp();
    }

    private void e(String[] stringArray) {
        this.hD = stringArray;
        this.bp();
    }

    public void setAnnotation(int annotation) {
        x.b(annotation, (Object)"Annotation must not be null.");
        this.hA = annotation;
        this.bp();
        this.bi();
    }

    private void c(View view) {
        int n2 = (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        int n3 = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        view.setPadding(this.hA == 2 ? n3 : 0, 0, 0, this.K == 2 && this.hA == 1 ? n2 : 0);
    }

    private void bh() {
        int n2 = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        int n3 = (int)TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        boolean bl2 = true;
        int n4 = this.hz.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (this.hz[i2].getVisibility() != 0) continue;
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(this.hz[i2].getLayoutParams());
            if (bl2) {
                layoutParams.setMargins(n2, 0, n3, 0);
                bl2 = false;
            } else {
                layoutParams.setMargins(n3, 0, n3, 0);
            }
            this.hz[i2].setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void setSize(int size) {
        this.c(size, this.bi);
    }

    public void setType(int type) {
        this.c(this.K, type);
    }

    private void c(int n2, int n3) {
        this.bi = n3;
        this.K = n2;
        this.bi();
    }

    protected void bi() {
        if (this.isInEditMode()) {
            return;
        }
        this.hu.removeAllViews();
        Point point = new Point();
        this.a(point);
        this.hw.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(point.x, point.y, 17));
        this.b(point);
        this.hx.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(point.x, point.y, 17));
        if (this.hA == 1) {
            this.hy.a(this.bt());
        } else {
            this.hy.a(null);
        }
        this.bq();
        this.hy.setLayoutParams((ViewGroup.LayoutParams)this.bj());
        float f2 = TypedValue.applyDimension((int)2, (float)dz.d(this.K, this.hA), (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        this.hy.setTextSize(0, f2);
        this.c((View)this.hy);
        if (this.K == 2 && this.hA == 1) {
            this.hu.setOrientation(1);
            this.hu.addView((View)this.hy);
            this.hu.addView((View)this.hv);
        } else {
            this.hu.setOrientation(0);
            this.hu.addView((View)this.hv);
            int n2 = this.hz.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.hu.addView((View)this.hz[i2]);
            }
            this.hu.addView((View)this.hy);
        }
        this.requestLayout();
    }

    private FrameLayout l(Context context) {
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setFocusable(false);
        return frameLayout;
    }

    private ProgressBar m(Context context) {
        boolean bl2 = true;
        ProgressBar progressBar = new ProgressBar(context, null, 16843400);
        progressBar.setFocusable(false);
        progressBar.setIndeterminate(true);
        return progressBar;
    }

    private ea n(Context context) {
        ea ea2 = new ea(context);
        ea2.setFocusable(false);
        ea2.setGravity(17);
        ea2.setSingleLine();
        float f2 = TypedValue.applyDimension((int)2, (float)dz.d(this.K, this.hA), (DisplayMetrics)context.getResources().getDisplayMetrics());
        ea2.setTextSize(0, f2);
        ea2.setTextColor(hr);
        ea2.setVisibility(0);
        return ea2;
    }

    private dt o(Context context) {
        dt dt2 = new dt(context);
        dt2.setVisibility(8);
        return dt2;
    }

    private static int d(int n2, int n3) {
        switch (n2) {
            case 2: {
                if (n3 == 2) {
                    return 13;
                }
                return 15;
            }
            case 0: {
                return 11;
            }
            case 1: {
                return 13;
            }
        }
        return 13;
    }

    private LinearLayout.LayoutParams bj() {
        LinearLayout.LayoutParams layoutParams;
        switch (this.hA) {
            case 2: {
                layoutParams = new LinearLayout.LayoutParams(-2, -1);
                break;
            }
            case 1: {
                layoutParams = new LinearLayout.LayoutParams(-2, -2);
                break;
            }
            default: {
                layoutParams = new LinearLayout.LayoutParams(-2, -2);
            }
        }
        layoutParams.bottomMargin = this.K == 2 ? 1 : 0;
        layoutParams.leftMargin = this.K == 2 ? 0 : 1;
        return layoutParams;
    }

    public void bk() {
        this.setType(2);
        this.hx.setVisibility(0);
        this.bo();
    }

    public void bl() {
        this.setType(3);
        this.hx.setVisibility(4);
        this.bo();
    }

    protected void bm() {
        this.setType(1);
        this.hx.setVisibility(4);
        this.bo();
    }

    protected void bn() {
        this.setType(0);
        this.hx.setVisibility(4);
        this.bo();
    }

    protected void bc() {
        if (this.hF == null) {
            return;
        }
        this.d(this.hF.bf());
        this.e(new String[]{this.hF.be()});
        this.a(this.hF.bg());
        if (this.hF.bd()) {
            this.bn();
        } else {
            this.bm();
        }
    }

    protected void bo() {
        this.hw.setButtonDrawable(this.br());
        switch (this.bi) {
            case 0: {
                this.hw.setEnabled(true);
                this.hw.setChecked(true);
                break;
            }
            case 1: {
                this.hw.setEnabled(true);
                this.hw.setChecked(false);
                break;
            }
            case 2: {
                this.hw.setEnabled(false);
                this.hw.setChecked(true);
                break;
            }
            default: {
                this.hw.setEnabled(false);
                this.hw.setChecked(false);
            }
        }
    }

    private void bp() {
        switch (this.hA) {
            case 2: {
                this.hy.f(this.hC);
                this.hy.setVisibility(0);
                break;
            }
            case 1: {
                this.hy.f(this.hD);
                this.hy.setVisibility(0);
                break;
            }
            default: {
                this.hy.f(null);
                this.hy.setVisibility(8);
            }
        }
    }

    private void bq() {
        if (this.hB != null && this.hA == 2) {
            Point point = new Point();
            this.a(point);
            point.x = point.y;
            int n2 = this.hz.length;
            int n3 = this.hB.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Uri uri;
                Uri uri2 = uri = i2 < n3 ? this.hB[i2] : null;
                if (uri == null) {
                    this.hz[i2].setVisibility(8);
                    continue;
                }
                this.hz[i2].setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(point.x, point.y));
                this.hz[i2].a(uri, point.y);
                this.hz[i2].setVisibility(0);
            }
        } else {
            int n4 = this.hz.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                this.hz[i3].setVisibility(8);
            }
        }
        this.bh();
    }

    private void a(Point point) {
        int n2;
        int n3;
        switch (this.K) {
            case 1: {
                n3 = 32;
                n2 = 20;
                break;
            }
            case 0: {
                n3 = 24;
                n2 = 14;
                break;
            }
            case 2: {
                n3 = 50;
                n2 = 20;
                break;
            }
            default: {
                n3 = 38;
                n2 = 24;
            }
        }
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        float f2 = TypedValue.applyDimension((int)1, (float)n3, (DisplayMetrics)displayMetrics);
        float f3 = TypedValue.applyDimension((int)1, (float)n2, (DisplayMetrics)displayMetrics);
        point.x = (int)((double)f2 + 0.5);
        point.y = (int)((double)f3 + 0.5);
    }

    private void b(Point point) {
        point.x = point.y = (int)((float)point.y - TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
    }

    private Drawable br() {
        return this.hG == null ? null : this.hG.getDrawable(this.hG.getIdentifier(this.bs(), "drawable", "com.google.android.gms"));
    }

    private String bs() {
        switch (this.K) {
            case 0: {
                return "ic_plusone_small";
            }
            case 1: {
                return "ic_plusone_medium";
            }
            case 2: {
                return "ic_plusone_tall";
            }
        }
        return "ic_plusone_standard";
    }

    private Uri bt() {
        return y.i(this.bu());
    }

    private String bu() {
        switch (this.K) {
            case 1: {
                return "global_count_bubble_medium";
            }
            case 0: {
                return "global_count_bubble_small";
            }
            case 2: {
                return "global_count_bubble_tall";
            }
        }
        return "global_count_bubble_standard";
    }

    public class b
    implements PlusClient.b {
        protected b() {
        }

        public void a(ConnectionResult connectionResult, du du2) {
            if (dz.this.hs) {
                dz.this.hs = false;
                dz.this.hw.refreshDrawableState();
            }
            if (connectionResult.isSuccess() && du2 != null) {
                dz.this.hF = du2;
                dz.this.bc();
                dz.this.bi();
            } else {
                dz.this.bl();
            }
        }
    }

    class c
    extends CompoundButton {
        public c(Context context) {
            super(context);
        }

        public void toggle() {
            if (dz.this.hs) {
                super.toggle();
            } else {
                dz.this.hs = true;
                dz.this.bk();
            }
        }
    }

    class a
    implements View.OnClickListener,
    PlusOneButton.OnPlusOneClickListener {
        private final PlusOneButton.OnPlusOneClickListener hJ;

        public a(PlusOneButton.OnPlusOneClickListener onPlusOneClickListener) {
            this.hJ = onPlusOneClickListener;
        }

        public void onClick(View view) {
            if (view == dz.this.hw || view == dz.this.hy) {
                Intent intent;
                Intent intent2 = intent = dz.this.hF == null ? null : dz.this.hF.getIntent();
                if (this.hJ != null) {
                    this.hJ.onPlusOneClick(intent);
                } else {
                    this.onPlusOneClick(intent);
                }
            }
        }

        public void onPlusOneClick(Intent intent) {
            Context context = dz.this.getContext();
            if (context instanceof Activity && intent != null) {
                ((Activity)context).startActivityForResult(intent, dz.this.ht);
            }
        }
    }
}

