/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.internal.k;
import com.google.android.gms.internal.q;
import com.google.android.gms.internal.t;
import com.google.android.gms.internal.u;
import com.google.android.gms.internal.x;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class p<T extends IInterface>
implements GooglePlayServicesClient {
    private final Context mContext;
    final Handler mHandler;
    private T at;
    private ArrayList<GooglePlayServicesClient.ConnectionCallbacks> au;
    final ArrayList<GooglePlayServicesClient.ConnectionCallbacks> av = new ArrayList();
    private boolean aw = false;
    private ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> ax;
    private boolean ay = false;
    private final ArrayList<b<?>> az = new ArrayList();
    private e aA;
    private final String[] f;
    boolean aB = false;
    boolean aC = false;
    private final Object aD = new Object();
    public static final String[] aE = new String[]{"service_esmobile", "service_googleme"};

    protected p(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this.mContext = x.d(context);
        this.au = new ArrayList();
        this.au.add(x.d(connectionCallbacks));
        this.ax = new ArrayList();
        this.ax.add(x.d(onConnectionFailedListener));
        this.mHandler = new a(context.getMainLooper());
        this.a(stringArray);
        this.f = stringArray;
    }

    protected void a(String ... stringArray) {
    }

    protected abstract String b();

    protected abstract String c();

    protected abstract T c(IBinder var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.aB = true;
        Object object = this.aD;
        synchronized (object) {
            this.aC = true;
        }
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n2 != 0) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n2));
            return;
        }
        if (this.aA != null) {
            Log.e((String)"GmsClient", (String)"Calling connect() while still connected, missing disconnect().");
            this.at = null;
            q.e(this.mContext).b(this.b(), this.aA);
        }
        this.aA = new e();
        boolean bl2 = q.e(this.mContext).a(this.b(), this.aA);
        if (!bl2) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.b()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
            return;
        }
    }

    @Override
    public boolean isConnected() {
        return this.at != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnecting() {
        Object object = this.aD;
        synchronized (object) {
            return this.aC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.aB = false;
        ArrayList<b<?>> arrayList = this.aD;
        synchronized (arrayList) {
            this.aC = false;
        }
        arrayList = this.az;
        synchronized (arrayList) {
            int n2 = this.az.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.az.get(i2).q();
            }
            this.az.clear();
        }
        this.at = null;
        if (this.aA != null) {
            q.e(this.mContext).b(this.b(), this.aA);
            this.aA = null;
        }
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final String[] j() {
        return this.f;
    }

    protected final void f(IBinder iBinder) {
        try {
            u u2 = u.a.h(iBinder);
            this.a(u2, new d());
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"service died");
        }
    }

    protected abstract void a(u var1, d var2) throws RemoteException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void k() {
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.au;
        synchronized (arrayList) {
            x.a(!this.aw);
            this.mHandler.removeMessages(4);
            this.aw = true;
            x.a(this.av.size() == 0);
            Bundle bundle = this.l();
            ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList2 = this.au;
            int n2 = arrayList2.size();
            for (int i2 = 0; i2 < n2 && this.aB && this.isConnected(); ++i2) {
                int n3 = this.av.size();
                if (this.av.contains(arrayList2.get(i2))) continue;
                arrayList2.get(i2).onConnected(bundle);
            }
            this.av.clear();
            this.aw = false;
        }
    }

    protected Bundle l() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void m() {
        this.mHandler.removeMessages(4);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.au;
        synchronized (arrayList) {
            this.aw = true;
            ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList2 = this.au;
            int n2 = arrayList2.size();
            for (int i2 = 0; i2 < n2 && this.aB; ++i2) {
                if (!this.au.contains(arrayList2.get(i2))) continue;
                arrayList2.get(i2).onDisconnected();
            }
            this.aw = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(ConnectionResult connectionResult) {
        this.mHandler.removeMessages(4);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.ax;
        synchronized (arrayList) {
            this.ay = true;
            ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList2 = this.ax;
            int n2 = arrayList2.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this.aB) {
                    return;
                }
                if (!this.ax.contains(arrayList2.get(i2))) continue;
                arrayList2.get(i2).onConnectionFailed(connectionResult);
            }
            this.ay = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        x.d(listener);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.au;
        synchronized (arrayList) {
            if (this.au.contains(listener)) {
                Log.w((String)"GmsClient", (String)("registerConnectionCallbacks(): listener " + listener + " is already registered"));
            } else {
                if (this.aw) {
                    this.au = new ArrayList<GooglePlayServicesClient.ConnectionCallbacks>(this.au);
                }
                this.au.add(listener);
            }
        }
        if (this.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        x.d(listener);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.au;
        synchronized (arrayList) {
            return this.au.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        x.d(listener);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.au;
        synchronized (arrayList) {
            if (this.au != null) {
                boolean bl2;
                if (this.aw) {
                    this.au = new ArrayList<GooglePlayServicesClient.ConnectionCallbacks>(this.au);
                }
                if (!(bl2 = this.au.remove(listener))) {
                    Log.w((String)"GmsClient", (String)("unregisterConnectionCallbacks(): listener " + listener + " not found"));
                } else if (this.aw && !this.av.contains(listener)) {
                    this.av.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        x.d(listener);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.ax;
        synchronized (arrayList) {
            if (this.ax.contains(listener)) {
                Log.w((String)"GmsClient", (String)("registerConnectionFailedListener(): listener " + listener + " is already registered"));
            } else {
                if (this.ay) {
                    this.ax = new ArrayList<GooglePlayServicesClient.OnConnectionFailedListener>(this.ax);
                }
                this.ax.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        x.d(listener);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.ax;
        synchronized (arrayList) {
            return this.ax.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        x.d(listener);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.ax;
        synchronized (arrayList) {
            if (this.ax != null) {
                boolean bl2;
                if (this.ay) {
                    this.ax = new ArrayList<GooglePlayServicesClient.OnConnectionFailedListener>(this.ax);
                }
                if (!(bl2 = this.ax.remove(listener))) {
                    Log.w((String)"GmsClient", (String)("unregisterConnectionFailedListener(): listener " + listener + " not found"));
                }
            }
        }
    }

    protected final void n() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    protected final T o() {
        this.n();
        return this.at;
    }

    public final void a(b<?> b2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, b2));
    }

    public final class d
    extends t.a {
        protected d() {
        }

        public void a(int n2, IBinder iBinder, Bundle bundle) {
            p.this.mHandler.sendMessage(p.this.mHandler.obtainMessage(1, (Object)new f(n2, iBinder, bundle)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class f
    extends b<Boolean> {
        public final int statusCode;
        public final Bundle aG;
        public final IBinder aH;

        public f(int n2, IBinder iBinder, Bundle bundle) {
            super(true);
            this.statusCode = n2;
            this.aH = iBinder;
            this.aG = bundle;
        }

        @Override
        protected void a(Boolean bl2) {
            if (bl2 == null) {
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    String string2 = null;
                    try {
                        string2 = this.aH.getInterfaceDescriptor();
                        if (p.this.c().equals(string2)) {
                            p.this.at = p.this.c(this.aH);
                            if (p.this.at != null) {
                                p.this.k();
                                return;
                            }
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    q.e(p.this.mContext).b(p.this.b(), p.this.aA);
                    p.this.aA = null;
                    p.this.at = null;
                    p.this.a(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    PendingIntent pendingIntent = null;
                    if (this.aG != null) {
                        pendingIntent = (PendingIntent)this.aG.getParcelable("pendingIntent");
                    }
                    p.this.a(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class c<TListener>
    extends b<TListener> {
        protected final k O;

        public c(TListener TListener, k k2) {
            super(TListener);
            this.O = k2;
        }

        @Override
        protected abstract void a(TListener var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class b<TListener> {
        private TListener mListener;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public b(TListener TListener) {
            this.mListener = TListener;
            ArrayList arrayList = p.this.az;
            synchronized (arrayList) {
                p.this.az.add(this);
            }
        }

        protected abstract void a(TListener var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void p() {
            TListener TListener;
            b b2 = this;
            synchronized (b2) {
                TListener = this.mListener;
            }
            this.a(TListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void q() {
            b b2 = this;
            synchronized (b2) {
                this.mListener = null;
            }
        }
    }

    final class a
    extends Handler {
        public a(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            Object object = p.this.aD;
            synchronized (object) {
                p.this.aC = false;
            }
            if (msg.what == 3) {
                p.this.a(new ConnectionResult((Integer)msg.obj, null));
                return;
            }
            if (msg.what == 4) {
                object = p.this.au;
                synchronized (object) {
                    if (p.this.aB && p.this.isConnected() && p.this.au.contains(msg.obj)) {
                        ((GooglePlayServicesClient.ConnectionCallbacks)msg.obj).onConnected(p.this.l());
                    }
                }
                return;
            }
            if (msg.what == 2 && !p.this.isConnected()) {
                return;
            }
            if (msg.what == 2 || msg.what == 1) {
                object = (b)msg.obj;
                ((b)object).p();
                return;
            }
        }
    }

    final class e
    implements ServiceConnection {
        e() {
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            p.this.f(binder);
        }

        public void onServiceDisconnected(ComponentName component) {
            p.this.at = null;
            p.this.m();
        }
    }
}

