/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.internal.ae;
import com.google.android.gms.internal.cx;
import com.google.android.gms.internal.cy;
import com.google.android.gms.internal.w;
import com.google.android.gms.internal.x;
import com.google.android.gms.maps.model.CameraPositionCreator;
import com.google.android.gms.maps.model.LatLng;

public final class CameraPosition
implements ae {
    public static final CameraPositionCreator CREATOR = new CameraPositionCreator();
    private final int T;
    public final LatLng target;
    public final float zoom;
    public final float tilt;
    public final float bearing;

    CameraPosition(int versionCode, LatLng target, float zoom, float tilt, float bearing) {
        x.b(target, (Object)"null camera target");
        x.b(0.0f <= tilt && tilt <= 90.0f, (Object)"Tilt needs to be between 0 and 90 inclusive");
        this.T = versionCode;
        this.target = target;
        this.zoom = zoom;
        this.tilt = tilt + 0.0f;
        this.bearing = ((double)bearing <= 0.0 ? bearing % 360.0f + 360.0f : bearing) % 360.0f;
    }

    public CameraPosition(LatLng target, float zoom, float tilt, float bearing) {
        this(1, target, zoom, tilt, bearing);
    }

    public void writeToParcel(Parcel out, int flags) {
        if (cx.aV()) {
            cy.a(this, out, flags);
        } else {
            CameraPositionCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        return w.hashCode(this.target, Float.valueOf(this.zoom), Float.valueOf(this.tilt), Float.valueOf(this.bearing));
    }

    public int u() {
        return this.T;
    }

    public static final CameraPosition fromLatLngZoom(LatLng target, float zoom) {
        return new CameraPosition(target, zoom, 0.0f, 0.0f);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CameraPosition camera) {
        return new Builder(camera);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof CameraPosition)) {
            return false;
        }
        CameraPosition cameraPosition = (CameraPosition)o2;
        return this.target.equals(cameraPosition.target) && Float.floatToIntBits(this.zoom) == Float.floatToIntBits(cameraPosition.zoom) && Float.floatToIntBits(this.tilt) == Float.floatToIntBits(cameraPosition.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(cameraPosition.bearing);
    }

    public String toString() {
        return w.c(this).a("target", this.target).a("zoom", Float.valueOf(this.zoom)).a("tilt", Float.valueOf(this.tilt)).a("bearing", Float.valueOf(this.bearing)).toString();
    }

    public static CameraPosition createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (typedArray.hasValue(2)) {
            f2 = typedArray.getFloat(2, 0.0f);
        }
        if (typedArray.hasValue(3)) {
            f3 = typedArray.getFloat(3, 0.0f);
        }
        LatLng latLng = new LatLng(f2, f3);
        Builder builder = CameraPosition.builder();
        builder.target(latLng);
        if (typedArray.hasValue(5)) {
            builder.zoom(typedArray.getFloat(5, 0.0f));
        }
        if (typedArray.hasValue(1)) {
            builder.bearing(typedArray.getFloat(1, 0.0f));
        }
        if (typedArray.hasValue(4)) {
            builder.tilt(typedArray.getFloat(4, 0.0f));
        }
        return builder.build();
    }

    public static final class Builder {
        private LatLng fK;
        private float fL;
        private float fM;
        private float fN;

        public Builder() {
        }

        public Builder(CameraPosition previous) {
            CameraPosition cameraPosition = previous;
            this.fK = cameraPosition.target;
            this.fL = cameraPosition.zoom;
            this.fM = cameraPosition.tilt;
            this.fN = cameraPosition.bearing;
        }

        public Builder target(LatLng location) {
            this.fK = location;
            return this;
        }

        public Builder zoom(float zoom) {
            this.fL = zoom;
            return this;
        }

        public Builder tilt(float tilt) {
            this.fM = tilt;
            return this;
        }

        public Builder bearing(float bearing) {
            this.fN = bearing;
            return this;
        }

        public CameraPosition build() {
            return new CameraPosition(this.fK, this.fL, this.fM, this.fN);
        }
    }
}

