/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.internal.ae;
import com.google.android.gms.internal.cx;
import com.google.android.gms.internal.de;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolygonOptionsCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolygonOptions
implements ae {
    public static final PolygonOptionsCreator CREATOR = new PolygonOptionsCreator();
    private final int T;
    private final List<LatLng> gq;
    private final List<List<LatLng>> gr;
    private float fR = 10.0f;
    private int fS = -16777216;
    private int fT = 0;
    private float fU = 0.0f;
    private boolean fV = true;
    private boolean gs = false;

    public PolygonOptions() {
        this.T = 1;
        this.gq = new ArrayList<LatLng>();
        this.gr = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.T = versionCode;
        this.gq = points;
        this.gr = holes;
        this.fR = strokeWidth;
        this.fS = strokeColor;
        this.fT = fillColor;
        this.fU = zIndex;
        this.fV = visible;
        this.gs = geodesic;
    }

    public int u() {
        return this.T;
    }

    public List aZ() {
        return this.gr;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (cx.aV()) {
            de.a(this, out, flags);
        } else {
            PolygonOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.gq.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.gq.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.gq.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.gr.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.fR = width;
        return this;
    }

    public PolygonOptions strokeColor(int color) {
        this.fS = color;
        return this;
    }

    public PolygonOptions fillColor(int color) {
        this.fT = color;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.fU = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.fV = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.gs = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.gq;
    }

    public List<List<LatLng>> getHoles() {
        return this.gr;
    }

    public float getStrokeWidth() {
        return this.fR;
    }

    public int getStrokeColor() {
        return this.fS;
    }

    public int getFillColor() {
        return this.fT;
    }

    public float getZIndex() {
        return this.fU;
    }

    public boolean isVisible() {
        return this.fV;
    }

    public boolean isGeodesic() {
        return this.gs;
    }
}

