/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import java.nio.ByteBuffer;

public class SubtitleSampleEntry
extends SampleEntry {
    public static final String TYPE1 = "stpp";
    public static final String TYPE_ENCRYPTED = "";
    private String namespace;
    private String schemaLocation;
    private String imageMimeType;

    public SubtitleSampleEntry(String type) {
        super(type);
    }

    @Override
    protected long getContentSize() {
        long contentSize = 8 + this.namespace.length() + this.schemaLocation.length() + this.imageMimeType.length() + 3;
        return contentSize;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this._parseReservedAndDataReferenceIndex(content);
        this.namespace = IsoTypeReader.readString(content);
        this.schemaLocation = IsoTypeReader.readString(content);
        this.imageMimeType = IsoTypeReader.readString(content);
        this._parseChildBoxes(content);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this._writeReservedAndDataReferenceIndex(byteBuffer);
        IsoTypeWriter.writeUtf8String(byteBuffer, this.namespace);
        IsoTypeWriter.writeUtf8String(byteBuffer, this.schemaLocation);
        IsoTypeWriter.writeUtf8String(byteBuffer, this.imageMimeType);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public String getImageMimeType() {
        return this.imageMimeType;
    }

    public void setImageMimeType(String imageMimeType) {
        this.imageMimeType = imageMimeType;
    }
}

