/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder.smoothstreaming;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.SoundMediaHeaderBox;
import com.coremedia.iso.boxes.VideoMediaHeaderBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.DefaultMp4Builder;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.authoring.builder.FragmentedMp4Builder;
import com.googlecode.mp4parser.authoring.builder.Mp4Builder;
import com.googlecode.mp4parser.authoring.builder.SyncSampleIntersectFinderImpl;
import com.googlecode.mp4parser.authoring.builder.smoothstreaming.FlatManifestWriterImpl;
import com.googlecode.mp4parser.authoring.builder.smoothstreaming.ManifestWriter;
import com.googlecode.mp4parser.authoring.builder.smoothstreaming.PackageWriter;
import com.googlecode.mp4parser.authoring.tracks.ChangeTimeScaleTrack;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.logging.Logger;

public class FlatPackageWriterImpl
implements PackageWriter {
    private static Logger LOG = Logger.getLogger(FlatPackageWriterImpl.class.getName());
    long timeScale = 10000000L;
    private File outputDirectory;
    private boolean debugOutput;
    private Mp4Builder ismvBuilder = new FragmentedMp4Builder();
    ManifestWriter manifestWriter;
    FragmentIntersectionFinder fragmentIntersectionFinder = new SyncSampleIntersectFinderImpl();

    public FlatPackageWriterImpl() {
        ((FragmentedMp4Builder)this.ismvBuilder).setIntersectionFinder(this.fragmentIntersectionFinder);
        this.manifestWriter = new FlatManifestWriterImpl();
    }

    public void setOutputDirectory(File outputDirectory) {
        assert (outputDirectory.isDirectory());
        this.outputDirectory = outputDirectory;
    }

    public void setDebugOutput(boolean debugOutput) {
        this.debugOutput = debugOutput;
    }

    public void setIsmvBuilder(Mp4Builder ismvBuilder) {
        this.ismvBuilder = ismvBuilder;
    }

    public void setManifestWriter(ManifestWriter manifestWriter) {
        this.manifestWriter = manifestWriter;
    }

    @Override
    public void write(Movie source) throws IOException {
        if (this.debugOutput) {
            DefaultMp4Builder defaultMp4Builder = new DefaultMp4Builder();
            IsoFile muxed = defaultMp4Builder.build(source);
            File muxedFile = new File(this.outputDirectory, "debug_1_muxed.mp4");
            FileOutputStream muxedFileOutputStream = new FileOutputStream(muxedFile);
            muxed.getBox(muxedFileOutputStream.getChannel());
            muxedFileOutputStream.close();
        }
        Movie movieWithAdjustedTimescale = this.correctTimescale(source);
        if (this.debugOutput) {
            DefaultMp4Builder defaultMp4Builder = new DefaultMp4Builder();
            IsoFile muxed = defaultMp4Builder.build(movieWithAdjustedTimescale);
            File muxedFile = new File(this.outputDirectory, "debug_2_timescale.mp4");
            FileOutputStream muxedFileOutputStream = new FileOutputStream(muxedFile);
            muxed.getBox(muxedFileOutputStream.getChannel());
            muxedFileOutputStream.close();
        }
        IsoFile isoFile = this.ismvBuilder.build(movieWithAdjustedTimescale);
        if (this.debugOutput) {
            File allQualities = new File(this.outputDirectory, "debug_3_fragmented.mp4");
            FileOutputStream allQualis = new FileOutputStream(allQualities);
            isoFile.getBox(allQualis.getChannel());
            allQualis.close();
        }
        for (Track track : movieWithAdjustedTimescale.getTracks()) {
            File mediaOutDir;
            String bitrate = Long.toString(this.manifestWriter.getBitrate(track));
            long trackId = track.getTrackMetaData().getTrackId();
            Iterator<Box> boxIt = isoFile.getBoxes().iterator();
            if (track.getMediaHeaderBox() instanceof SoundMediaHeaderBox) {
                mediaOutDir = new File(this.outputDirectory, "audio");
            } else if (track.getMediaHeaderBox() instanceof VideoMediaHeaderBox) {
                mediaOutDir = new File(this.outputDirectory, "video");
            } else {
                System.err.println("Skipping Track with handler " + track.getHandler() + " and " + track.getMediaHeaderBox().getClass().getSimpleName());
                continue;
            }
            File bitRateOutputDir = new File(mediaOutDir, bitrate);
            bitRateOutputDir.mkdirs();
            LOG.finer("Created : " + bitRateOutputDir.getCanonicalPath());
            long[] fragmentTimes = this.manifestWriter.calculateFragmentDurations(track, movieWithAdjustedTimescale);
            long startTime = 0L;
            int currentFragment = 0;
            while (boxIt.hasNext()) {
                Box b = boxIt.next();
                if (!(b instanceof MovieFragmentBox)) continue;
                assert (((MovieFragmentBox)b).getTrackCount() == 1);
                if (((MovieFragmentBox)b).getTrackNumbers()[0] != trackId) continue;
                FileOutputStream fos = new FileOutputStream(new File(bitRateOutputDir, Long.toString(startTime)));
                startTime += fragmentTimes[currentFragment++];
                FileChannel fc = fos.getChannel();
                Box mdat = boxIt.next();
                assert (mdat.getType().equals("mdat"));
                b.getBox(fc);
                mdat.getBox(fc);
                fc.truncate(fc.position());
                fc.close();
            }
        }
        FileWriter fw = new FileWriter(new File(this.outputDirectory, "Manifest"));
        fw.write(this.manifestWriter.getManifest(movieWithAdjustedTimescale));
        fw.close();
    }

    public Movie correctTimescale(Movie movie) {
        Movie nuMovie = new Movie();
        for (Track track : movie.getTracks()) {
            nuMovie.addTrack(new ChangeTimeScaleTrack(track, this.timeScale, this.fragmentIntersectionFinder.sampleNumbers(track, movie)));
        }
        movie.setTracks(nuMovie.getTracks());
        return movie;
    }
}

