/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.basemediaformat;

import com.coremedia.iso.boxes.h264.AvcConfigurationBox;
import com.googlecode.mp4parser.AbstractBox;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class AvcNalUnitStorageBox
extends AbstractBox {
    byte[] data;

    public AvcNalUnitStorageBox() {
        super("avcn");
    }

    public AvcNalUnitStorageBox(AvcConfigurationBox avcConfigurationBox) {
        super("avcn");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteBuffer content = ByteBuffer.allocate(CastUtils.l2i(avcConfigurationBox.getContentSize()));
        avcConfigurationBox.getContent(content);
        this.data = content.array();
    }

    @Override
    protected long getContentSize() {
        return this.data.length;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.data = new byte[content.remaining()];
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        byteBuffer.put(this.data);
    }

    public String toString() {
        return "AvcNalUnitStorageBox{data=" + Arrays.toString(this.data) + '}';
    }
}

