/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class SampleToGroupBox
extends AbstractFullBox {
    public static final String TYPE = "sbgp";
    private long groupingType;
    private long entryCount;
    private long groupingTypeParameter;
    private List<Entry> entries = new ArrayList<Entry>();

    public SampleToGroupBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return 12L + this.entryCount * 8L;
    }

    public long getGroupingTypeParameter() {
        return this.groupingTypeParameter;
    }

    public void setGroupingTypeParameter(long groupingTypeParameter) {
        this.groupingTypeParameter = groupingTypeParameter;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    public long getGroupingType() {
        return this.groupingType;
    }

    public void setGroupingType(long groupingType) {
        this.groupingType = groupingType;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.groupingType = IsoTypeReader.readUInt32(content);
        this.groupingTypeParameter = this.getVersion() == 1 ? IsoTypeReader.readUInt32(content) : -1L;
        this.entryCount = IsoTypeReader.readUInt32(content);
        int i = 0;
        while ((long)i < this.entryCount) {
            Entry entry = new Entry();
            entry.setSampleCount(IsoTypeReader.readUInt32(content));
            entry.setGroupDescriptionIndex(IsoTypeReader.readUInt32(content));
            this.entries.add(entry);
            ++i;
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.groupingType);
        if (this.getVersion() == 1) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.groupingTypeParameter);
        }
        IsoTypeWriter.writeUInt32(byteBuffer, this.entryCount);
        for (Entry entry : this.entries) {
            IsoTypeWriter.writeUInt32(byteBuffer, entry.getSampleCount());
            IsoTypeWriter.writeUInt32(byteBuffer, entry.getGroupDescriptionIndex());
        }
    }

    public static class Entry {
        private long sampleCount;
        private long groupDescriptionIndex;

        public long getSampleCount() {
            return this.sampleCount;
        }

        public void setSampleCount(long sampleCount) {
            this.sampleCount = sampleCount;
        }

        public long getGroupDescriptionIndex() {
            return this.groupDescriptionIndex;
        }

        public void setGroupDescriptionIndex(long groupDescriptionIndex) {
            this.groupDescriptionIndex = groupDescriptionIndex;
        }
    }
}

