/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.apple;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.Utf8;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.apple.AppleDataBox;
import com.googlecode.mp4parser.AbstractBox;
import com.googlecode.mp4parser.util.ByteBufferByteChannel;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractAppleMetaDataBox
extends AbstractBox
implements ContainerBox {
    private static Logger LOG = Logger.getLogger(AbstractAppleMetaDataBox.class.getName());
    AppleDataBox appleDataBox = new AppleDataBox();

    @Override
    public List<Box> getBoxes() {
        return Collections.singletonList(this.appleDataBox);
    }

    @Override
    public void setBoxes(List<Box> boxes) {
        if (boxes.size() != 1 || !(boxes.get(0) instanceof AppleDataBox)) {
            throw new IllegalArgumentException("This box only accepts one AppleDataBox child");
        }
        this.appleDataBox = (AppleDataBox)boxes.get(0);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz, boolean recursive) {
        if (clazz.isAssignableFrom(this.appleDataBox.getClass())) {
            return Collections.singletonList(this.appleDataBox);
        }
        return null;
    }

    public AbstractAppleMetaDataBox(String type) {
        super(type);
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        long dataBoxSize = IsoTypeReader.readUInt32(content);
        String thisShouldBeData = IsoTypeReader.read4cc(content);
        assert ("data".equals(thisShouldBeData));
        this.appleDataBox = new AppleDataBox();
        try {
            this.appleDataBox.parse(new ByteBufferByteChannel(content), null, content.remaining(), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.appleDataBox.setParent(this);
    }

    @Override
    protected long getContentSize() {
        return this.appleDataBox.getSize();
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        try {
            this.appleDataBox.getBox(new ByteBufferByteChannel(byteBuffer));
        }
        catch (IOException e) {
            throw new RuntimeException("The Channel is based on a ByteBuffer and therefore it shouldn't throw any exception");
        }
    }

    @Override
    public long getNumOfBytesToFirstChild() {
        return this.getSize() - this.appleDataBox.getSize();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{appleDataBox=" + this.getValue() + '}';
    }

    static long toLong(byte b) {
        return b < 0 ? (long)(b + 256) : (long)b;
    }

    public void setValue(String value) {
        if (this.appleDataBox.getFlags() == 1) {
            this.appleDataBox = new AppleDataBox();
            this.appleDataBox.setVersion(0);
            this.appleDataBox.setFlags(1);
            this.appleDataBox.setFourBytes(new byte[4]);
            this.appleDataBox.setData(Utf8.convert(value));
        } else if (this.appleDataBox.getFlags() == 21) {
            byte[] content = this.appleDataBox.getData();
            this.appleDataBox = new AppleDataBox();
            this.appleDataBox.setVersion(0);
            this.appleDataBox.setFlags(21);
            this.appleDataBox.setFourBytes(new byte[4]);
            ByteBuffer bb = ByteBuffer.allocate(content.length);
            if (content.length == 1) {
                IsoTypeWriter.writeUInt8(bb, Byte.parseByte(value) & 0xFF);
            } else if (content.length == 2) {
                IsoTypeWriter.writeUInt16(bb, Integer.parseInt(value));
            } else if (content.length == 4) {
                IsoTypeWriter.writeUInt32(bb, Long.parseLong(value));
            } else if (content.length == 8) {
                IsoTypeWriter.writeUInt64(bb, Long.parseLong(value));
            } else {
                throw new Error("The content length within the appleDataBox is neither 1, 2, 4 or 8. I can't handle that!");
            }
            this.appleDataBox.setData(bb.array());
        } else if (this.appleDataBox.getFlags() == 0) {
            this.appleDataBox = new AppleDataBox();
            this.appleDataBox.setVersion(0);
            this.appleDataBox.setFlags(0);
            this.appleDataBox.setFourBytes(new byte[4]);
            this.appleDataBox.setData(AbstractAppleMetaDataBox.hexStringToByteArray(value));
        } else {
            LOG.warning("Don't know how to handle appleDataBox with flag=" + this.appleDataBox.getFlags());
        }
    }

    public String getValue() {
        if (this.appleDataBox.getFlags() == 1) {
            return Utf8.convert(this.appleDataBox.getData());
        }
        if (this.appleDataBox.getFlags() == 21) {
            byte[] content = this.appleDataBox.getData();
            long l = 0L;
            int current = 1;
            int length = content.length;
            for (byte b : content) {
                l += AbstractAppleMetaDataBox.toLong(b) << 8 * (length - current++);
            }
            return "" + l;
        }
        if (this.appleDataBox.getFlags() == 0) {
            return String.format("%x", new BigInteger(this.appleDataBox.getData()));
        }
        return "unknown";
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}

