/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.mdat;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.ChannelHelper;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public final class MediaDataBox
implements Box {
    public static final String TYPE = "mdat";
    ContainerBox parent;
    ByteBuffer header;
    ByteBuffer content;

    @Override
    public ContainerBox getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ContainerBox parent) {
        this.parent = parent;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        this.header.rewind();
        this.content.rewind();
        writableByteChannel.write(this.header);
        writableByteChannel.write(this.content);
    }

    @Override
    public long getSize() {
        return this.header.limit() + this.content.limit();
    }

    @Override
    public void parse(ReadableByteChannel readableByteChannel, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        this.header = header;
        if (readableByteChannel instanceof FileChannel && contentSize > 0x100000L) {
            this.content = ((FileChannel)readableByteChannel).map(FileChannel.MapMode.READ_ONLY, ((FileChannel)readableByteChannel).position(), contentSize);
            ((FileChannel)readableByteChannel).position(((FileChannel)readableByteChannel).position() + contentSize);
        } else {
            this.content = ChannelHelper.readFully(readableByteChannel, CastUtils.l2i(contentSize));
        }
    }

    public ByteBuffer getContent() {
        return this.content;
    }

    public ByteBuffer getHeader() {
        return this.header;
    }
}

