/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring;

import com.coremedia.iso.boxes.AbstractMediaHeaderBox;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.MediaHeaderBox;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.coremedia.iso.boxes.fragment.MovieExtendsBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackRunBox;
import com.coremedia.iso.boxes.mdat.SampleList;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.DateHelper;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class Mp4TrackImpl
extends AbstractTrack {
    private List<ByteBuffer> samples;
    private SampleDescriptionBox sampleDescriptionBox;
    private List<TimeToSampleBox.Entry> decodingTimeEntries;
    private List<CompositionTimeToSample.Entry> compositionTimeEntries;
    private long[] syncSamples;
    private List<SampleDependencyTypeBox.Entry> sampleDependencies;
    private TrackMetaData trackMetaData = new TrackMetaData();
    private String handler;
    private AbstractMediaHeaderBox mihd;

    public Mp4TrackImpl(TrackBox trackBox) {
        this.samples = new SampleList(trackBox);
        SampleTableBox stbl = trackBox.getMediaBox().getMediaInformationBox().getSampleTableBox();
        this.handler = trackBox.getMediaBox().getHandlerBox().getHandlerType();
        this.mihd = trackBox.getMediaBox().getMediaInformationBox().getMediaHeaderBox();
        this.sampleDescriptionBox = stbl.getSampleDescriptionBox();
        if (trackBox.getParent().getBoxes(MovieExtendsBox.class).size() > 0) {
            this.decodingTimeEntries = new LinkedList<TimeToSampleBox.Entry>();
            this.compositionTimeEntries = new LinkedList<CompositionTimeToSample.Entry>();
            this.sampleDependencies = new LinkedList<SampleDependencyTypeBox.Entry>();
            for (MovieFragmentBox movieFragmentBox : trackBox.getIsoFile().getBoxes(MovieFragmentBox.class)) {
                List<TrackFragmentBox> trafs = movieFragmentBox.getBoxes(TrackFragmentBox.class);
                for (TrackFragmentBox traf : trafs) {
                    if (traf.getTrackFragmentHeaderBox().getTrackId() != trackBox.getTrackHeaderBox().getTrackId()) continue;
                    List<TrackRunBox> truns = traf.getBoxes(TrackRunBox.class);
                    for (TrackRunBox trun : truns) {
                        for (TrackRunBox.Entry entry : trun.getEntries()) {
                            Object e;
                            if (trun.isSampleDurationPresent()) {
                                if (this.decodingTimeEntries.size() == 0 || this.decodingTimeEntries.get(this.decodingTimeEntries.size() - 1).getDelta() != entry.getSampleDuration()) {
                                    this.decodingTimeEntries.add(new TimeToSampleBox.Entry(1L, entry.getSampleDuration()));
                                } else {
                                    e = this.decodingTimeEntries.get(this.decodingTimeEntries.size() - 1);
                                    ((TimeToSampleBox.Entry)e).setCount(((TimeToSampleBox.Entry)e).getCount() + 1L);
                                }
                            }
                            if (!trun.isSampleCompositionTimeOffsetPresent()) continue;
                            if (this.compositionTimeEntries.size() == 0 || this.compositionTimeEntries.get(this.compositionTimeEntries.size() - 1).getOffset() != entry.getSampleCompositionTimeOffset()) {
                                this.compositionTimeEntries.add(new CompositionTimeToSample.Entry(1, CastUtils.l2i(entry.getSampleCompositionTimeOffset())));
                                continue;
                            }
                            e = this.compositionTimeEntries.get(this.compositionTimeEntries.size() - 1);
                            ((CompositionTimeToSample.Entry)e).setCount(((CompositionTimeToSample.Entry)e).getCount() + 1);
                        }
                    }
                }
            }
        } else {
            this.decodingTimeEntries = stbl.getTimeToSampleBox().getEntries();
            if (stbl.getCompositionTimeToSample() != null) {
                this.compositionTimeEntries = stbl.getCompositionTimeToSample().getEntries();
            }
            if (stbl.getSyncSampleBox() != null) {
                this.syncSamples = stbl.getSyncSampleBox().getSampleNumber();
            }
            if (stbl.getSampleDependencyTypeBox() != null) {
                this.sampleDependencies = stbl.getSampleDependencyTypeBox().getEntries();
            }
        }
        MediaHeaderBox mdhd = trackBox.getMediaBox().getMediaHeaderBox();
        TrackHeaderBox tkhd = trackBox.getTrackHeaderBox();
        this.setEnabled(tkhd.isEnabled());
        this.setInMovie(tkhd.isInMovie());
        this.setInPoster(tkhd.isInPoster());
        this.setInPreview(tkhd.isInPreview());
        this.trackMetaData.setTrackId(tkhd.getTrackId());
        this.trackMetaData.setCreationTime(DateHelper.convert(mdhd.getCreationTime()));
        this.trackMetaData.setLanguage(mdhd.getLanguage());
        this.trackMetaData.setModificationTime(DateHelper.convert(mdhd.getModificationTime()));
        this.trackMetaData.setTimescale(mdhd.getTimescale());
        this.trackMetaData.setHeight(tkhd.getHeight());
        this.trackMetaData.setWidth(tkhd.getWidth());
        this.trackMetaData.setLayer(tkhd.getLayer());
    }

    @Override
    public List<ByteBuffer> getSamples() {
        return this.samples;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return this.decodingTimeEntries;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.compositionTimeEntries;
    }

    @Override
    public long[] getSyncSamples() {
        return this.syncSamples;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.sampleDependencies;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return this.handler;
    }

    @Override
    public AbstractMediaHeaderBox getMediaHeaderBox() {
        return this.mihd;
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    public String toString() {
        return "Mp4TrackImpl{handler='" + this.handler + '\'' + '}';
    }
}

