/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.easing;

import android.os.Handler;
import android.os.SystemClock;
import it.sephiroth.android.library.easing.Easing;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class EasingManager {
    static final int FPS = 60;
    static final int FRAME_TIME = 16;
    static final Handler mHandler = new Handler();
    Easing mEasing;
    Method mMethod;
    boolean mRunning;
    long mBase;
    int mDuration;
    double mStartValue;
    double mEndValue;
    double mValue;
    boolean mInverted;
    EasingCallback mEasingCallback;
    String mToken;
    Ticker mTicker;

    public EasingManager(EasingCallback callback) {
        this.mEasingCallback = callback;
        this.mToken = String.valueOf(System.currentTimeMillis());
    }

    public void start(Class<? extends Easing> clazz, EaseType type, double fromValue, double endValue, int durationMillis) {
        this.start(clazz, type, fromValue, endValue, durationMillis, 0L);
    }

    public void start(Class<? extends Easing> clazz, EaseType type, double fromValue, double endValue, int durationMillis, long delayMillis) {
        if (!this.mRunning) {
            this.mEasing = this.createInstance(clazz);
            if (null == this.mEasing) {
                return;
            }
            this.mMethod = this.getEasingMethod(this.mEasing, type);
            if (this.mMethod == null) {
                return;
            }
            boolean bl = this.mInverted = fromValue > endValue;
            if (this.mInverted) {
                this.mStartValue = endValue;
                this.mEndValue = fromValue;
            } else {
                this.mStartValue = fromValue;
                this.mEndValue = endValue;
            }
            this.mValue = this.mStartValue;
            this.mDuration = durationMillis;
            this.mBase = SystemClock.uptimeMillis() + delayMillis;
            this.mRunning = true;
            this.mTicker = new Ticker();
            long next = SystemClock.uptimeMillis() + 16L + delayMillis;
            if (delayMillis == 0L) {
                this.mEasingCallback.onEasingStarted(fromValue);
            } else {
                mHandler.postAtTime((Runnable)new TickerStart(fromValue), (Object)this.mToken, next - 16L);
            }
            mHandler.postAtTime((Runnable)this.mTicker, (Object)this.mToken, next);
        }
    }

    public void stop() {
        this.mRunning = false;
        mHandler.removeCallbacks((Runnable)this.mTicker, (Object)this.mToken);
    }

    Easing createInstance(Class<? extends Easing> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    Method getEasingMethod(Easing instance, EaseType type) {
        String methodName = this.getMethodName(type);
        if (null != methodName) {
            Method m;
            try {
                m = instance.getClass().getMethod(methodName, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
            }
            catch (SecurityException e) {
                e.printStackTrace();
                return null;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return null;
            }
            return m;
        }
        return null;
    }

    String getMethodName(EaseType type) {
        switch (type) {
            case EaseIn: {
                return "easeIn";
            }
            case EaseInOut: {
                return "easeInOut";
            }
            case EaseNone: {
                return "easeNone";
            }
            case EaseOut: {
                return "easeOut";
            }
        }
        return null;
    }

    class Ticker
    implements Runnable {
        Ticker() {
        }

        @Override
        public void run() {
            double value;
            long base = EasingManager.this.mBase;
            long now = SystemClock.uptimeMillis();
            long diff = now - base;
            double old = EasingManager.this.mValue;
            try {
                value = (Double)EasingManager.this.mMethod.invoke((Object)EasingManager.this.mEasing, diff, EasingManager.this.mStartValue, EasingManager.this.mEndValue, EasingManager.this.mDuration);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return;
            }
            EasingManager.this.mValue = value;
            int frame = (int)(diff / 16L);
            long next = base + (long)((frame + 1) * 16);
            if (diff < (long)EasingManager.this.mDuration) {
                EasingManager.this.mEasingCallback.onEasingValueChanged(EasingManager.this.mInverted ? EasingManager.this.mEndValue - value : value, old);
                mHandler.postAtTime((Runnable)this, (Object)EasingManager.this.mToken, next);
            } else {
                EasingManager.this.mEasingCallback.onEasingFinished(EasingManager.this.mInverted ? EasingManager.this.mEndValue : EasingManager.this.mStartValue);
                EasingManager.this.mRunning = false;
            }
        }
    }

    class TickerStart
    implements Runnable {
        double mValue;

        public TickerStart(double value) {
            this.mValue = value;
        }

        @Override
        public void run() {
            EasingManager.this.mEasingCallback.onEasingStarted(this.mValue);
        }
    }

    public static enum EaseType {
        EaseIn,
        EaseOut,
        EaseInOut,
        EaseNone;

    }

    public static interface EasingCallback {
        public void onEasingValueChanged(double var1, double var3);

        public void onEasingStarted(double var1);

        public void onEasingFinished(double var1);
    }
}

