/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.jce;

import java.util.Enumeration;
import java.util.Vector;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.nist.NISTNamedCurves;
import org.spongycastle.asn1.sec.SECNamedCurves;
import org.spongycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.spongycastle.asn1.x9.X962NamedCurves;
import org.spongycastle.asn1.x9.X9ECParameters;
import org.spongycastle.jce.spec.ECNamedCurveParameterSpec;

public class ECNamedCurveTable {
    public static ECNamedCurveParameterSpec getParameterSpec(String name) {
        X9ECParameters ecP = X962NamedCurves.getByName((String)name);
        if (ecP == null) {
            try {
                ecP = X962NamedCurves.getByOID((ASN1ObjectIdentifier)new ASN1ObjectIdentifier(name));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (ecP == null && (ecP = SECNamedCurves.getByName((String)name)) == null) {
            try {
                ecP = SECNamedCurves.getByOID((ASN1ObjectIdentifier)new ASN1ObjectIdentifier(name));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (ecP == null && (ecP = TeleTrusTNamedCurves.getByName((String)name)) == null) {
            try {
                ecP = TeleTrusTNamedCurves.getByOID((ASN1ObjectIdentifier)new ASN1ObjectIdentifier(name));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (ecP == null) {
            ecP = NISTNamedCurves.getByName((String)name);
        }
        if (ecP == null) {
            return null;
        }
        return new ECNamedCurveParameterSpec(name, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
    }

    public static Enumeration getNames() {
        Vector v = new Vector();
        ECNamedCurveTable.addEnumeration(v, X962NamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v, SECNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v, NISTNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v, TeleTrusTNamedCurves.getNames());
        return v.elements();
    }

    private static void addEnumeration(Vector v, Enumeration e) {
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
    }
}

