/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.oauth2;

import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleAuthorizationCodeRequestUrl
extends AuthorizationCodeRequestUrl {
    @Key(value="approval_prompt")
    private String approvalPrompt;
    @Key(value="access_type")
    private String accessType;

    @Deprecated
    @Beta
    public GoogleAuthorizationCodeRequestUrl(String clientId, String redirectUri, Iterable<String> scopes) {
        this("https://accounts.google.com/o/oauth2/auth", clientId, redirectUri, scopes);
    }

    public GoogleAuthorizationCodeRequestUrl(String clientId, String redirectUri, Collection<String> scopes) {
        this("https://accounts.google.com/o/oauth2/auth", clientId, redirectUri, scopes);
    }

    @Deprecated
    @Beta
    public GoogleAuthorizationCodeRequestUrl(String authorizationServerEncodedUrl, String clientId, String redirectUri, Iterable<String> scopes) {
        super(authorizationServerEncodedUrl, clientId);
        this.setRedirectUri(redirectUri);
        this.setScopes((Iterable)scopes);
    }

    public GoogleAuthorizationCodeRequestUrl(String authorizationServerEncodedUrl, String clientId, String redirectUri, Collection<String> scopes) {
        super(authorizationServerEncodedUrl, clientId);
        this.setRedirectUri(redirectUri);
        this.setScopes((Collection)scopes);
    }

    @Deprecated
    @Beta
    public GoogleAuthorizationCodeRequestUrl(GoogleClientSecrets clientSecrets, String redirectUri, Iterable<String> scopes) {
        this(clientSecrets.getDetails().getClientId(), redirectUri, scopes);
    }

    public GoogleAuthorizationCodeRequestUrl(GoogleClientSecrets clientSecrets, String redirectUri, Collection<String> scopes) {
        this(clientSecrets.getDetails().getClientId(), redirectUri, scopes);
    }

    public final String getApprovalPrompt() {
        return this.approvalPrompt;
    }

    public GoogleAuthorizationCodeRequestUrl setApprovalPrompt(String approvalPrompt) {
        this.approvalPrompt = approvalPrompt;
        return this;
    }

    public final String getAccessType() {
        return this.accessType;
    }

    public GoogleAuthorizationCodeRequestUrl setAccessType(String accessType) {
        this.accessType = accessType;
        return this;
    }

    @Deprecated
    @Beta
    public GoogleAuthorizationCodeRequestUrl setResponseTypes(String ... responseTypes) {
        return (GoogleAuthorizationCodeRequestUrl)super.setResponseTypes(responseTypes);
    }

    @Deprecated
    @Beta
    public GoogleAuthorizationCodeRequestUrl setResponseTypes(Iterable<String> responseTypes) {
        return (GoogleAuthorizationCodeRequestUrl)super.setResponseTypes(responseTypes);
    }

    public GoogleAuthorizationCodeRequestUrl setResponseTypes(Collection<String> responseTypes) {
        return (GoogleAuthorizationCodeRequestUrl)super.setResponseTypes(responseTypes);
    }

    public GoogleAuthorizationCodeRequestUrl setRedirectUri(String redirectUri) {
        Preconditions.checkNotNull((Object)redirectUri);
        return (GoogleAuthorizationCodeRequestUrl)super.setRedirectUri(redirectUri);
    }

    @Deprecated
    @Beta
    public GoogleAuthorizationCodeRequestUrl setScopes(String ... scopes) {
        Preconditions.checkArgument((scopes.length != 0 ? 1 : 0) != 0);
        return (GoogleAuthorizationCodeRequestUrl)super.setScopes(scopes);
    }

    @Deprecated
    @Beta
    public GoogleAuthorizationCodeRequestUrl setScopes(Iterable<String> scopes) {
        Preconditions.checkArgument((boolean)scopes.iterator().hasNext());
        return (GoogleAuthorizationCodeRequestUrl)super.setScopes(scopes);
    }

    public GoogleAuthorizationCodeRequestUrl setScopes(Collection<String> scopes) {
        Preconditions.checkArgument((boolean)scopes.iterator().hasNext());
        return (GoogleAuthorizationCodeRequestUrl)super.setScopes(scopes);
    }

    public GoogleAuthorizationCodeRequestUrl setClientId(String clientId) {
        return (GoogleAuthorizationCodeRequestUrl)super.setClientId(clientId);
    }

    public GoogleAuthorizationCodeRequestUrl setState(String state) {
        return (GoogleAuthorizationCodeRequestUrl)super.setState(state);
    }

    public GoogleAuthorizationCodeRequestUrl set(String fieldName, Object value) {
        return (GoogleAuthorizationCodeRequestUrl)super.set(fieldName, value);
    }

    public GoogleAuthorizationCodeRequestUrl clone() {
        return (GoogleAuthorizationCodeRequestUrl)super.clone();
    }
}

