/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.oauth2;

import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.JsonToken;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Clock;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.SecurityUtils;
import com.google.api.client.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class GoogleIdTokenVerifier {
    private static final Pattern MAX_AGE_PATTERN = Pattern.compile("\\s*max-age\\s*=\\s*(\\d+)\\s*");
    private static final long TIME_SKEW_SECONDS = 300L;
    private final JsonFactory jsonFactory;
    private List<PublicKey> publicKeys;
    private long expirationTimeMilliseconds;
    private final HttpTransport transport;
    private final Lock lock = new ReentrantLock();
    private final Clock clock;
    private final String publicCertsEncodedUrl;

    public GoogleIdTokenVerifier(HttpTransport transport, JsonFactory jsonFactory) {
        this(new Builder(transport, jsonFactory));
    }

    protected GoogleIdTokenVerifier(Builder builder) {
        this.transport = builder.transport;
        this.jsonFactory = builder.jsonFactory;
        this.clock = builder.clock;
        this.publicCertsEncodedUrl = builder.publicCertsEncodedUrl;
    }

    public final HttpTransport getTransport() {
        return this.transport;
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public final String getPublicCertsEncodedUrl() {
        return this.publicCertsEncodedUrl;
    }

    public final List<PublicKey> getPublicKeys() {
        return this.publicKeys;
    }

    public final long getExpirationTimeMilliseconds() {
        return this.expirationTimeMilliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(GoogleIdToken idToken) throws GeneralSecurityException, IOException {
        if (!idToken.verifyIssuer("accounts.google.com") || !idToken.verifyTime(this.clock.currentTimeMillis(), 300L)) {
            return false;
        }
        this.lock.lock();
        try {
            if (this.publicKeys == null || this.clock.currentTimeMillis() + 300000L > this.expirationTimeMilliseconds) {
                this.loadPublicCerts();
            }
            for (PublicKey publicKey : this.publicKeys) {
                if (!idToken.verifySignature(publicKey)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    public GoogleIdToken verify(String idTokenString) throws GeneralSecurityException, IOException {
        GoogleIdToken idToken = GoogleIdToken.parse(this.jsonFactory, idTokenString);
        return this.verify(idToken) ? idToken : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GoogleIdTokenVerifier loadPublicCerts() throws GeneralSecurityException, IOException {
        this.lock.lock();
        try {
            this.publicKeys = new ArrayList<PublicKey>();
            CertificateFactory factory = SecurityUtils.getX509CertificateFactory();
            HttpResponse certsResponse = this.transport.createRequestFactory().buildGetRequest(new GenericUrl(this.publicCertsEncodedUrl)).execute();
            this.expirationTimeMilliseconds = this.clock.currentTimeMillis() + this.getCacheTimeInSec(certsResponse.getHeaders()) * 1000L;
            JsonParser parser = this.jsonFactory.createJsonParser(certsResponse.getContent());
            JsonToken currentToken = parser.getCurrentToken();
            if (currentToken == null) {
                currentToken = parser.nextToken();
            }
            Preconditions.checkArgument((currentToken == JsonToken.START_OBJECT ? 1 : 0) != 0);
            try {
                while (parser.nextToken() != JsonToken.END_OBJECT) {
                    parser.nextToken();
                    String certValue = parser.getText();
                    X509Certificate x509Cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(StringUtils.getBytesUtf8((String)certValue)));
                    this.publicKeys.add(x509Cert.getPublicKey());
                }
                this.publicKeys = Collections.unmodifiableList(this.publicKeys);
            }
            finally {
                parser.close();
            }
            GoogleIdTokenVerifier googleIdTokenVerifier = this;
            return googleIdTokenVerifier;
        }
        finally {
            this.lock.unlock();
        }
    }

    long getCacheTimeInSec(HttpHeaders httpHeaders) {
        long cacheTimeInSec = 0L;
        if (httpHeaders.getCacheControl() != null) {
            for (String arg : httpHeaders.getCacheControl().split(",")) {
                Matcher m = MAX_AGE_PATTERN.matcher(arg);
                if (!m.matches()) continue;
                cacheTimeInSec = Long.valueOf(m.group(1));
                break;
            }
        }
        if (httpHeaders.getAge() != null) {
            cacheTimeInSec -= httpHeaders.getAge().longValue();
        }
        return Math.max(0L, cacheTimeInSec);
    }

    @Beta
    public static class Builder {
        final HttpTransport transport;
        final JsonFactory jsonFactory;
        String publicCertsEncodedUrl = "https://www.googleapis.com/oauth2/v1/certs";
        Clock clock = Clock.SYSTEM;

        public Builder(HttpTransport transport, JsonFactory jsonFactory) {
            this.transport = (HttpTransport)Preconditions.checkNotNull((Object)transport);
            this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
        }

        public GoogleIdTokenVerifier build() {
            return new GoogleIdTokenVerifier(this);
        }

        public final HttpTransport getTransport() {
            return this.transport;
        }

        public final JsonFactory getJsonFactory() {
            return this.jsonFactory;
        }

        public final String getPublicCertsEncodedUrl() {
            return this.publicCertsEncodedUrl;
        }

        public Builder setPublicCertsEncodedUrl(String publicCertsEncodedUrl) {
            this.publicCertsEncodedUrl = (String)Preconditions.checkNotNull((Object)publicCertsEncodedUrl);
            return this;
        }

        public final Clock getClock() {
            return this.clock;
        }

        public Builder setClock(Clock clock) {
            this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
            return this;
        }
    }
}

