/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.accessibilityservice;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.pm.ResolveInfo;

public class AccessibilityServiceInfoCompat {
    private static final AccessibilityServiceInfoVersionImpl IMPL = new AccessibilityServiceInfoStubImpl();
    public static final int FEEDBACK_ALL_MASK = -1;

    private AccessibilityServiceInfoCompat() {
    }

    public static String getId(AccessibilityServiceInfo info) {
        return IMPL.getId(info);
    }

    public static ResolveInfo getResolveInfo(AccessibilityServiceInfo info) {
        return IMPL.getResolveInfo(info);
    }

    public static String getSettingsActivityName(AccessibilityServiceInfo info) {
        return IMPL.getSettingsActivityName(info);
    }

    public static boolean getCanRetrieveWindowContent(AccessibilityServiceInfo info) {
        return IMPL.getCanRetrieveWindowContent(info);
    }

    public static String getDescription(AccessibilityServiceInfo info) {
        return IMPL.getDescription(info);
    }

    public static String feedbackTypeToString(int feedbackType) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        while (feedbackType > 0) {
            int feedbackTypeFlag = 1 << Integer.numberOfTrailingZeros(feedbackType);
            feedbackType &= ~feedbackTypeFlag;
            if (builder.length() > 1) {
                builder.append(", ");
            }
            switch (feedbackTypeFlag) {
                case 4: {
                    builder.append("FEEDBACK_AUDIBLE");
                    break;
                }
                case 2: {
                    builder.append("FEEDBACK_HAPTIC");
                    break;
                }
                case 16: {
                    builder.append("FEEDBACK_GENERIC");
                    break;
                }
                case 1: {
                    builder.append("FEEDBACK_SPOKEN");
                    break;
                }
                case 8: {
                    builder.append("FEEDBACK_VISUAL");
                }
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public static String flagToString(int flag) {
        switch (flag) {
            case 1: {
                return "DEFAULT";
            }
        }
        return null;
    }

    static class AccessibilityServiceInfoStubImpl
    implements AccessibilityServiceInfoVersionImpl {
        AccessibilityServiceInfoStubImpl() {
        }

        @Override
        public boolean getCanRetrieveWindowContent(AccessibilityServiceInfo info) {
            return false;
        }

        @Override
        public String getDescription(AccessibilityServiceInfo info) {
            return null;
        }

        @Override
        public String getId(AccessibilityServiceInfo info) {
            return null;
        }

        @Override
        public ResolveInfo getResolveInfo(AccessibilityServiceInfo info) {
            return null;
        }

        @Override
        public String getSettingsActivityName(AccessibilityServiceInfo info) {
            return null;
        }
    }

    static interface AccessibilityServiceInfoVersionImpl {
        public String getId(AccessibilityServiceInfo var1);

        public ResolveInfo getResolveInfo(AccessibilityServiceInfo var1);

        public boolean getCanRetrieveWindowContent(AccessibilityServiceInfo var1);

        public String getDescription(AccessibilityServiceInfo var1);

        public String getSettingsActivityName(AccessibilityServiceInfo var1);
    }
}

