/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.support.v4.app.ActionBar;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentManagerImpl;
import android.support.v4.app.HCSparseArray;
import android.support.v4.app.LoaderManager;
import android.support.v4.app.LoaderManagerImpl;
import android.support.v4.app.SupportActivity;
import android.support.v4.view.ActionMode;
import android.support.v4.view.MenuItem;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import com.actionbarsherlock.internal.app.ActionBarImpl;
import com.actionbarsherlock.internal.app.ActionBarWrapper;
import com.actionbarsherlock.internal.view.menu.MenuBuilder;
import com.actionbarsherlock.internal.view.menu.MenuInflaterImpl;
import com.actionbarsherlock.internal.view.menu.MenuInflaterWrapper;
import com.actionbarsherlock.internal.view.menu.MenuItemImpl;
import com.actionbarsherlock.internal.view.menu.MenuItemWrapper;
import com.actionbarsherlock.internal.view.menu.MenuPresenter;
import com.actionbarsherlock.internal.view.menu.MenuWrapper;
import com.actionbarsherlock.internal.widget.ActionBarView;
import com.ushahidi.android.app.R;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

public class FragmentActivity
extends Activity
implements SupportActivity {
    private static final String TAG = "FragmentActivity";
    private static final boolean DEBUG = false;
    private static final String FRAGMENTS_TAG = "android:support:fragments";
    static final boolean IS_HONEYCOMB = Build.VERSION.SDK_INT >= 11;
    static final int MSG_REALLY_STOPPED = 1;
    static final int MSG_RESUME_PENDING = 2;
    final SupportActivity.InternalCallbacks mInternalCallbacks = new SupportActivity.InternalCallbacks(){

        @Override
        void invalidateSupportFragmentIndex(int index) {
            FragmentActivity.this.invalidateSupportFragmentIndex(index);
        }

        @Override
        LoaderManagerImpl getLoaderManager(int index, boolean started, boolean create) {
            return FragmentActivity.this.getLoaderManager(index, started, create);
        }

        @Override
        Handler getHandler() {
            return FragmentActivity.this.mHandler;
        }

        @Override
        FragmentManagerImpl getFragments() {
            return FragmentActivity.this.mFragments;
        }

        @Override
        boolean getRetaining() {
            return FragmentActivity.this.mRetaining;
        }
    };
    final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (!FragmentActivity.this.mStopped) break;
                    FragmentActivity.this.doReallyStop(false);
                    break;
                }
                case 2: {
                    FragmentActivity.this.mFragments.dispatchResume();
                    FragmentActivity.this.mFragments.execPendingActions();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    };
    final FragmentManagerImpl mFragments = new FragmentManagerImpl();
    ViewGroup mDecor;
    ViewGroup mContentParent;
    ActionBar mActionBar;
    ActionBarView mActionBarView;
    long mWindowFlags = 0L;
    MenuInflater mMenuInflater;
    MenuBuilder mSupportMenu;
    final MenuBuilder.Callback mSupportMenuCallback = new MenuBuilder.Callback(){

        @Override
        public boolean onMenuItemSelected(MenuBuilder menu2, MenuItem item) {
            return FragmentActivity.this.onMenuItemSelected(0, item);
        }

        @Override
        public void onMenuModeChange(MenuBuilder menu2) {
        }
    };
    private final MenuPresenter.Callback mMenuPresenterCallback = new MenuPresenter.Callback(){

        @Override
        public boolean onOpenSubMenu(MenuBuilder subMenu) {
            return false;
        }

        @Override
        public void onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
        }
    };
    private HashMap<android.view.MenuItem, MenuItemImpl> mNativeItemMap;
    private final MenuItem.OnMenuItemClickListener mNativeItemListener = new MenuItem.OnMenuItemClickListener(){

        public boolean onMenuItemClick(android.view.MenuItem item) {
            MenuItemImpl sherlockItem = (MenuItemImpl)FragmentActivity.this.mNativeItemMap.get(item);
            if (sherlockItem != null) {
                sherlockItem.invoke();
            } else {
                Log.e((String)FragmentActivity.TAG, (String)("Options item \"" + item + "\" not found in mapping"));
            }
            return true;
        }
    };
    boolean mCreated;
    boolean mResumed;
    boolean mStopped;
    boolean mReallyStopped;
    boolean mRetaining;
    boolean mOptionsMenuInvalidated;
    boolean mOptionsMenuCreateResult;
    boolean mCheckedForLoaderManager;
    boolean mLoadersStarted;
    HCSparseArray<LoaderManagerImpl> mAllLoaderManagers;
    LoaderManagerImpl mLoaderManager;

    @Override
    public SupportActivity.InternalCallbacks getInternalCallbacks() {
        return this.mInternalCallbacks;
    }

    @Override
    public Activity asActivity() {
        return this;
    }

    private void initActionBar() {
        if (this.mDecor == null) {
            this.installDecor();
        }
        if (this.mActionBar != null || !this.hasFeature(8L) || this.isChild()) {
            return;
        }
        this.mActionBar = IS_HONEYCOMB ? ActionBarWrapper.createFor(this) : new ActionBarImpl(this);
    }

    private void installDecor() {
        if (this.mDecor == null) {
            this.mDecor = IS_HONEYCOMB ? (ViewGroup)this.getWindow().getDecorView() : (ViewGroup)this.getWindow().getDecorView().findViewById(0x1020002);
        }
        if (this.mContentParent == null) {
            if (IS_HONEYCOMB) {
                this.mContentParent = (ViewGroup)this.mDecor.findViewById(0x1020002);
            } else {
                this.mContentParent = this.generateLayout();
                this.mActionBarView = (ActionBarView)this.mDecor.findViewById(R.id.abs__action_bar);
                if (this.mActionBarView != null) {
                    if (this.mActionBarView.getTitle() == null) {
                        this.mActionBarView.setTitle(this.getTitle());
                    }
                    if (this.hasFeature(5L)) {
                        this.mActionBarView.initIndeterminateProgress();
                    }
                }
                this.mDecor.post(new Runnable(){

                    @Override
                    public void run() {
                        if (FragmentActivity.this.mSupportMenu == null) {
                            FragmentActivity.this.invalidateOptionsMenu();
                        }
                    }
                });
            }
        }
    }

    private ViewGroup generateLayout() {
        TypedArray a = this.getTheme().obtainStyledAttributes(R.styleable.SherlockTheme);
        if (a.getBoolean(R.styleable.SherlockTheme_windowNoTitle, false)) {
            this.requestWindowFeature(1);
        } else if (a.getBoolean(R.styleable.SherlockTheme_windowActionBar, false)) {
            this.requestWindowFeature(8L);
        }
        if (a.getBoolean(R.styleable.SherlockTheme_windowActionBarOverlay, false)) {
            this.requestWindowFeature(9L);
        }
        if (a.getBoolean(R.styleable.SherlockTheme_windowActionModeOverlay, false)) {
            this.requestWindowFeature(10L);
        }
        a.recycle();
        int layoutResource = this.hasFeature(8L) ? (this.hasFeature(9L) ? R.layout.abs__screen_action_bar_overlay : R.layout.abs__screen_action_bar) : R.layout.abs__screen_simple;
        View in = this.getLayoutInflater().inflate(layoutResource, null);
        this.mDecor.addView(in, new ViewGroup.LayoutParams(-1, -1));
        ViewGroup contentParent = (ViewGroup)this.mDecor.findViewById(R.id.abs__content);
        if (contentParent == null) {
            throw new RuntimeException("Couldn't find content container view");
        }
        this.mDecor.setId(-1);
        contentParent.setId(0x1020002);
        return contentParent;
    }

    private boolean hasFeature(long featureId) {
        if (IS_HONEYCOMB) {
            return HoneycombHasFeature.invoke(this.getWindow(), (int)featureId);
        }
        return (this.mWindowFlags & (long)(1 << (int)featureId)) != 0L;
    }

    @Override
    public boolean requestWindowFeature(long featureId) {
        if (!IS_HONEYCOMB) {
            switch ((int)featureId) {
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    this.mWindowFlags |= (long)(1 << (int)featureId);
                    return true;
                }
            }
        }
        return super.requestWindowFeature((int)featureId);
    }

    @Override
    public MenuInflater getMenuInflater() {
        if (this.mMenuInflater == null) {
            this.initActionBar();
        }
        this.mMenuInflater = IS_HONEYCOMB ? new MenuInflaterWrapper((Context)this, super.getMenuInflater()) : new MenuInflaterImpl((Context)this, super.getMenuInflater());
        return this.mMenuInflater;
    }

    @Override
    public void setContentView(int layoutResId) {
        if (this.mContentParent == null) {
            this.installDecor();
        } else {
            this.mContentParent.removeAllViews();
        }
        this.getLayoutInflater().inflate(layoutResId, this.mContentParent);
        Window.Callback callback = this.getWindow().getCallback();
        if (callback != null) {
            callback.onContentChanged();
        }
        this.initActionBar();
    }

    @Override
    public void setContentView(View view, ViewGroup.LayoutParams params) {
        if (this.mContentParent == null) {
            this.installDecor();
        } else {
            this.mContentParent.removeAllViews();
        }
        this.mContentParent.addView(view, params);
        Window.Callback callback = this.getWindow().getCallback();
        if (callback != null) {
            callback.onContentChanged();
        }
        this.initActionBar();
    }

    @Override
    public void setContentView(View view) {
        this.setContentView(view, new ViewGroup.LayoutParams(-1, -1));
    }

    @Override
    public void addContentView(View view, ViewGroup.LayoutParams params) {
        if (this.mContentParent == null) {
            this.installDecor();
        }
        this.mContentParent.addView(view, params);
        this.initActionBar();
    }

    @Override
    public void setTitle(CharSequence title) {
        if (IS_HONEYCOMB || this.mActionBar == null) {
            super.setTitle(title);
        } else {
            this.getSupportActionBar().setTitle(title);
        }
    }

    @Override
    public void setTitle(int titleId) {
        if (IS_HONEYCOMB || this.mActionBar == null) {
            super.setTitle(titleId);
        } else {
            this.getSupportActionBar().setTitle(titleId);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        int index = requestCode >> 16;
        if (index != 0) {
            if (this.mFragments.mActive == null || --index < 0 || index >= this.mFragments.mActive.size()) {
                Log.w((String)TAG, (String)("Activity result fragment index out of range: 0x" + Integer.toHexString(requestCode)));
                return;
            }
            Fragment frag = this.mFragments.mActive.get(index);
            if (frag == null) {
                Log.w((String)TAG, (String)("Activity result no fragment exists for index: 0x" + Integer.toHexString(requestCode)));
            } else {
                frag.onActivityResult(requestCode & 0xFFFF, resultCode, data);
            }
            return;
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void onBackPressed() {
        if (!this.mFragments.popBackStackImmediate()) {
            this.finish();
        }
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mFragments.dispatchConfigurationChanged(newConfig);
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.mFragments.attachActivity(this);
        if (this.getLayoutInflater().getFactory() == null) {
            this.getLayoutInflater().setFactory((LayoutInflater.Factory)this);
        }
        super.onCreate(savedInstanceState);
        NonConfigurationInstances nc = (NonConfigurationInstances)this.getLastNonConfigurationInstance();
        if (nc != null) {
            this.mAllLoaderManagers = nc.loaders;
        }
        if (savedInstanceState != null) {
            Parcelable p = savedInstanceState.getParcelable(FRAGMENTS_TAG);
            this.mFragments.restoreAllState(p, nc != null ? nc.fragments : null);
        }
        this.mFragments.dispatchCreate();
    }

    @Override
    public boolean onCreateOptionsMenu(android.support.v4.view.Menu menu2) {
        return true;
    }

    @Override
    public final boolean onCreateOptionsMenu(Menu menu2) {
        boolean result = true;
        if (IS_HONEYCOMB) {
            MenuWrapper wrapped = new MenuWrapper(menu2);
            result = this.onCreateOptionsMenu(wrapped);
            result |= this.mFragments.dispatchCreateOptionsMenu(wrapped, this.getMenuInflater());
        }
        return result;
    }

    private boolean dispatchCreateOptionsMenu() {
        boolean result = this.onCreateOptionsMenu(this.mSupportMenu);
        return result |= this.mFragments.dispatchCreateOptionsMenu(this.mSupportMenu, this.getMenuInflater());
    }

    @Override
    public View onCreateView(String name, Context context, AttributeSet attrs) {
        Fragment fragment;
        int containerId;
        if (!"fragment".equals(name)) {
            return super.onCreateView(name, context, attrs);
        }
        String fname = attrs.getAttributeValue(null, "class");
        TypedArray a = context.obtainStyledAttributes(attrs, FragmentTag.Fragment);
        if (fname == null) {
            fname = a.getString(0);
        }
        int id2 = a.getResourceId(1, -1);
        String tag = a.getString(2);
        a.recycle();
        Object parent = null;
        int n = containerId = parent != null ? parent.getId() : 0;
        if (containerId == -1 && id2 == -1 && tag == null) {
            throw new IllegalArgumentException(attrs.getPositionDescription() + ": Must specify unique android:id, android:tag, or have a parent with an id for " + fname);
        }
        Fragment fragment2 = fragment = id2 != -1 ? this.mFragments.findFragmentById(id2) : null;
        if (fragment == null && tag != null) {
            fragment = this.mFragments.findFragmentByTag(tag);
        }
        if (fragment == null && containerId != -1) {
            fragment = this.mFragments.findFragmentById(containerId);
        }
        if (FragmentManagerImpl.DEBUG) {
            Log.v((String)TAG, (String)("onCreateView: id=0x" + Integer.toHexString(id2) + " fname=" + fname + " existing=" + fragment));
        }
        if (fragment == null) {
            fragment = Fragment.instantiate((Context)this, fname);
            fragment.mFromLayout = true;
            fragment.mFragmentId = id2 != 0 ? id2 : containerId;
            fragment.mContainerId = containerId;
            fragment.mTag = tag;
            fragment.mInLayout = true;
            fragment.mFragmentManager = this.mFragments;
            fragment.onInflate(this, attrs, fragment.mSavedFragmentState);
            this.mFragments.addFragment(fragment, true);
        } else {
            if (fragment.mInLayout) {
                throw new IllegalArgumentException(attrs.getPositionDescription() + ": Duplicate id 0x" + Integer.toHexString(id2) + ", tag " + tag + ", or parent id 0x" + Integer.toHexString(containerId) + " with another fragment for " + fname);
            }
            fragment.mInLayout = true;
            if (!fragment.mRetaining) {
                fragment.onInflate(this, attrs, fragment.mSavedFragmentState);
            }
            this.mFragments.moveToState(fragment);
        }
        if (fragment.mView == null) {
            throw new IllegalStateException("Fragment " + fname + " did not create a view.");
        }
        if (id2 != 0) {
            fragment.mView.setId(id2);
        }
        if (fragment.mView.getTag() == null) {
            fragment.mView.setTag((Object)tag);
        }
        return fragment.mView;
    }

    @Override
    public void invalidateOptionsMenu() {
        if (IS_HONEYCOMB) {
            HoneycombInvalidateOptionsMenu.invoke(this);
            return;
        }
        if (this.mSupportMenu == null) {
            this.mSupportMenu = new MenuBuilder((Context)this);
            this.mSupportMenu.setCallback(this.mSupportMenuCallback);
        }
        this.mSupportMenu.stopDispatchingItemsChanged();
        this.mSupportMenu.clear();
        if (!this.dispatchCreateOptionsMenu()) {
            if (this.mActionBar != null) {
                ((ActionBarImpl)this.mActionBar).setMenu(null, this.mMenuPresenterCallback);
            }
            return;
        }
        if (!this.dispatchPrepareOptionsMenu()) {
            if (this.mActionBar != null) {
                ((ActionBarImpl)this.mActionBar).setMenu(null, this.mMenuPresenterCallback);
            }
            this.mSupportMenu.startDispatchingItemsChanged();
            return;
        }
        this.mSupportMenu.startDispatchingItemsChanged();
        if (this.mActionBar != null) {
            ((ActionBarImpl)this.mActionBar).setMenu(this.mSupportMenu, this.mMenuPresenterCallback);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.doReallyStop(false);
        this.mFragments.dispatchDestroy();
        if (this.mLoaderManager != null) {
            this.mLoaderManager.doDestroy();
        }
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (Build.VERSION.SDK_INT < 5 && keyCode == 4 && event.getRepeatCount() == 0) {
            this.onBackPressed();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void onLowMemory() {
        super.onLowMemory();
        this.mFragments.dispatchLowMemory();
    }

    @Override
    public final boolean onMenuItemSelected(int featureId, android.view.MenuItem item) {
        if (super.onMenuItemSelected(featureId, item)) {
            return true;
        }
        switch (featureId) {
            case 0: {
                return this.mFragments.dispatchOptionsItemSelected(new MenuItemWrapper(item));
            }
            case 6: {
                return this.mFragments.dispatchContextItemSelected(new MenuItemWrapper(item));
            }
        }
        return false;
    }

    @Override
    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        if (this.onOptionsItemSelected(item)) {
            return true;
        }
        switch (featureId) {
            case 0: {
                return this.mFragments.dispatchOptionsItemSelected(item);
            }
            case 6: {
                return this.mFragments.dispatchContextItemSelected(item);
            }
        }
        return false;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        return super.onOptionsItemSelected((android.view.MenuItem)item);
    }

    @Override
    public final boolean onOptionsItemSelected(android.view.MenuItem item) {
        return this.onOptionsItemSelected(new MenuItemWrapper(item));
    }

    @Override
    public void onPanelClosed(int featureId, Menu menu2) {
        switch (featureId) {
            case 0: {
                this.mFragments.dispatchOptionsMenuClosed(new MenuWrapper(menu2));
                if (IS_HONEYCOMB || this.getSupportActionBar() == null) break;
                ((ActionBarImpl)this.mActionBar).onMenuVisibilityChanged(false);
            }
        }
        super.onPanelClosed(featureId, menu2);
    }

    protected void onPause() {
        super.onPause();
        this.mResumed = false;
        if (this.mHandler.hasMessages(2)) {
            this.mHandler.removeMessages(2);
            this.mFragments.dispatchResume();
        }
        this.mFragments.dispatchPause();
    }

    protected void onResume() {
        super.onResume();
        this.mHandler.sendEmptyMessage(2);
        this.mResumed = true;
        this.mFragments.execPendingActions();
    }

    protected void onPostResume() {
        super.onPostResume();
        this.mHandler.removeMessages(2);
        this.mFragments.dispatchResume();
        this.mFragments.execPendingActions();
    }

    @Override
    public boolean onPrepareOptionsMenu(android.support.v4.view.Menu menu2) {
        return true;
    }

    @Override
    public final boolean onPrepareOptionsMenu(Menu menu2) {
        if (IS_HONEYCOMB) {
            MenuWrapper wrappedMenu = new MenuWrapper(menu2);
            boolean result = this.onPrepareOptionsMenu(wrappedMenu);
            if (result) {
                this.mFragments.dispatchPrepareOptionsMenu(wrappedMenu);
            }
            return result;
        }
        if (!this.dispatchPrepareOptionsMenu()) {
            return false;
        }
        if (this.mNativeItemMap == null) {
            this.mNativeItemMap = new HashMap();
        } else {
            this.mNativeItemMap.clear();
        }
        if (this.mSupportMenu != null) {
            return this.mSupportMenu.bindOverflowToNative(menu2, this.mNativeItemListener, this.mNativeItemMap);
        }
        return false;
    }

    private boolean dispatchPrepareOptionsMenu() {
        boolean result = this.onPrepareOptionsMenu(this.mSupportMenu);
        return result |= this.mFragments.dispatchPrepareOptionsMenu(this.mSupportMenu);
    }

    @Override
    public void recreate() {
        Intent intent = this.getIntent();
        intent.addFlags(65536);
        this.startActivity(intent);
        if (Build.VERSION.SDK_INT >= 5) {
            OverridePendingTransition.invoke(this);
        }
        this.finish();
        if (Build.VERSION.SDK_INT >= 5) {
            OverridePendingTransition.invoke(this);
        }
    }

    @Override
    public final Object onRetainNonConfigurationInstance() {
        if (this.mStopped) {
            this.doReallyStop(true);
        }
        Object custom = this.onRetainCustomNonConfigurationInstance();
        ArrayList<Fragment> fragments = this.mFragments.retainNonConfig();
        boolean retainLoaders = false;
        if (this.mAllLoaderManagers != null) {
            for (int i = this.mAllLoaderManagers.size() - 1; i >= 0; --i) {
                LoaderManagerImpl lm = this.mAllLoaderManagers.valueAt(i);
                if (lm.mRetaining) {
                    retainLoaders = true;
                    continue;
                }
                lm.doDestroy();
                this.mAllLoaderManagers.removeAt(i);
            }
        }
        if (fragments == null && !retainLoaders && custom == null) {
            return null;
        }
        NonConfigurationInstances nci = new NonConfigurationInstances();
        nci.activity = null;
        nci.custom = custom;
        nci.children = null;
        nci.fragments = fragments;
        nci.loaders = this.mAllLoaderManagers;
        return nci;
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        Parcelable p = this.mFragments.saveAllState();
        if (p != null) {
            outState.putParcelable(FRAGMENTS_TAG, p);
        }
    }

    protected void onStart() {
        super.onStart();
        this.mStopped = false;
        this.mReallyStopped = false;
        this.mHandler.removeMessages(1);
        if (!this.mCreated) {
            this.mCreated = true;
            this.mFragments.dispatchActivityCreated();
        }
        this.mFragments.noteStateNotSaved();
        this.mFragments.execPendingActions();
        if (!this.mLoadersStarted) {
            this.mLoadersStarted = true;
            if (this.mLoaderManager != null) {
                this.mLoaderManager.doStart();
            } else if (!this.mCheckedForLoaderManager) {
                this.mLoaderManager = this.getLoaderManager(-1, this.mLoadersStarted, false);
            }
            this.mCheckedForLoaderManager = true;
        }
        this.mFragments.dispatchStart();
        if (this.mAllLoaderManagers != null) {
            for (int i = this.mAllLoaderManagers.size() - 1; i >= 0; --i) {
                LoaderManagerImpl lm = this.mAllLoaderManagers.valueAt(i);
                lm.finishRetain();
                lm.doReportStart();
            }
        }
    }

    protected void onStop() {
        super.onStop();
        this.mStopped = true;
        this.mHandler.sendEmptyMessage(1);
        this.mFragments.dispatchStop();
    }

    @Override
    public void setProgressBarIndeterminateVisibility(Boolean visible) {
        if (IS_HONEYCOMB || this.mActionBar == null) {
            super.setProgressBarIndeterminateVisibility(visible.booleanValue());
        } else {
            this.mActionBarView.setProgressBarIndeterminateVisibility(visible);
        }
    }

    public Object onRetainCustomNonConfigurationInstance() {
        return null;
    }

    public Object getLastCustomNonConfigurationInstance() {
        NonConfigurationInstances nc = (NonConfigurationInstances)this.getLastNonConfigurationInstance();
        return nc != null ? nc.custom : null;
    }

    @Deprecated
    void supportInvalidateOptionsMenu() {
        this.invalidateOptionsMenu();
    }

    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        if (IS_HONEYCOMB) {
            // empty if block
        }
        writer.print(prefix);
        writer.print("Local FragmentActivity ");
        writer.print(Integer.toHexString(System.identityHashCode(this)));
        writer.println(" State:");
        String innerPrefix = prefix + "  ";
        writer.print(innerPrefix);
        writer.print("mCreated=");
        writer.print(this.mCreated);
        writer.print("mResumed=");
        writer.print(this.mResumed);
        writer.print(" mStopped=");
        writer.print(this.mStopped);
        writer.print(" mReallyStopped=");
        writer.println(this.mReallyStopped);
        writer.print(innerPrefix);
        writer.print("mLoadersStarted=");
        writer.println(this.mLoadersStarted);
        if (this.mLoaderManager != null) {
            writer.print(prefix);
            writer.print("Loader Manager ");
            writer.print(Integer.toHexString(System.identityHashCode(this.mLoaderManager)));
            writer.println(":");
            this.mLoaderManager.dump(prefix + "  ", fd, writer, args);
        }
        this.mFragments.dump(prefix, fd, writer, args);
    }

    void doReallyStop(boolean retaining) {
        if (!this.mReallyStopped) {
            this.mReallyStopped = true;
            this.mRetaining = retaining;
            this.mHandler.removeMessages(1);
            this.onReallyStop();
        }
    }

    void onReallyStop() {
        if (this.mLoadersStarted) {
            this.mLoadersStarted = false;
            if (this.mLoaderManager != null) {
                if (!this.mRetaining) {
                    this.mLoaderManager.doStop();
                } else {
                    this.mLoaderManager.doRetain();
                }
            }
        }
        this.mFragments.dispatchReallyStop();
    }

    @Override
    public ActionBar getSupportActionBar() {
        this.initActionBar();
        return this.mActionBar;
    }

    @Override
    public void onActionModeFinished(ActionMode mode) {
    }

    @Override
    public void onActionModeStarted(ActionMode mode) {
    }

    @Override
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback) {
        return null;
    }

    @Override
    public final ActionMode startActionMode(ActionMode.Callback callback) {
        ActionMode actionMode = this.onWindowStartingActionMode(callback);
        if (actionMode == null) {
            actionMode = this.mActionBar.startActionMode(callback);
        }
        if (actionMode != null) {
            this.onActionModeStarted(actionMode);
        }
        return actionMode;
    }

    @Override
    public void onAttachFragment(Fragment fragment) {
    }

    @Override
    public FragmentManager getSupportFragmentManager() {
        this.initActionBar();
        return this.mFragments;
    }

    @Override
    public void startActivityForResult(Intent intent, int requestCode) {
        if (requestCode != -1 && (requestCode & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("Can only use lower 16 bits for requestCode");
        }
        super.startActivityForResult(intent, requestCode);
    }

    @Override
    public void startActivityFromFragment(Fragment fragment, Intent intent, int requestCode) {
        if (requestCode == -1) {
            super.startActivityForResult(intent, -1);
            return;
        }
        if ((requestCode & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("Can only use lower 16 bits for requestCode");
        }
        super.startActivityForResult(intent, (fragment.mIndex + 1 << 16) + (requestCode & 0xFFFF));
    }

    void invalidateSupportFragmentIndex(int index) {
        LoaderManagerImpl lm;
        if (this.mAllLoaderManagers != null && (lm = this.mAllLoaderManagers.get(index)) != null && !lm.mRetaining) {
            lm.doDestroy();
            this.mAllLoaderManagers.remove(index);
        }
    }

    @Override
    public LoaderManager getSupportLoaderManager() {
        if (this.mLoaderManager != null) {
            return this.mLoaderManager;
        }
        this.mCheckedForLoaderManager = true;
        this.mLoaderManager = this.getLoaderManager(-1, this.mLoadersStarted, true);
        return this.mLoaderManager;
    }

    LoaderManagerImpl getLoaderManager(int index, boolean started, boolean create) {
        LoaderManagerImpl lm;
        if (this.mAllLoaderManagers == null) {
            this.mAllLoaderManagers = new HCSparseArray();
        }
        if ((lm = this.mAllLoaderManagers.get(index)) == null) {
            if (create) {
                lm = new LoaderManagerImpl(this, started);
                this.mAllLoaderManagers.put(index, lm);
            }
        } else {
            lm.updateActivity(this);
        }
        return lm;
    }

    private static final class OverridePendingTransition {
        private OverridePendingTransition() {
        }

        static void invoke(Activity activity) {
            activity.overridePendingTransition(0, 0);
        }
    }

    private static final class HoneycombInvalidateOptionsMenu {
        private HoneycombInvalidateOptionsMenu() {
        }

        static void invoke(Activity activity) {
            activity.getWindow().invalidatePanelMenu(0);
        }
    }

    private static final class HoneycombHasFeature {
        private HoneycombHasFeature() {
        }

        public static boolean invoke(Window window, int featureId) {
            return window.hasFeature(featureId);
        }
    }

    static class FragmentTag {
        public static final int[] Fragment = new int[]{0x1010003, 0x10100D0, 0x10100D1};
        public static final int Fragment_id = 1;
        public static final int Fragment_name = 0;
        public static final int Fragment_tag = 2;

        FragmentTag() {
        }
    }

    static final class NonConfigurationInstances {
        Object activity;
        Object custom;
        HashMap<String, Object> children;
        ArrayList<Fragment> fragments;
        HCSparseArray<LoaderManagerImpl> loaders;

        NonConfigurationInstances() {
        }
    }
}

