/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.TextView;

public class PagerTitleStrip
extends ViewGroup
implements ViewPager.Decor {
    ViewPager mPager;
    private TextView mPrevText;
    private TextView mCurrText;
    private TextView mNextText;
    private int mLastKnownCurrentPage = -1;
    private float mLastKnownPositionOffset = -1.0f;
    private int mScaledTextSpacing;
    private boolean mUpdatingText;
    private boolean mUpdatingPositions;
    private final PageListener mPageListener = new PageListener();
    private static final int[] ATTRS = new int[]{16842804, 16842904, 16842901};
    private static final int SIDE_ALPHA = 153;
    private static final int TEXT_SPACING = 16;

    public PagerTitleStrip(Context context) {
        this(context, null);
    }

    public PagerTitleStrip(Context context, AttributeSet attrs) {
        super(context, attrs);
        int textSize;
        this.mPrevText = new TextView(context);
        this.addView((View)this.mPrevText);
        this.mCurrText = new TextView(context);
        this.addView((View)this.mCurrText);
        this.mNextText = new TextView(context);
        this.addView((View)this.mNextText);
        TypedArray a = context.obtainStyledAttributes(attrs, ATTRS);
        int textAppearance = a.getResourceId(0, 0);
        if (textAppearance != 0) {
            this.mPrevText.setTextAppearance(context, textAppearance);
            this.mCurrText.setTextAppearance(context, textAppearance);
            this.mNextText.setTextAppearance(context, textAppearance);
        }
        if (a.hasValue(1)) {
            int textColor = a.getColor(1, 0);
            this.mPrevText.setTextColor(textColor);
            this.mCurrText.setTextColor(textColor);
            this.mNextText.setTextColor(textColor);
        }
        if ((textSize = a.getDimensionPixelSize(2, 0)) != 0) {
            this.mPrevText.setTextSize(0, (float)textSize);
            this.mCurrText.setTextSize(0, (float)textSize);
            this.mNextText.setTextSize(0, (float)textSize);
        }
        a.recycle();
        int defaultColor = this.mPrevText.getTextColors().getDefaultColor();
        int transparentColor = 0x99000000 | defaultColor & 0xFFFFFF;
        this.mPrevText.setTextColor(transparentColor);
        this.mNextText.setTextColor(transparentColor);
        this.mPrevText.setEllipsize(TextUtils.TruncateAt.END);
        this.mCurrText.setEllipsize(TextUtils.TruncateAt.END);
        this.mNextText.setEllipsize(TextUtils.TruncateAt.END);
        this.mPrevText.setSingleLine();
        this.mCurrText.setSingleLine();
        this.mNextText.setSingleLine();
        float density = context.getResources().getDisplayMetrics().density;
        this.mScaledTextSpacing = (int)(16.0f * density);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewParent parent = this.getParent();
        if (!(parent instanceof ViewPager)) {
            throw new IllegalStateException("PagerTitleStrip must be a direct child of a ViewPager.");
        }
        ViewPager pager = (ViewPager)parent;
        PagerAdapter adapter = pager.getAdapter();
        pager.setInternalPageChangeListener(this.mPageListener);
        pager.setOnAdapterChangeListener(this.mPageListener);
        this.mPager = pager;
        this.updateAdapter(null, adapter);
    }

    protected void onDetachedFromWindow() {
        this.updateAdapter(this.mPager.getAdapter(), null);
        this.mPager.setInternalPageChangeListener(null);
        this.mPager.setOnAdapterChangeListener(null);
        this.mPager = null;
    }

    void updateText(int currentItem, PagerAdapter adapter) {
        int itemCount = adapter != null ? adapter.getCount() : 0;
        this.mUpdatingText = true;
        CharSequence text = null;
        if (currentItem >= 1 && adapter != null) {
            text = adapter.getPageTitle(currentItem - 1);
        }
        this.mPrevText.setText(text);
        this.mCurrText.setText(adapter != null ? adapter.getPageTitle(currentItem) : null);
        text = null;
        if (currentItem + 1 < itemCount && adapter != null) {
            text = adapter.getPageTitle(currentItem + 1);
        }
        this.mNextText.setText(text);
        int width = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int childHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int childWidthSpec = View.MeasureSpec.makeMeasureSpec((int)((int)((float)width * 0.8f)), (int)Integer.MIN_VALUE);
        int childHeightSpec = View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000);
        this.mPrevText.measure(childWidthSpec, childHeightSpec);
        this.mCurrText.measure(childWidthSpec, childHeightSpec);
        this.mNextText.measure(childWidthSpec, childHeightSpec);
        this.mLastKnownCurrentPage = currentItem;
        if (!this.mUpdatingPositions) {
            this.updateTextPositions(currentItem, this.mLastKnownPositionOffset);
        }
        this.mUpdatingText = false;
    }

    public void requestLayout() {
        if (!this.mUpdatingText) {
            super.requestLayout();
        }
    }

    void updateAdapter(PagerAdapter oldAdapter, PagerAdapter newAdapter) {
        if (oldAdapter != null) {
            oldAdapter.unregisterDataSetObserver(this.mPageListener);
        }
        if (newAdapter != null) {
            newAdapter.registerDataSetObserver(this.mPageListener);
        }
        if (this.mPager != null) {
            this.mLastKnownCurrentPage = -1;
            this.mLastKnownPositionOffset = -1.0f;
            this.updateText(this.mPager.getCurrentItem(), newAdapter);
            this.requestLayout();
        }
    }

    void updateTextPositions(int position, float positionOffset) {
        if (position != this.mLastKnownCurrentPage) {
            this.updateText(position, this.mPager.getAdapter());
        } else if (positionOffset == this.mLastKnownPositionOffset) {
            return;
        }
        this.mUpdatingPositions = true;
        int prevWidth = this.mPrevText.getMeasuredWidth();
        int currWidth = this.mCurrText.getMeasuredWidth();
        int nextWidth = this.mNextText.getMeasuredWidth();
        int halfCurrWidth = currWidth / 2;
        int stripWidth = this.getWidth();
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int textPaddedLeft = paddingLeft + halfCurrWidth;
        int textPaddedRight = paddingRight + halfCurrWidth;
        int contentWidth = stripWidth - textPaddedLeft - textPaddedRight;
        float currOffset = positionOffset + 0.5f;
        if (currOffset > 1.0f) {
            currOffset -= 1.0f;
        }
        int currCenter = stripWidth - textPaddedRight - (int)((float)contentWidth * currOffset);
        int currLeft = currCenter - currWidth / 2;
        int currRight = currLeft + currWidth;
        this.mCurrText.layout(currLeft, paddingTop, currRight, paddingTop + this.mCurrText.getMeasuredHeight());
        int prevLeft = Math.min(paddingLeft, currLeft - this.mScaledTextSpacing - prevWidth);
        this.mPrevText.layout(prevLeft, paddingTop, prevLeft + prevWidth, paddingTop + this.mPrevText.getMeasuredHeight());
        int nextLeft = Math.max(stripWidth - paddingRight - nextWidth, currRight + this.mScaledTextSpacing);
        this.mNextText.layout(nextLeft, paddingTop, nextLeft + nextWidth, paddingTop + this.mNextText.getMeasuredHeight());
        this.mLastKnownPositionOffset = positionOffset;
        this.mUpdatingPositions = false;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode != 0x40000000) {
            throw new IllegalStateException("Must measure with an exact width");
        }
        int childHeight = heightSize;
        int minHeight = 0;
        int padding = 0;
        Drawable bg = this.getBackground();
        if (bg != null) {
            minHeight = bg.getIntrinsicHeight();
        }
        padding = this.getPaddingTop() + this.getPaddingBottom();
        int childWidthSpec = View.MeasureSpec.makeMeasureSpec((int)((int)((float)widthSize * 0.8f)), (int)Integer.MIN_VALUE);
        int childHeightSpec = View.MeasureSpec.makeMeasureSpec((int)(childHeight -= padding), (int)heightMode);
        this.mPrevText.measure(childWidthSpec, childHeightSpec);
        this.mCurrText.measure(childWidthSpec, childHeightSpec);
        this.mNextText.measure(childWidthSpec, childHeightSpec);
        if (heightMode == 0x40000000) {
            this.setMeasuredDimension(widthSize, heightSize);
        } else {
            int textHeight = this.mCurrText.getMeasuredHeight();
            this.setMeasuredDimension(widthSize, Math.max(minHeight, textHeight + padding));
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mPager != null) {
            this.updateTextPositions(this.mPager.getCurrentItem(), 0.0f);
        }
    }

    private class PageListener
    extends DataSetObserver
    implements ViewPager.OnPageChangeListener,
    ViewPager.OnAdapterChangeListener {
        private int mScrollState;

        private PageListener() {
        }

        @Override
        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (positionOffset > 0.5f) {
                ++position;
            }
            PagerTitleStrip.this.updateTextPositions(position, positionOffset);
        }

        @Override
        public void onPageSelected(int position) {
            if (this.mScrollState == 0) {
                PagerTitleStrip.this.updateText(PagerTitleStrip.this.mPager.getCurrentItem(), PagerTitleStrip.this.mPager.getAdapter());
            }
        }

        @Override
        public void onPageScrollStateChanged(int state) {
            this.mScrollState = state;
        }

        @Override
        public void onAdapterChanged(PagerAdapter oldAdapter, PagerAdapter newAdapter) {
            PagerTitleStrip.this.updateAdapter(oldAdapter, newAdapter);
        }

        public void onChanged() {
            PagerTitleStrip.this.updateText(PagerTitleStrip.this.mPager.getCurrentItem(), PagerTitleStrip.this.mPager.getAdapter());
        }
    }
}

