/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view.accessibility;

import android.support.v4.view.accessibility.AccessibilityRecordCompat;
import android.view.accessibility.AccessibilityEvent;

public class AccessibilityEventCompat {
    private static final AccessibilityEventVersionImpl IMPL = new AccessibilityEventStubImpl();
    public static final int TYPE_VIEW_HOVER_ENTER = 128;
    public static final int TYPE_VIEW_HOVER_EXIT = 256;
    public static final int TYPE_TOUCH_EXPLORATION_GESTURE_START = 512;
    public static final int TYPE_TOUCH_EXPLORATION_GESTURE_END = 1024;
    public static final int TYPE_WINDOW_CONTENT_CHANGED = 2048;
    public static final int TYPE_VIEW_SCROLLED = 4096;
    public static final int TYPE_VIEW_TEXT_SELECTION_CHANGED = 8192;

    private AccessibilityEventCompat() {
    }

    public static int getRecordCount(AccessibilityEvent event) {
        return IMPL.getRecordCount(event);
    }

    public static void appendRecord(AccessibilityEvent event, AccessibilityRecordCompat record) {
        IMPL.appendRecord(event, record.getImpl());
    }

    public static AccessibilityRecordCompat getRecord(AccessibilityEvent event, int index) {
        return new AccessibilityRecordCompat(IMPL.getRecord(event, index));
    }

    static class AccessibilityEventStubImpl
    implements AccessibilityEventVersionImpl {
        AccessibilityEventStubImpl() {
        }

        @Override
        public void appendRecord(AccessibilityEvent event, Object record) {
        }

        @Override
        public Object getRecord(AccessibilityEvent event, int index) {
            return null;
        }

        @Override
        public int getRecordCount(AccessibilityEvent event) {
            return 0;
        }
    }

    static interface AccessibilityEventVersionImpl {
        public int getRecordCount(AccessibilityEvent var1);

        public void appendRecord(AccessibilityEvent var1, Object var2);

        public Object getRecord(AccessibilityEvent var1, int var2);
    }
}

