/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view.accessibility;

import android.os.Parcelable;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.view.View;
import java.util.Collections;
import java.util.List;

public class AccessibilityRecordCompat {
    private static final AccessibilityRecordImpl IMPL = new AccessibilityRecordStubImpl();
    private final Object mRecord;

    public AccessibilityRecordCompat(Object record) {
        this.mRecord = record;
    }

    public Object getImpl() {
        return this.mRecord;
    }

    public static AccessibilityRecordCompat obtain(AccessibilityRecordCompat record) {
        return new AccessibilityRecordCompat(IMPL.obtain(record.mRecord));
    }

    public static AccessibilityRecordCompat obtain() {
        return new AccessibilityRecordCompat(IMPL.obtain());
    }

    public void setSource(View source) {
        IMPL.setSource(this.mRecord, source);
    }

    public AccessibilityNodeInfoCompat getSource() {
        return new AccessibilityNodeInfoCompat(IMPL.getSource(this.mRecord));
    }

    public int getWindowId() {
        return IMPL.getWindowId(this.mRecord);
    }

    public boolean isChecked() {
        return IMPL.isChecked(this.mRecord);
    }

    public void setChecked(boolean isChecked) {
        IMPL.setChecked(this.mRecord, isChecked);
    }

    public boolean isEnabled() {
        return IMPL.isEnabled(this.mRecord);
    }

    public void setEnabled(boolean isEnabled) {
        IMPL.setEnabled(this.mRecord, isEnabled);
    }

    public boolean isPassword() {
        return IMPL.isPassword(this.mRecord);
    }

    public void setPassword(boolean isPassword) {
        IMPL.setPassword(this.mRecord, isPassword);
    }

    public boolean isFullScreen() {
        return IMPL.isFullScreen(this.mRecord);
    }

    public void setFullScreen(boolean isFullScreen) {
        IMPL.setFullScreen(this.mRecord, isFullScreen);
    }

    public boolean isScrollable() {
        return IMPL.isScrollable(this.mRecord);
    }

    public void setScrollable(boolean scrollable) {
        IMPL.setScrollable(this.mRecord, scrollable);
    }

    public int getItemCount() {
        return IMPL.getItemCount(this.mRecord);
    }

    public void setItemCount(int itemCount) {
        IMPL.setItemCount(this.mRecord, itemCount);
    }

    public int getCurrentItemIndex() {
        return IMPL.getCurrentItemIndex(this.mRecord);
    }

    public void setCurrentItemIndex(int currentItemIndex) {
        IMPL.setCurrentItemIndex(this.mRecord, currentItemIndex);
    }

    public int getFromIndex() {
        return IMPL.getFromIndex(this.mRecord);
    }

    public void setFromIndex(int fromIndex) {
        IMPL.setFromIndex(this.mRecord, fromIndex);
    }

    public int getToIndex() {
        return IMPL.getToIndex(this.mRecord);
    }

    public void setToIndex(int toIndex) {
        IMPL.setToIndex(this.mRecord, toIndex);
    }

    public int getScrollX() {
        return IMPL.getScrollX(this.mRecord);
    }

    public void setScrollX(int scrollX) {
        IMPL.setScrollX(this.mRecord, scrollX);
    }

    public int getScrollY() {
        return IMPL.getScrollY(this.mRecord);
    }

    public void setScrollY(int scrollY) {
        IMPL.setScrollY(this.mRecord, scrollY);
    }

    public int getAddedCount() {
        return IMPL.getAddedCount(this.mRecord);
    }

    public void setAddedCount(int addedCount) {
        IMPL.setAddedCount(this.mRecord, addedCount);
    }

    public int getRemovedCount() {
        return IMPL.getRemovedCount(this.mRecord);
    }

    public void setRemovedCount(int removedCount) {
        IMPL.setRemovedCount(this.mRecord, removedCount);
    }

    public CharSequence getClassName() {
        return IMPL.getClassName(this.mRecord);
    }

    public void setClassName(CharSequence className) {
        IMPL.setClassName(this.mRecord, className);
    }

    public List<CharSequence> getText() {
        return IMPL.getText(this.mRecord);
    }

    public CharSequence getBeforeText() {
        return IMPL.getBeforeText(this.mRecord);
    }

    public void setBeforeText(CharSequence beforeText) {
        IMPL.setBeforeText(this.mRecord, beforeText);
    }

    public CharSequence getContentDescription() {
        return IMPL.getContentDescription(this.mRecord);
    }

    public void setContentDescription(CharSequence contentDescription) {
        IMPL.setContentDescription(this.mRecord, contentDescription);
    }

    public Parcelable getParcelableData() {
        return IMPL.getParcelableData(this.mRecord);
    }

    public void setParcelableData(Parcelable parcelableData) {
        IMPL.setParcelableData(this.mRecord, parcelableData);
    }

    public void recycle() {
        IMPL.recycle(this.mRecord);
    }

    public int hashCode() {
        return this.mRecord == null ? 0 : this.mRecord.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessibilityRecordCompat other = (AccessibilityRecordCompat)obj;
        return !(this.mRecord == null ? other.mRecord != null : !this.mRecord.equals(other.mRecord));
    }

    static class AccessibilityRecordStubImpl
    implements AccessibilityRecordImpl {
        AccessibilityRecordStubImpl() {
        }

        @Override
        public Object obtain() {
            return null;
        }

        @Override
        public Object obtain(Object record) {
            return null;
        }

        @Override
        public int getAddedCount(Object record) {
            return 0;
        }

        @Override
        public CharSequence getBeforeText(Object record) {
            return null;
        }

        @Override
        public CharSequence getClassName(Object record) {
            return null;
        }

        @Override
        public CharSequence getContentDescription(Object record) {
            return null;
        }

        @Override
        public int getCurrentItemIndex(Object record) {
            return 0;
        }

        @Override
        public int getFromIndex(Object record) {
            return 0;
        }

        @Override
        public int getItemCount(Object record) {
            return 0;
        }

        @Override
        public int getMaxScrollX(Object record) {
            return 0;
        }

        @Override
        public int getMaxScrollY(Object record) {
            return 0;
        }

        @Override
        public Parcelable getParcelableData(Object record) {
            return null;
        }

        @Override
        public int getRemovedCount(Object record) {
            return 0;
        }

        @Override
        public int getScrollX(Object record) {
            return 0;
        }

        @Override
        public int getScrollY(Object record) {
            return 0;
        }

        @Override
        public Object getSource(Object record) {
            return null;
        }

        @Override
        public List<CharSequence> getText(Object record) {
            return Collections.emptyList();
        }

        @Override
        public int getToIndex(Object record) {
            return 0;
        }

        @Override
        public int getWindowId(Object record) {
            return 0;
        }

        @Override
        public boolean isChecked(Object record) {
            return false;
        }

        @Override
        public boolean isEnabled(Object record) {
            return false;
        }

        @Override
        public boolean isFullScreen(Object record) {
            return false;
        }

        @Override
        public boolean isPassword(Object record) {
            return false;
        }

        @Override
        public boolean isScrollable(Object record) {
            return false;
        }

        @Override
        public void recycle(Object record) {
        }

        @Override
        public void setAddedCount(Object record, int addedCount) {
        }

        @Override
        public void setBeforeText(Object record, CharSequence beforeText) {
        }

        @Override
        public void setChecked(Object record, boolean isChecked) {
        }

        @Override
        public void setClassName(Object record, CharSequence className) {
        }

        @Override
        public void setContentDescription(Object record, CharSequence contentDescription) {
        }

        @Override
        public void setCurrentItemIndex(Object record, int currentItemIndex) {
        }

        @Override
        public void setEnabled(Object record, boolean isEnabled) {
        }

        @Override
        public void setFromIndex(Object record, int fromIndex) {
        }

        @Override
        public void setFullScreen(Object record, boolean isFullScreen) {
        }

        @Override
        public void setItemCount(Object record, int itemCount) {
        }

        @Override
        public void setMaxScrollX(Object record, int maxScrollX) {
        }

        @Override
        public void setMaxScrollY(Object record, int maxScrollY) {
        }

        @Override
        public void setParcelableData(Object record, Parcelable parcelableData) {
        }

        @Override
        public void setPassword(Object record, boolean isPassword) {
        }

        @Override
        public void setRemovedCount(Object record, int removedCount) {
        }

        @Override
        public void setScrollX(Object record, int scrollX) {
        }

        @Override
        public void setScrollY(Object record, int scrollY) {
        }

        @Override
        public void setScrollable(Object record, boolean scrollable) {
        }

        @Override
        public void setSource(Object record, View source) {
        }

        @Override
        public void setToIndex(Object record, int toIndex) {
        }
    }

    static interface AccessibilityRecordImpl {
        public Object obtain();

        public Object obtain(Object var1);

        public void setSource(Object var1, View var2);

        public Object getSource(Object var1);

        public int getWindowId(Object var1);

        public boolean isChecked(Object var1);

        public void setChecked(Object var1, boolean var2);

        public boolean isEnabled(Object var1);

        public void setEnabled(Object var1, boolean var2);

        public boolean isPassword(Object var1);

        public void setPassword(Object var1, boolean var2);

        public boolean isFullScreen(Object var1);

        public void setFullScreen(Object var1, boolean var2);

        public boolean isScrollable(Object var1);

        public void setScrollable(Object var1, boolean var2);

        public int getItemCount(Object var1);

        public void setItemCount(Object var1, int var2);

        public int getCurrentItemIndex(Object var1);

        public void setCurrentItemIndex(Object var1, int var2);

        public int getFromIndex(Object var1);

        public void setFromIndex(Object var1, int var2);

        public int getToIndex(Object var1);

        public void setToIndex(Object var1, int var2);

        public int getScrollX(Object var1);

        public void setScrollX(Object var1, int var2);

        public int getScrollY(Object var1);

        public void setScrollY(Object var1, int var2);

        public int getMaxScrollX(Object var1);

        public void setMaxScrollX(Object var1, int var2);

        public int getMaxScrollY(Object var1);

        public void setMaxScrollY(Object var1, int var2);

        public int getAddedCount(Object var1);

        public void setAddedCount(Object var1, int var2);

        public int getRemovedCount(Object var1);

        public void setRemovedCount(Object var1, int var2);

        public CharSequence getClassName(Object var1);

        public void setClassName(Object var1, CharSequence var2);

        public List<CharSequence> getText(Object var1);

        public CharSequence getBeforeText(Object var1);

        public void setBeforeText(Object var1, CharSequence var2);

        public CharSequence getContentDescription(Object var1);

        public void setContentDescription(Object var1, CharSequence var2);

        public Parcelable getParcelableData(Object var1);

        public void setParcelableData(Object var1, Parcelable var2);

        public void recycle(Object var1);
    }
}

