/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.app;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.app.ActionBar;
import android.support.v4.view.ActionMode;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.SpinnerAdapter;
import com.actionbarsherlock.internal.view.menu.MenuBuilder;
import com.actionbarsherlock.internal.view.menu.MenuPresenter;
import com.actionbarsherlock.internal.widget.ActionBarContainer;
import com.actionbarsherlock.internal.widget.ActionBarView;
import com.ushahidi.android.app.R;
import java.util.ArrayList;
import java.util.List;

public final class ActionBarImpl
extends ActionBar {
    private Context mContext;
    private ActionBarContainer mContainerView;
    private ActionBarView mActionView;
    private final List<ActionBar.OnMenuVisibilityListener> mMenuListeners = new ArrayList<ActionBar.OnMenuVisibilityListener>();
    private Animation mFadeInAnimation;
    private Animation mFadeOutAnimation;

    public ActionBarImpl(Activity activity) {
        Window window = activity.getWindow();
        View decor = window.getDecorView();
        this.init(decor);
    }

    private void init(View decor) {
        this.mContext = decor.getContext();
        this.mActionView = (ActionBarView)decor.findViewById(R.id.abs__action_bar);
        this.mContainerView = (ActionBarContainer)decor.findViewById(R.id.abs__action_bar_container);
        if (this.mActionView == null || this.mContainerView == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " can only be used with a screen_*.xml layout");
        }
        this.mFadeInAnimation = AnimationUtils.loadAnimation((Context)this.mContext, (int)0x10A0000);
        this.mFadeOutAnimation = AnimationUtils.loadAnimation((Context)this.mContext, (int)0x10A0001);
    }

    public void setMenu(MenuBuilder menu, MenuPresenter.Callback cb) {
        this.mActionView.setMenu(menu, cb);
    }

    public void onMenuVisibilityChanged(boolean isVisible) {
        for (ActionBar.OnMenuVisibilityListener listener : this.mMenuListeners) {
            listener.onMenuVisibilityChanged(isVisible);
        }
    }

    @Override
    protected ActionMode startActionMode(ActionMode.Callback callback) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void addOnMenuVisibilityListener(ActionBar.OnMenuVisibilityListener listener) {
        if (!this.mMenuListeners.contains(listener)) {
            this.mMenuListeners.add(listener);
        }
    }

    @Override
    public void addTab(ActionBar.Tab tab) {
        this.mActionView.addTab(tab);
    }

    @Override
    public void addTab(ActionBar.Tab tab, boolean setSelected) {
        this.mActionView.addTab(tab, setSelected);
    }

    @Override
    public void addTab(ActionBar.Tab tab, int position) {
        this.mActionView.addTab(tab, position);
    }

    @Override
    public void addTab(ActionBar.Tab tab, int position, boolean setSelected) {
        this.mActionView.addTab(tab, position, setSelected);
    }

    @Override
    public View getCustomView() {
        return this.mActionView.getCustomView();
    }

    @Override
    public int getDisplayOptions() {
        return this.mActionView.getDisplayOptions();
    }

    @Override
    public int getHeight() {
        return this.mActionView.getHeight();
    }

    @Override
    public int getNavigationItemCount() {
        switch (this.mActionView.getNavigationMode()) {
            default: {
                return 0;
            }
            case 1: {
                SpinnerAdapter dropdownAdapter = this.mActionView.getDropdownAdapter();
                return dropdownAdapter != null ? dropdownAdapter.getCount() : 0;
            }
            case 2: 
        }
        if (this.mActionView.getSelectedTab() == null) {
            return -1;
        }
        return this.mActionView.getTabCount();
    }

    @Override
    public int getNavigationMode() {
        return this.mActionView.getNavigationMode();
    }

    @Override
    public int getSelectedNavigationIndex() {
        switch (this.mActionView.getNavigationMode()) {
            default: {
                return -1;
            }
            case 1: {
                return this.mActionView.getDropdownSelectedPosition();
            }
            case 2: 
        }
        return this.mActionView.getSelectedTab().getPosition();
    }

    @Override
    public ActionBar.Tab getSelectedTab() {
        return this.mActionView.getSelectedTab();
    }

    @Override
    public CharSequence getSubtitle() {
        return this.mActionView.getSubtitle();
    }

    @Override
    public ActionBar.Tab getTabAt(int index) {
        return this.mActionView.getTabAt(index);
    }

    @Override
    public int getTabCount() {
        return this.mActionView.getTabCount();
    }

    @Override
    public CharSequence getTitle() {
        return this.mActionView.getTitle();
    }

    @Override
    public void hide() {
        if (this.mContainerView.getVisibility() != 8) {
            this.mContainerView.startAnimation(this.mFadeOutAnimation);
            this.mContainerView.setVisibility(8);
        }
    }

    @Override
    public boolean isShowing() {
        return this.mContainerView.getVisibility() == 0;
    }

    @Override
    public ActionBar.Tab newTab() {
        return this.mActionView.newTab();
    }

    @Override
    public void removeAllTabs() {
        this.mActionView.removeAllTabs();
    }

    @Override
    public void removeOnMenuVisibilityListener(ActionBar.OnMenuVisibilityListener listener) {
        this.mMenuListeners.remove(listener);
    }

    @Override
    public void removeTab(ActionBar.Tab tab) {
        this.removeTabAt(tab.getPosition());
    }

    @Override
    public void removeTabAt(int position) {
        this.mActionView.removeTabAt(position);
    }

    @Override
    public void setBackgroundDrawable(Drawable d) {
        this.mContainerView.setBackgroundDrawable(d);
    }

    @Override
    public void setCustomView(int resId) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(resId, (ViewGroup)this.mActionView, false);
        this.setCustomView(view);
    }

    @Override
    public void setCustomView(View view) {
        this.mActionView.setCustomNavigationView(view);
    }

    @Override
    public void setCustomView(View view, ActionBar.LayoutParams layoutParams) {
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mActionView.setCustomNavigationView(view);
    }

    @Override
    public void setDisplayHomeAsUpEnabled(boolean showHomeAsUp) {
        this.setDisplayOptions(showHomeAsUp ? 4 : 0, 4);
    }

    @Override
    public void setDisplayOptions(int options) {
        this.mActionView.setDisplayOptions(options);
    }

    @Override
    public void setDisplayOptions(int newOptions, int mask) {
        this.mActionView.setDisplayOptions(this.mActionView.getDisplayOptions() & ~mask | newOptions);
    }

    @Override
    public void setDisplayShowCustomEnabled(boolean showCustom) {
        this.setDisplayOptions(showCustom ? 16 : 0, 16);
    }

    @Override
    public void setDisplayShowHomeEnabled(boolean showHome) {
        this.setDisplayOptions(showHome ? 2 : 0, 2);
    }

    @Override
    public void setDisplayShowTitleEnabled(boolean showTitle) {
        this.setDisplayOptions(showTitle ? 8 : 0, 8);
    }

    @Override
    public void setDisplayUseLogoEnabled(boolean useLogo) {
        this.setDisplayOptions(useLogo ? 1 : 0, 1);
    }

    @Override
    public void setListNavigationCallbacks(SpinnerAdapter adapter, ActionBar.OnNavigationListener callback) {
        this.mActionView.setDropdownAdapter(adapter);
        this.mActionView.setCallback(callback);
    }

    @Override
    public void setNavigationMode(int mode) {
        this.mActionView.setNavigationMode(mode);
    }

    @Override
    public void setSelectedNavigationItem(int position) {
        switch (this.mActionView.getNavigationMode()) {
            default: {
                throw new IllegalStateException();
            }
            case 2: {
                this.mActionView.getTabAt(position).select();
                break;
            }
            case 1: {
                this.mActionView.setDropdownSelectedPosition(position);
            }
        }
    }

    @Override
    public void selectTab(ActionBar.Tab tab) {
        this.mActionView.selectTab(tab);
    }

    @Override
    public void setSubtitle(CharSequence subtitle) {
        this.mActionView.setSubtitle(subtitle);
    }

    @Override
    public void setSubtitle(int resId) {
        this.mActionView.setSubtitle(resId);
    }

    @Override
    public void setTitle(CharSequence title) {
        this.mActionView.setTitle(title);
    }

    @Override
    public void setTitle(int resId) {
        this.mActionView.setTitle(resId);
    }

    @Override
    public void show() {
        if (this.mContainerView.getVisibility() != 0) {
            this.mContainerView.startAnimation(this.mFadeInAnimation);
            this.mContainerView.setVisibility(0);
        }
    }
}

