/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.app;

import android.app.ActionBar;
import android.app.Activity;
import android.app.FragmentTransaction;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.app.ActionBar;
import android.support.v4.view.ActionMode;
import android.support.v4.view.Menu;
import android.view.ActionMode;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.SpinnerAdapter;
import com.actionbarsherlock.internal.app.SherlockActivity;
import com.actionbarsherlock.internal.view.menu.MenuInflaterImpl;
import com.actionbarsherlock.internal.view.menu.MenuItemWrapper;
import com.actionbarsherlock.internal.view.menu.MenuWrapper;
import java.util.HashMap;

public final class ActionBarWrapper {
    private ActionBarWrapper() {
    }

    public static android.support.v4.app.ActionBar createFor(Activity activity) {
        if (!(activity instanceof SherlockActivity)) {
            throw new RuntimeException("Activity must implement the SherlockActivity interface");
        }
        return new Impl(activity);
    }

    public static final class Impl
    extends android.support.v4.app.ActionBar
    implements ActionBar.TabListener {
        private final HashMap<ActionBar.OnMenuVisibilityListener, ActionBar.OnMenuVisibilityListener> mMenuListenerMap = new HashMap();
        private final Activity mActivity;

        private Impl(Activity activity) {
            this.mActivity = activity;
        }

        private ActionBar getActionBar() {
            return this.mActivity.getActionBar();
        }

        private ActionBar.Tab convertTabToNative(ActionBar.Tab tab) {
            return this.getActionBar().newTab().setCustomView(tab.getCustomView()).setIcon(tab.getIcon()).setTabListener((ActionBar.TabListener)this).setTag((Object)tab).setText(tab.getText());
        }

        public void onTabReselected(ActionBar.Tab tab, FragmentTransaction ft) {
            ActionBar.TabListener listener = ((ActionBar.Tab)tab.getTag()).getTabListener();
            if (listener != null) {
                listener.onTabReselected((ActionBar.Tab)tab.getTag(), null);
            }
        }

        public void onTabSelected(ActionBar.Tab tab, FragmentTransaction ft) {
            ActionBar.TabListener listener = ((ActionBar.Tab)tab.getTag()).getTabListener();
            if (listener != null) {
                listener.onTabSelected((ActionBar.Tab)tab.getTag(), null);
            }
        }

        public void onTabUnselected(ActionBar.Tab tab, FragmentTransaction ft) {
            ActionBar.TabListener listener = ((ActionBar.Tab)tab.getTag()).getTabListener();
            if (listener != null) {
                listener.onTabUnselected((ActionBar.Tab)tab.getTag(), null);
            }
        }

        @Override
        protected ActionMode startActionMode(final ActionMode.Callback callback) {
            return new ActionModeWrapper((Context)this.mActivity, this.mActivity.startActionMode(new ActionMode.Callback(){

                public boolean onPrepareActionMode(android.view.ActionMode mode, android.view.Menu menu) {
                    return callback.onPrepareActionMode(new ActionModeWrapper((Context)Impl.this.mActivity, mode), new MenuWrapper(menu));
                }

                public void onDestroyActionMode(android.view.ActionMode mode) {
                    ActionModeWrapper actionMode = new ActionModeWrapper((Context)Impl.this.mActivity, mode);
                    callback.onDestroyActionMode(actionMode);
                    ((SherlockActivity)Impl.this.mActivity).onActionModeFinished(actionMode);
                }

                public boolean onCreateActionMode(android.view.ActionMode mode, android.view.Menu menu) {
                    return callback.onCreateActionMode(new ActionModeWrapper((Context)Impl.this.mActivity, mode), new MenuWrapper(menu));
                }

                public boolean onActionItemClicked(android.view.ActionMode mode, MenuItem item) {
                    return callback.onActionItemClicked(new ActionModeWrapper((Context)Impl.this.mActivity, mode), new MenuItemWrapper(item));
                }
            }));
        }

        @Override
        public void addOnMenuVisibilityListener(final ActionBar.OnMenuVisibilityListener listener) {
            if (listener != null && !this.mMenuListenerMap.containsKey(listener)) {
                ActionBar.OnMenuVisibilityListener nativeListener = new ActionBar.OnMenuVisibilityListener(){

                    public void onMenuVisibilityChanged(boolean isVisible) {
                        listener.onMenuVisibilityChanged(isVisible);
                    }
                };
                this.mMenuListenerMap.put(listener, nativeListener);
                this.getActionBar().addOnMenuVisibilityListener(nativeListener);
            }
        }

        @Override
        public void addTab(ActionBar.Tab tab) {
            this.getActionBar().addTab(this.convertTabToNative(tab));
        }

        @Override
        public void addTab(ActionBar.Tab tab, boolean setSelected) {
            this.getActionBar().addTab(this.convertTabToNative(tab), setSelected);
        }

        @Override
        public void addTab(ActionBar.Tab tab, int position) {
            this.getActionBar().addTab(this.convertTabToNative(tab), position);
        }

        @Override
        public void addTab(ActionBar.Tab tab, int position, boolean setSelected) {
            this.getActionBar().addTab(this.convertTabToNative(tab), position, setSelected);
        }

        @Override
        public View getCustomView() {
            return this.getActionBar().getCustomView();
        }

        @Override
        public int getDisplayOptions() {
            return this.getActionBar().getDisplayOptions();
        }

        @Override
        public int getHeight() {
            return this.getActionBar().getHeight();
        }

        @Override
        public int getNavigationItemCount() {
            return this.getActionBar().getNavigationItemCount();
        }

        @Override
        public int getNavigationMode() {
            return this.getActionBar().getNavigationMode();
        }

        @Override
        public int getSelectedNavigationIndex() {
            return this.getActionBar().getSelectedNavigationIndex();
        }

        @Override
        public ActionBar.Tab getSelectedTab() {
            if (this.getActionBar().getSelectedTab() != null) {
                return (ActionBar.Tab)this.getActionBar().getSelectedTab().getTag();
            }
            return null;
        }

        @Override
        public CharSequence getSubtitle() {
            return this.getActionBar().getSubtitle();
        }

        @Override
        public ActionBar.Tab getTabAt(int index) {
            if (this.getActionBar().getTabAt(index) != null) {
                return (ActionBar.Tab)this.getActionBar().getTabAt(index).getTag();
            }
            return null;
        }

        @Override
        public int getTabCount() {
            return this.getActionBar().getTabCount();
        }

        @Override
        public CharSequence getTitle() {
            return this.getActionBar().getTitle();
        }

        @Override
        public void hide() {
            this.getActionBar().hide();
        }

        @Override
        public boolean isShowing() {
            return this.getActionBar().isShowing();
        }

        @Override
        public ActionBar.Tab newTab() {
            return new TabImpl(this);
        }

        @Override
        public void removeAllTabs() {
            this.getActionBar().removeAllTabs();
        }

        @Override
        public void removeOnMenuVisibilityListener(ActionBar.OnMenuVisibilityListener listener) {
            if (listener != null && this.mMenuListenerMap.containsKey(listener)) {
                this.getActionBar().removeOnMenuVisibilityListener(this.mMenuListenerMap.remove(listener));
            }
        }

        @Override
        public void removeTab(ActionBar.Tab tab) {
            int tabCount = this.getActionBar().getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                if (!this.getActionBar().getTabAt(i).getTag().equals(tab)) continue;
                this.getActionBar().removeTabAt(i);
                break;
            }
        }

        @Override
        public void removeTabAt(int position) {
            this.getActionBar().removeTabAt(position);
        }

        @Override
        public void selectTab(ActionBar.Tab tab) {
            int tabCount = this.getActionBar().getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                if (!this.getActionBar().getTabAt(i).getTag().equals(tab)) continue;
                this.getActionBar().setSelectedNavigationItem(i);
                break;
            }
        }

        @Override
        public void setBackgroundDrawable(Drawable d) {
            this.getActionBar().setBackgroundDrawable(d);
        }

        @Override
        public void setCustomView(int resId) {
            this.getActionBar().setCustomView(resId);
        }

        @Override
        public void setCustomView(View view) {
            this.getActionBar().setCustomView(view);
        }

        @Override
        public void setCustomView(View view, ActionBar.LayoutParams layoutParams) {
            ActionBar.LayoutParams nativeLayoutParams = new ActionBar.LayoutParams((ViewGroup.LayoutParams)layoutParams);
            nativeLayoutParams.gravity = layoutParams.gravity;
            this.getActionBar().setCustomView(view, nativeLayoutParams);
        }

        @Override
        public void setDisplayHomeAsUpEnabled(boolean showHomeAsUp) {
            this.getActionBar().setDisplayHomeAsUpEnabled(showHomeAsUp);
        }

        @Override
        public void setDisplayOptions(int options, int mask) {
            this.getActionBar().setDisplayOptions(options, mask);
        }

        @Override
        public void setDisplayOptions(int options) {
            this.getActionBar().setDisplayOptions(options);
        }

        @Override
        public void setDisplayShowCustomEnabled(boolean showCustom) {
            this.getActionBar().setDisplayShowCustomEnabled(showCustom);
        }

        @Override
        public void setDisplayShowHomeEnabled(boolean showHome) {
            this.getActionBar().setDisplayShowHomeEnabled(showHome);
        }

        @Override
        public void setDisplayShowTitleEnabled(boolean showTitle) {
            this.getActionBar().setDisplayShowTitleEnabled(showTitle);
        }

        @Override
        public void setDisplayUseLogoEnabled(boolean useLogo) {
            this.getActionBar().setDisplayUseLogoEnabled(useLogo);
        }

        @Override
        public void setListNavigationCallbacks(SpinnerAdapter adapter, final ActionBar.OnNavigationListener callback) {
            this.getActionBar().setListNavigationCallbacks(adapter, new ActionBar.OnNavigationListener(){

                public boolean onNavigationItemSelected(int itemPosition, long itemId) {
                    if (callback != null) {
                        return callback.onNavigationItemSelected(itemPosition, itemId);
                    }
                    return false;
                }
            });
        }

        @Override
        public void setNavigationMode(int mode) {
            this.getActionBar().setNavigationMode(mode);
        }

        @Override
        public void setSelectedNavigationItem(int position) {
            this.getActionBar().setSelectedNavigationItem(position);
        }

        @Override
        public void setSubtitle(CharSequence subtitle) {
            this.getActionBar().setSubtitle(subtitle);
        }

        @Override
        public void setSubtitle(int resId) {
            this.getActionBar().setSubtitle(resId);
        }

        @Override
        public void setTitle(CharSequence title) {
            this.getActionBar().setTitle(title);
        }

        @Override
        public void setTitle(int resId) {
            this.getActionBar().setTitle(resId);
        }

        @Override
        public void show() {
            this.getActionBar().show();
        }

        private static class TabImpl
        extends ActionBar.Tab {
            final Impl mActionBar;
            View mCustomView;
            Drawable mIcon;
            ActionBar.TabListener mListener;
            Object mTag;
            CharSequence mText;

            TabImpl(Impl actionBar) {
                this.mActionBar = actionBar;
            }

            @Override
            public View getCustomView() {
                return this.mCustomView;
            }

            @Override
            public Drawable getIcon() {
                return this.mIcon;
            }

            @Override
            public int getPosition() {
                int tabCount = this.mActionBar.getTabCount();
                for (int i = 0; i < tabCount; ++i) {
                    if (!this.mActionBar.getTabAt(i).equals(this)) continue;
                    return i;
                }
                return ActionBar.Tab.INVALID_POSITION;
            }

            @Override
            public ActionBar.TabListener getTabListener() {
                return this.mListener;
            }

            @Override
            public Object getTag() {
                return this.mTag;
            }

            @Override
            public CharSequence getText() {
                return this.mText;
            }

            @Override
            public void select() {
                this.mActionBar.selectTab(this);
            }

            @Override
            public ActionBar.Tab setCustomView(int layoutResId) {
                this.mCustomView = this.mActionBar.mActivity.getLayoutInflater().inflate(layoutResId, null);
                return this;
            }

            @Override
            public ActionBar.Tab setCustomView(View view) {
                this.mCustomView = view;
                return this;
            }

            @Override
            public ActionBar.Tab setIcon(Drawable icon) {
                this.mIcon = icon;
                return this;
            }

            @Override
            public ActionBar.Tab setIcon(int resId) {
                this.mIcon = this.mActionBar.mActivity.getResources().getDrawable(resId);
                return this;
            }

            @Override
            public ActionBar.Tab setTabListener(ActionBar.TabListener listener) {
                this.mListener = listener;
                return this;
            }

            @Override
            public ActionBar.Tab setTag(Object obj) {
                this.mTag = obj;
                return this;
            }

            @Override
            public ActionBar.Tab setText(int resId) {
                this.mText = this.mActionBar.mActivity.getResources().getString(resId);
                return this;
            }

            @Override
            public ActionBar.Tab setText(CharSequence text) {
                this.mText = text;
                return this;
            }
        }

        private static class ActionModeWrapper
        extends ActionMode {
            private final Context mContext;
            private final android.view.ActionMode mActionMode;

            ActionModeWrapper(Context context, android.view.ActionMode actionMode) {
                this.mContext = context;
                this.mActionMode = actionMode;
            }

            @Override
            public void finish() {
                this.mActionMode.finish();
            }

            @Override
            public View getCustomView() {
                return this.mActionMode.getCustomView();
            }

            @Override
            public Menu getMenu() {
                return new MenuWrapper(this.mActionMode.getMenu());
            }

            @Override
            public MenuInflaterImpl getMenuInflater() {
                return new MenuInflaterImpl(this.mContext, null);
            }

            @Override
            public CharSequence getSubtitle() {
                return this.mActionMode.getSubtitle();
            }

            @Override
            public CharSequence getTitle() {
                return this.mActionMode.getTitle();
            }

            @Override
            public void invalidate() {
                this.mActionMode.invalidate();
            }

            @Override
            public void setCustomView(View view) {
                this.mActionMode.setCustomView(view);
            }

            @Override
            public void setSubtitle(int resId) {
                this.mActionMode.setSubtitle(resId);
            }

            @Override
            public void setSubtitle(CharSequence subtitle) {
                this.mActionMode.setSubtitle(subtitle);
            }

            @Override
            public void setTitle(int resId) {
                this.mActionMode.setTitle(resId);
            }

            @Override
            public void setTitle(CharSequence title) {
                this.mActionMode.setTitle(title);
            }
        }
    }
}

