/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.view.menu;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.actionbarsherlock.internal.view.View_HasStateListenerSupport;
import com.actionbarsherlock.internal.view.View_OnAttachStateChangeListener;
import com.actionbarsherlock.internal.view.menu.ActionMenuView;
import com.actionbarsherlock.internal.view.menu.MenuBuilder;
import com.actionbarsherlock.internal.view.menu.MenuItemImpl;
import com.actionbarsherlock.internal.view.menu.MenuView;
import com.ushahidi.android.app.R;
import java.util.HashSet;
import java.util.Set;

public class ActionMenuItemView
extends LinearLayout
implements MenuView.ItemView,
View.OnClickListener,
View.OnLongClickListener,
ActionMenuView.ActionMenuChildView,
View_HasStateListenerSupport {
    private MenuItemImpl mItemData;
    private CharSequence mTitle;
    private MenuBuilder.ItemInvoker mItemInvoker;
    private ImageButton mImageButton;
    private Button mTextButton;
    private boolean mAllowTextWithIcon;
    private boolean mExpandedFormat;
    private final Set<View_OnAttachStateChangeListener> mListeners = new HashSet<View_OnAttachStateChangeListener>();

    public ActionMenuItemView(Context context) {
        this(context, null);
    }

    public ActionMenuItemView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ActionMenuItemView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
        Resources res = context.getResources();
        this.mAllowTextWithIcon = res.getBoolean(R.bool.abs__config_allowActionMenuItemTextWithIcon);
    }

    @Override
    public void addOnAttachStateChangeListener(View_OnAttachStateChangeListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void removeOnAttachStateChangeListener(View_OnAttachStateChangeListener listener) {
        this.mListeners.remove(listener);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        for (View_OnAttachStateChangeListener listener : this.mListeners) {
            listener.onViewAttachedToWindow((View)this);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        for (View_OnAttachStateChangeListener listener : this.mListeners) {
            listener.onViewDetachedFromWindow((View)this);
        }
    }

    public void onFinishInflate() {
        this.mImageButton = (ImageButton)this.findViewById(R.id.abs__imageButton);
        this.mTextButton = (Button)this.findViewById(R.id.abs__textButton);
        this.mImageButton.setOnClickListener((View.OnClickListener)this);
        this.mTextButton.setOnClickListener((View.OnClickListener)this);
        this.mImageButton.setOnLongClickListener((View.OnLongClickListener)this);
        this.setOnClickListener(this);
        this.setOnLongClickListener(this);
    }

    @Override
    public MenuItemImpl getItemData() {
        return this.mItemData;
    }

    @Override
    public void initialize(MenuItemImpl itemData, int menuType) {
        this.mItemData = itemData;
        this.setIcon(itemData.getIcon());
        this.setTitle(itemData.getTitleForItemView(this));
        this.setId(itemData.getItemId());
        this.setVisibility(itemData.isVisible() ? 0 : 8);
        this.setEnabled(itemData.isEnabled());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mImageButton.setEnabled(enabled);
        this.mTextButton.setEnabled(enabled);
    }

    public void onClick(View v) {
        if (this.mItemInvoker != null) {
            this.mItemInvoker.invokeItem(this.mItemData);
        }
    }

    public void setItemInvoker(MenuBuilder.ItemInvoker invoker) {
        this.mItemInvoker = invoker;
    }

    @Override
    public boolean prefersCondensedTitle() {
        return true;
    }

    @Override
    public void setCheckable(boolean checkable) {
    }

    @Override
    public void setChecked(boolean checked) {
    }

    public void setExpandedFormat(boolean expandedFormat) {
        if (this.mExpandedFormat != expandedFormat) {
            this.mExpandedFormat = expandedFormat;
            if (this.mItemData != null) {
                this.mItemData.actionFormatChanged();
            }
        }
    }

    private void updateTextButtonVisibility() {
        boolean visible = !TextUtils.isEmpty((CharSequence)this.mTextButton.getText());
        this.mTextButton.setVisibility((visible &= this.mImageButton.getDrawable() == null || this.mItemData.showsTextAsAction() && (this.mAllowTextWithIcon || this.mExpandedFormat)) ? 0 : 8);
    }

    @Override
    public void setIcon(Drawable icon) {
        this.mImageButton.setImageDrawable(icon);
        if (icon != null) {
            this.mImageButton.setVisibility(0);
        } else {
            this.mImageButton.setVisibility(8);
        }
        this.updateTextButtonVisibility();
    }

    public boolean hasText() {
        return this.mTextButton.getVisibility() != 8;
    }

    @Override
    public void setShortcut(boolean showShortcut, char shortcutKey) {
    }

    @Override
    public void setTitle(CharSequence title) {
        this.mTitle = title;
        this.mTextButton.setText(this.mTitle);
        this.setContentDescription(this.mTitle);
        this.updateTextButtonVisibility();
    }

    @Override
    public boolean showsIcon() {
        return true;
    }

    @Override
    public boolean needsDividerBefore() {
        return this.hasText() && this.mItemData.getIcon() == null;
    }

    @Override
    public boolean needsDividerAfter() {
        return this.hasText();
    }

    public boolean onLongClick(View v) {
        if (this.hasText()) {
            return false;
        }
        int[] screenPos = new int[2];
        Rect displayFrame = new Rect();
        this.getLocationOnScreen(screenPos);
        this.getWindowVisibleDisplayFrame(displayFrame);
        Context context = this.getContext();
        int width = this.getWidth();
        int height = this.getHeight();
        int midy = screenPos[1] + height / 2;
        int screenWidth = context.getResources().getDisplayMetrics().widthPixels;
        Toast cheatSheet = Toast.makeText((Context)context, (CharSequence)this.mItemData.getTitle(), (int)0);
        if (midy < displayFrame.height()) {
            cheatSheet.setGravity(53, screenWidth - screenPos[0] - width / 2, height);
        } else {
            cheatSheet.setGravity(81, 0, height);
        }
        cheatSheet.show();
        return true;
    }
}

