/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.view.menu;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.MenuItem;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import com.actionbarsherlock.internal.view.menu.ActionMenuItemView;
import com.actionbarsherlock.internal.view.menu.ActionMenuView;
import com.actionbarsherlock.internal.view.menu.BaseMenuPresenter;
import com.actionbarsherlock.internal.view.menu.MenuBuilder;
import com.actionbarsherlock.internal.view.menu.MenuItemImpl;
import com.actionbarsherlock.internal.view.menu.MenuView;
import com.actionbarsherlock.internal.view.menu.SubMenuBuilder;
import com.ushahidi.android.app.R;
import java.util.ArrayList;

public class ActionMenuPresenter
extends BaseMenuPresenter {
    private int mWidthLimit;
    private int mActionItemWidthLimit;
    private int mMaxItems;
    private boolean mMaxItemsSet;
    private boolean mStrictWidthLimit;
    private boolean mWidthLimitSet;
    private int mMinCellSize;
    private AlertDialog mDialog;
    private final SparseBooleanArray mActionButtonGroups = new SparseBooleanArray();
    private View mScrapActionButtonView;
    int mOpenSubMenuId;

    public ActionMenuPresenter(Context context) {
        super(context, R.layout.abs__action_menu_layout, R.layout.abs__action_menu_item_layout);
    }

    @Override
    public void initForMenu(Context context, MenuBuilder menu) {
        super.initForMenu(context, menu);
        Resources res = context.getResources();
        if (!this.mWidthLimitSet) {
            this.mWidthLimit = res.getDisplayMetrics().widthPixels / 2;
        }
        if (!this.mMaxItemsSet) {
            this.mMaxItems = res.getInteger(R.integer.abs__max_action_buttons);
        }
        this.mActionItemWidthLimit = this.mWidthLimit;
        this.mMinCellSize = (int)(56.0f * res.getDisplayMetrics().density);
        this.mScrapActionButtonView = null;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        if (!this.mMaxItemsSet) {
            this.mMaxItems = this.mContext.getResources().getInteger(R.integer.abs__max_action_buttons);
            if (this.mMenu != null) {
                this.mMenu.onItemsChanged(true);
            }
        }
    }

    public void setWidthLimit(int width, boolean strict) {
        this.mWidthLimit = width;
        this.mStrictWidthLimit = strict;
        this.mWidthLimitSet = true;
    }

    public void setItemLimit(int itemCount) {
        this.mMaxItems = itemCount;
        this.mMaxItemsSet = true;
    }

    @Override
    public MenuView getMenuView(ViewGroup root) {
        MenuView result = super.getMenuView(root);
        ((ActionMenuView)result).setPresenter(this);
        return result;
    }

    @Override
    public View getItemView(MenuItemImpl item, View convertView, ViewGroup parent) {
        View actionView = item.getActionView();
        if (actionView == null) {
            if (!(convertView instanceof ActionMenuItemView)) {
                convertView = null;
            }
            actionView = super.getItemView(item, convertView, parent);
        }
        actionView.setVisibility(0);
        ActionMenuView menuParent = (ActionMenuView)parent;
        ViewGroup.LayoutParams lp = actionView.getLayoutParams();
        if (!menuParent.checkLayoutParams(lp)) {
            actionView.setLayoutParams((ViewGroup.LayoutParams)menuParent.generateLayoutParams(lp));
        }
        return actionView;
    }

    @Override
    public void bindItemView(MenuItemImpl item, MenuView.ItemView itemView) {
        itemView.initialize(item, 0);
        ActionMenuView menuView = (ActionMenuView)this.mMenuView;
        ActionMenuItemView actionItemView = (ActionMenuItemView)itemView;
        actionItemView.setItemInvoker(menuView);
    }

    @Override
    public boolean shouldIncludeItem(int childIndex, MenuItemImpl item) {
        return item.isActionButton();
    }

    @Override
    public boolean filterLeftoverView(ViewGroup parent, int childIndex) {
        return super.filterLeftoverView(parent, childIndex);
    }

    @Override
    public boolean onSubMenuSelected(SubMenuBuilder subMenu) {
        if (!subMenu.hasVisibleItems()) {
            return false;
        }
        SubMenuBuilder topSubMenu = subMenu;
        while (topSubMenu.getParentMenu() != this.mMenu) {
            topSubMenu = (SubMenuBuilder)topSubMenu.getParentMenu();
        }
        View anchor = this.findViewForItem(topSubMenu.getItem());
        if (anchor == null) {
            return false;
        }
        this.mOpenSubMenuId = subMenu.getItem().getItemId();
        final ArrayList<MenuItemImpl> items = subMenu.getVisibleItems();
        int itemsSize = items.size();
        CharSequence[] itemText = new CharSequence[itemsSize];
        for (int i = 0; i < itemsSize; ++i) {
            itemText[i] = ((MenuItemImpl)items.get(i)).getTitle();
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext).setTitle(subMenu.getItem().getTitle()).setIcon(subMenu.getItem().getIcon()).setCancelable(true).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                ActionMenuPresenter.this.mDialog = null;
            }
        });
        boolean isExclusive = ((MenuItemImpl)subMenu.getItem(0)).isExclusiveCheckable();
        boolean isCheckable = ((MenuItemImpl)subMenu.getItem(0)).isCheckable();
        if (isExclusive) {
            int selected = -1;
            for (int i = 0; i < itemsSize; ++i) {
                if (!((MenuItemImpl)items.get(i)).isChecked()) continue;
                selected = i;
                break;
            }
            builder.setSingleChoiceItems(itemText, selected, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ((MenuItemImpl)items.get(which)).invoke();
                    dialog.dismiss();
                    ActionMenuPresenter.this.mDialog = null;
                }
            });
        } else if (isCheckable) {
            boolean[] selected = new boolean[itemsSize];
            for (int i = 0; i < itemsSize; ++i) {
                selected[i] = ((MenuItemImpl)items.get(i)).isChecked();
            }
            builder.setMultiChoiceItems(itemText, selected, new DialogInterface.OnMultiChoiceClickListener(){

                public void onClick(DialogInterface dialog, int which, boolean isChecked) {
                    ((MenuItemImpl)items.get(which)).setChecked(isChecked);
                    dialog.dismiss();
                    ActionMenuPresenter.this.mDialog = null;
                }
            });
        } else {
            builder.setItems(itemText, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ((MenuItemImpl)items.get(which)).invoke();
                    dialog.dismiss();
                    ActionMenuPresenter.this.mDialog = null;
                }
            });
        }
        this.mDialog = builder.show();
        super.onSubMenuSelected(subMenu);
        return true;
    }

    private View findViewForItem(MenuItem item) {
        ViewGroup parent = (ViewGroup)this.mMenuView;
        if (parent == null) {
            return null;
        }
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = parent.getChildAt(i);
            if (!(child instanceof MenuView.ItemView) || ((MenuView.ItemView)child).getItemData() != item) continue;
            return child;
        }
        return null;
    }

    public boolean dismissPopupMenus() {
        return this.hideSubMenus();
    }

    public boolean hideSubMenus() {
        if (this.mDialog != null) {
            try {
                this.mDialog.dismiss();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mDialog = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean flagActionItems() {
        ArrayList<MenuItemImpl> visibleItems = this.mMenu.getVisibleItems();
        int itemsSize = visibleItems.size();
        int maxActions = this.mMaxItems;
        int widthLimit = this.mActionItemWidthLimit;
        int querySpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        ViewGroup parent = (ViewGroup)this.mMenuView;
        int requiredItems = 0;
        int firstActionWidth = 0;
        for (int i = 0; i < itemsSize; ++i) {
            MenuItemImpl item = visibleItems.get(i);
            if (!item.requiresActionButton()) continue;
            ++requiredItems;
        }
        maxActions -= requiredItems;
        SparseBooleanArray seenGroups = this.mActionButtonGroups;
        seenGroups.clear();
        int cellSize = 0;
        int cellsRemaining = 0;
        if (this.mStrictWidthLimit) {
            cellsRemaining = widthLimit / this.mMinCellSize;
            int cellSizeRemaining = widthLimit % this.mMinCellSize;
            cellSize = this.mMinCellSize + cellSizeRemaining / cellsRemaining;
        }
        for (int i = 0; i < itemsSize; ++i) {
            boolean isAction;
            MenuItemImpl item = visibleItems.get(i);
            if (item.requiresActionButton()) {
                int groupId;
                View v = this.getItemView(item, this.mScrapActionButtonView, parent);
                if (this.mScrapActionButtonView == null) {
                    this.mScrapActionButtonView = v;
                }
                if (this.mStrictWidthLimit) {
                    cellsRemaining -= ActionMenuView.measureChildForCells(v, cellSize, cellsRemaining, querySpec, 0);
                } else {
                    v.measure(querySpec, querySpec);
                }
                int measuredWidth = v.getMeasuredWidth();
                widthLimit -= measuredWidth;
                if (firstActionWidth == 0) {
                    firstActionWidth = measuredWidth;
                }
                if ((groupId = item.getGroupId()) != 0) {
                    seenGroups.put(groupId, true);
                }
                item.setIsActionButton(true);
                continue;
            }
            if (!item.requestsActionButton()) continue;
            int groupId = item.getGroupId();
            boolean inGroup = seenGroups.get(groupId);
            boolean bl = isAction = !(maxActions <= 0 && !inGroup || widthLimit <= 0 || this.mStrictWidthLimit && cellsRemaining <= 0);
            if (isAction) {
                View v = this.getItemView(item, this.mScrapActionButtonView, parent);
                if (this.mScrapActionButtonView == null) {
                    this.mScrapActionButtonView = v;
                }
                if (this.mStrictWidthLimit) {
                    int cells = ActionMenuView.measureChildForCells(v, cellSize, cellsRemaining, querySpec, 0);
                    cellsRemaining -= cells;
                    if (cells == 0) {
                        isAction = false;
                    }
                } else {
                    v.measure(querySpec, querySpec);
                }
                int measuredWidth = v.getMeasuredWidth();
                widthLimit -= measuredWidth;
                if (firstActionWidth == 0) {
                    firstActionWidth = measuredWidth;
                }
                isAction = this.mStrictWidthLimit ? (isAction &= widthLimit >= 0) : (isAction &= widthLimit + firstActionWidth > 0);
            }
            if (isAction && groupId != 0) {
                seenGroups.put(groupId, true);
            } else if (inGroup) {
                seenGroups.put(groupId, false);
                for (int j = 0; j < i; ++j) {
                    MenuItemImpl areYouMyGroupie = visibleItems.get(j);
                    if (areYouMyGroupie.getGroupId() != groupId) continue;
                    if (areYouMyGroupie.isActionButton()) {
                        ++maxActions;
                    }
                    areYouMyGroupie.setIsActionButton(false);
                }
            }
            if (isAction) {
                --maxActions;
            }
            item.setIsActionButton(isAction);
        }
        return true;
    }

    @Override
    public void onCloseMenu(MenuBuilder menu, boolean allMenusAreClosing) {
        this.dismissPopupMenus();
        super.onCloseMenu(menu, allMenusAreClosing);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        SavedState state = new SavedState();
        state.openSubMenuId = this.mOpenSubMenuId;
        return state;
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        MenuItem item;
        SavedState saved = (SavedState)state;
        if (saved.openSubMenuId > 0 && (item = this.mMenu.findItem(saved.openSubMenuId)) != null) {
            SubMenuBuilder subMenu = (SubMenuBuilder)item.getSubMenu();
            this.onSubMenuSelected(subMenu);
        }
    }

    private static class SavedState
    implements Parcelable {
        public int openSubMenuId;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState() {
        }

        SavedState(Parcel in) {
            this.openSubMenuId = in.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.openSubMenuId);
        }
    }
}

