/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.view.menu;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.support.v4.view.Menu;
import android.support.v4.view.MenuItem;
import android.support.v4.view.SubMenu;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import android.view.InflateException;
import android.view.MenuInflater;
import android.view.View;
import com.actionbarsherlock.internal.view.menu.MenuBuilder;
import com.actionbarsherlock.internal.view.menu.MenuItemImpl;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MenuInflaterImpl
extends MenuInflater {
    private static final String LOG_TAG = "MenuInflater";
    private static final String XML_NS = "http://schemas.android.com/apk/res/android";
    private static final String XML_MENU = "menu";
    private static final String XML_GROUP = "group";
    private static final String XML_ITEM = "item";
    private static final int NO_ID = 0;
    private static final Class<?>[] ACTION_VIEW_CONSTRUCTOR_SIGNATURE = new Class[]{Context.class};
    private final Object[] mActionViewConstructorArguments;
    private Context mContext;
    private final MenuInflater mNativeMenuInflater;

    public MenuInflaterImpl(Context context, MenuInflater nativeMenuInflater) {
        super(context);
        this.mContext = context;
        this.mActionViewConstructorArguments = new Object[]{context};
        this.mNativeMenuInflater = nativeMenuInflater;
    }

    public void inflate(int menuRes, android.view.Menu menu) {
        if (!(menu instanceof MenuBuilder)) {
            this.mNativeMenuInflater.inflate(menuRes, menu);
            return;
        }
        MenuBuilder actionBarMenu = (MenuBuilder)menu;
        try (XmlResourceParser parser = null;){
            parser = this.mContext.getResources().getLayout(menuRes);
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            this.parseMenu((XmlPullParser)parser, attrs, actionBarMenu);
        }
    }

    private void parseMenu(XmlPullParser parser, AttributeSet attrs, Menu menu) throws XmlPullParserException, IOException {
        String tagName;
        MenuState menuState = new MenuState(menu);
        int eventType = parser.getEventType();
        boolean lookingForEndOfUnknownTag = false;
        String unknownTagName = null;
        do {
            if (eventType != 2) continue;
            tagName = parser.getName();
            if (tagName.equals(XML_MENU)) {
                eventType = parser.next();
                break;
            }
            throw new RuntimeException("Expecting menu, got " + tagName);
        } while ((eventType = parser.next()) != 1);
        boolean reachedEndOfMenu = false;
        while (!reachedEndOfMenu) {
            switch (eventType) {
                case 2: {
                    if (lookingForEndOfUnknownTag) break;
                    tagName = parser.getName();
                    if (tagName.equals(XML_GROUP)) {
                        menuState.readGroup(attrs);
                        break;
                    }
                    if (tagName.equals(XML_ITEM)) {
                        menuState.readItem(attrs);
                        break;
                    }
                    if (tagName.equals(XML_MENU)) {
                        SubMenu subMenu = menuState.addSubMenuItem();
                        this.parseMenu(parser, attrs, subMenu);
                        break;
                    }
                    lookingForEndOfUnknownTag = true;
                    unknownTagName = tagName;
                    break;
                }
                case 3: {
                    tagName = parser.getName();
                    if (lookingForEndOfUnknownTag && tagName.equals(unknownTagName)) {
                        lookingForEndOfUnknownTag = false;
                        unknownTagName = null;
                        break;
                    }
                    if (tagName.equals(XML_GROUP)) {
                        menuState.resetGroup();
                        break;
                    }
                    if (tagName.equals(XML_ITEM)) {
                        if (menuState.hasAddedItem()) break;
                        menuState.addItem();
                        break;
                    }
                    if (!tagName.equals(XML_MENU)) break;
                    reachedEndOfMenu = true;
                    break;
                }
                case 1: {
                    throw new RuntimeException("Unexpected end of document");
                }
            }
            eventType = parser.next();
        }
    }

    private class MenuState {
        private Menu menu;
        private int groupId;
        private int groupCategory;
        private int groupOrder;
        private int groupCheckable;
        private boolean groupVisible;
        private boolean groupEnabled;
        private boolean itemAdded;
        private int itemId;
        private int itemCategoryOrder;
        private CharSequence itemTitle;
        private CharSequence itemTitleCondensed;
        private int itemIconResId;
        private char itemAlphabeticShortcut;
        private char itemNumericShortcut;
        private int itemCheckable;
        private boolean itemChecked;
        private boolean itemVisible;
        private boolean itemEnabled;
        private int itemShowAsAction;
        private int itemActionViewLayout;
        private String itemActionViewClassName;
        private String itemListenerMethodName;
        private static final int defaultGroupId = 0;
        private static final int defaultItemId = 0;
        private static final int defaultItemCategory = 0;
        private static final int defaultItemOrder = 0;
        private static final int defaultItemCheckable = 0;
        private static final boolean defaultItemChecked = false;
        private static final boolean defaultItemVisible = true;
        private static final boolean defaultItemEnabled = true;

        public MenuState(Menu menu) {
            this.menu = menu;
            this.resetGroup();
        }

        public void resetGroup() {
            this.groupId = 0;
            this.groupCategory = 0;
            this.groupOrder = 0;
            this.groupCheckable = 0;
            this.groupVisible = true;
            this.groupEnabled = true;
        }

        public void readGroup(AttributeSet attrs) {
            this.groupId = attrs.getAttributeResourceValue(MenuInflaterImpl.XML_NS, "id", 0);
            this.groupCategory = attrs.getAttributeIntValue(MenuInflaterImpl.XML_NS, "menuCategory", 0);
            this.groupOrder = attrs.getAttributeIntValue(MenuInflaterImpl.XML_NS, "orderInCategory", 0);
            this.groupCheckable = attrs.getAttributeIntValue(MenuInflaterImpl.XML_NS, "checkableBehavior", 0);
            this.groupVisible = attrs.getAttributeBooleanValue(MenuInflaterImpl.XML_NS, "visible", true);
            this.groupEnabled = attrs.getAttributeBooleanValue(MenuInflaterImpl.XML_NS, "enabled", true);
        }

        public void readItem(AttributeSet attrs) {
            this.itemId = attrs.getAttributeResourceValue(MenuInflaterImpl.XML_NS, "id", 0);
            int category = attrs.getAttributeIntValue(MenuInflaterImpl.XML_NS, "menuCategory", this.groupCategory);
            int order = attrs.getAttributeIntValue(MenuInflaterImpl.XML_NS, "orderInCategory", this.groupOrder);
            this.itemCategoryOrder = category & 0xFFFF0000 | order & 0xFFFF;
            int itemTitleId = attrs.getAttributeResourceValue(MenuInflaterImpl.XML_NS, "title", 0);
            this.itemTitle = itemTitleId != 0 ? MenuInflaterImpl.this.mContext.getString(itemTitleId) : attrs.getAttributeValue(MenuInflaterImpl.XML_NS, "title");
            int itemTitleCondensedId = attrs.getAttributeResourceValue(MenuInflaterImpl.XML_NS, "titleCondensed", 0);
            this.itemTitleCondensed = itemTitleCondensedId != 0 ? MenuInflaterImpl.this.mContext.getString(itemTitleCondensedId) : attrs.getAttributeValue(MenuInflaterImpl.XML_NS, "titleCondensed");
            this.itemIconResId = attrs.getAttributeResourceValue(MenuInflaterImpl.XML_NS, "icon", 0);
            this.itemAlphabeticShortcut = this.getShortcut(attrs.getAttributeValue(MenuInflaterImpl.XML_NS, "alphabeticShortcut"));
            this.itemNumericShortcut = this.getShortcut(attrs.getAttributeValue(MenuInflaterImpl.XML_NS, "numericShortcut"));
            this.itemCheckable = attrs.getAttributeValue(MenuInflaterImpl.XML_NS, "checkable") != null ? (attrs.getAttributeBooleanValue(MenuInflaterImpl.XML_NS, "checkable", false) ? 1 : 0) : this.groupCheckable;
            this.itemChecked = attrs.getAttributeBooleanValue(MenuInflaterImpl.XML_NS, "checked", false);
            this.itemVisible = attrs.getAttributeBooleanValue(MenuInflaterImpl.XML_NS, "visible", this.groupVisible);
            this.itemEnabled = attrs.getAttributeBooleanValue(MenuInflaterImpl.XML_NS, "enabled", this.groupEnabled);
            this.itemShowAsAction = attrs.getAttributeIntValue(MenuInflaterImpl.XML_NS, "showAsAction", -1);
            this.itemListenerMethodName = attrs.getAttributeValue(MenuInflaterImpl.XML_NS, "onClick");
            this.itemActionViewLayout = attrs.getAttributeResourceValue(MenuInflaterImpl.XML_NS, "actionLayout", 0);
            this.itemActionViewClassName = attrs.getAttributeValue(MenuInflaterImpl.XML_NS, "actionViewClass");
            this.itemAdded = false;
        }

        private char getShortcut(String shortcutString) {
            if (shortcutString == null) {
                return '\u0000';
            }
            return shortcutString.charAt(0);
        }

        private void setItem(MenuItem item) {
            item.setChecked(this.itemChecked).setVisible(this.itemVisible).setEnabled(this.itemEnabled).setCheckable(this.itemCheckable >= 1).setTitleCondensed(this.itemTitleCondensed).setIcon(this.itemIconResId).setAlphabeticShortcut(this.itemAlphabeticShortcut).setNumericShortcut(this.itemNumericShortcut);
            if (this.itemShowAsAction >= 0) {
                item.setShowAsAction(this.itemShowAsAction);
            }
            if (this.itemListenerMethodName != null) {
                if (MenuInflaterImpl.this.mContext.isRestricted()) {
                    throw new IllegalStateException("The android:onClick attribute cannot be used within a restricted context");
                }
                item.setOnMenuItemClickListener(new InflatedOnMenuItemClickListener(MenuInflaterImpl.this.mContext, this.itemListenerMethodName));
            }
            if (item instanceof MenuItemImpl) {
                MenuItemImpl impl = (MenuItemImpl)item;
                if (this.itemCheckable >= 2) {
                    impl.setExclusiveCheckable(true);
                }
            }
            boolean actionViewSpecified = false;
            if (this.itemActionViewClassName != null) {
                View actionView = (View)this.newInstance(this.itemActionViewClassName, ACTION_VIEW_CONSTRUCTOR_SIGNATURE, MenuInflaterImpl.this.mActionViewConstructorArguments);
                item.setActionView(actionView);
                actionViewSpecified = true;
            }
            if (this.itemActionViewLayout > 0) {
                if (!actionViewSpecified) {
                    item.setActionView(this.itemActionViewLayout);
                    actionViewSpecified = true;
                } else {
                    Log.w((String)MenuInflaterImpl.LOG_TAG, (String)"Ignoring attribute 'itemActionViewLayout'. Action view already specified.");
                }
            }
        }

        public void addItem() {
            this.itemAdded = true;
            this.setItem(this.menu.add(this.groupId, this.itemId, this.itemCategoryOrder, this.itemTitle));
        }

        public SubMenu addSubMenuItem() {
            this.itemAdded = true;
            SubMenu subMenu = this.menu.addSubMenu(this.groupId, this.itemId, this.itemCategoryOrder, this.itemTitle);
            this.setItem(subMenu.getItem());
            return subMenu;
        }

        public boolean hasAddedItem() {
            return this.itemAdded;
        }

        private <T> T newInstance(String className, Class<?>[] constructorSignature, Object[] arguments) {
            try {
                Class<?> clazz = MenuInflaterImpl.this.mContext.getClassLoader().loadClass(className);
                Constructor<?> constructor = clazz.getConstructor(constructorSignature);
                return (T)constructor.newInstance(arguments);
            }
            catch (Exception e) {
                Log.w((String)MenuInflaterImpl.LOG_TAG, (String)("Cannot instantiate class: " + className), (Throwable)e);
                return null;
            }
        }
    }

    private static class InflatedOnMenuItemClickListener
    extends MenuItem.OnMenuItemClickListener {
        private static final Class<?>[] PARAM_TYPES = new Class[]{MenuItem.class};
        private Context mContext;
        private Method mMethod;

        public InflatedOnMenuItemClickListener(Context context, String methodName) {
            this.mContext = context;
            Class<?> c = context.getClass();
            try {
                this.mMethod = c.getMethod(methodName, PARAM_TYPES);
            }
            catch (Exception e) {
                InflateException ex = new InflateException("Couldn't resolve menu item onClick handler " + methodName + " in class " + c.getName());
                ex.initCause((Throwable)e);
                throw ex;
            }
        }

        @Override
        public boolean onMenuItemClick(MenuItem item) {
            try {
                if (this.mMethod.getReturnType() == Boolean.TYPE) {
                    return (Boolean)this.mMethod.invoke((Object)this.mContext, item);
                }
                this.mMethod.invoke((Object)this.mContext, item);
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

