/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.widget;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v4.app.ActionBar;
import android.support.v4.view.Menu;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.actionbarsherlock.internal.view.menu.ActionMenuItem;
import com.actionbarsherlock.internal.view.menu.ActionMenuPresenter;
import com.actionbarsherlock.internal.view.menu.ActionMenuView;
import com.actionbarsherlock.internal.view.menu.MenuBuilder;
import com.actionbarsherlock.internal.view.menu.MenuPresenter;
import com.ushahidi.android.app.R;

public final class ActionBarView
extends RelativeLayout {
    private static final int DEFAULT_DISPLAY_OPTIONS = 10;
    private static final int DEFAULT_NAVIGATION_MODE = 0;
    private final Context mContext;
    private final View mHomeAsUpView;
    private final ViewGroup mHomeLayout;
    private final ActionMenuItem mLogoNavItem;
    private final CharSequence mTitle;
    private final TextView mTitleLayout;
    private final CharSequence mSubtitle;
    private final TextView mSubtitleLayout;
    private final ProgressBar mIndeterminateProgress;
    private boolean mAllowsIndeterminateProgress = false;
    private final Spinner mSpinner;
    private SpinnerAdapter mSpinnerAdapter;
    private final AdapterView.OnItemSelectedListener mNavItemSelectedListener;
    private ActionBar.OnNavigationListener mCallback;
    private final FrameLayout mCustomView;
    private View mCustomNavView;
    private ImageView mIconView;
    private Drawable mLogo;
    private Drawable mIcon;
    private final FrameLayout mActionsView;
    private MenuBuilder mOptionsMenu;
    private ActionMenuView mMenuView;
    private ActionMenuPresenter mActionMenuPresenter;
    private final LinearLayout mTabsView;
    private final ViewGroup mTabViewContainer;
    private int mDisplayOptions;
    private int mNavigationMode = -1;
    private boolean mIsConstructing;

    public ActionBarView(Context context) {
        this(context, null);
    }

    public ActionBarView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ActionBarView(final Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mContext = context;
        this.mIsConstructing = true;
        LayoutInflater.from((Context)context).inflate(R.layout.abs__action_bar, (ViewGroup)this, true);
        this.mNavItemSelectedListener = new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
                if (ActionBarView.this.mCallback != null) {
                    ActionBarView.this.mCallback.onNavigationItemSelected(arg2, arg3);
                }
            }

            public void onNothingSelected(AdapterView<?> arg0) {
            }
        };
        this.setBackgroundResource(0);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SherlockTheme, defStyle, 0);
        ApplicationInfo appInfo = context.getApplicationInfo();
        PackageManager pm = context.getPackageManager();
        this.mTitleLayout = (TextView)this.findViewById(R.id.abs__action_bar_title);
        int titleTextStyle = a.getResourceId(R.styleable.SherlockTheme_abTitleTextStyle, 0);
        if (titleTextStyle != 0) {
            this.mTitleLayout.setTextAppearance(context, titleTextStyle);
        }
        this.mTitle = a.getString(R.styleable.SherlockTheme_abTitle);
        if (this.mTitle != null) {
            this.setTitle(this.mTitle);
        }
        this.mSubtitleLayout = (TextView)this.findViewById(R.id.abs__action_bar_subtitle);
        int subtitleTextStyle = a.getResourceId(R.styleable.SherlockTheme_abSubtitleTextStyle, 0);
        if (subtitleTextStyle != 0) {
            this.mSubtitleLayout.setTextAppearance(context, subtitleTextStyle);
        }
        this.mSubtitle = a.getString(R.styleable.SherlockTheme_abSubtitle);
        if (this.mSubtitle != null) {
            this.setSubtitle(this.mSubtitle);
        }
        this.mHomeLayout = (ViewGroup)this.findViewById(R.id.abs__home_wrapper);
        int homeLayoutResource = a.getResourceId(R.styleable.SherlockTheme_abHomeLayout, R.layout.abs__action_bar_home);
        LayoutInflater.from((Context)context).inflate(homeLayoutResource, this.mHomeLayout, true);
        this.mLogo = a.getDrawable(R.styleable.SherlockTheme_abLogo);
        this.mIcon = a.getDrawable(R.styleable.SherlockTheme_abIcon);
        if (this.mIcon == null && context instanceof Activity) {
            this.mIcon = appInfo.loadIcon(pm);
        }
        this.mHomeAsUpView = this.findViewById(R.id.abs__up);
        this.mIconView = (ImageView)this.findViewById(R.id.abs__home);
        this.mSpinner = (Spinner)this.findViewById(R.id.abs__nav_list);
        this.mSpinner.setOnItemSelectedListener(this.mNavItemSelectedListener);
        this.mTabsView = (LinearLayout)this.findViewById(R.id.abs__nav_tabs);
        this.mTabViewContainer = (ViewGroup)this.findViewById(R.id.abs__nav_tabs_layout);
        this.mCustomView = (FrameLayout)this.findViewById(R.id.abs__custom);
        int customViewResourceId = a.getResourceId(R.styleable.SherlockTheme_abCustomNavigationLayout, 0);
        if (customViewResourceId != 0) {
            this.mCustomNavView = LayoutInflater.from((Context)context).inflate(customViewResourceId, (ViewGroup)this.mCustomView, true);
            this.mNavigationMode = 0;
            this.setDisplayOptions(this.mDisplayOptions | 0x10);
        }
        this.mActionsView = (FrameLayout)this.findViewById(R.id.abs__actions);
        this.mIndeterminateProgress = (ProgressBar)this.findViewById(R.id.abs__iprogress);
        this.setDisplayOptions(a.getInteger(R.styleable.SherlockTheme_abDisplayOptions, 10));
        this.setNavigationMode(a.getInteger(R.styleable.SherlockTheme_abNavigationMode, 0));
        a.recycle();
        this.mIsConstructing = false;
        this.mLogoNavItem = new ActionMenuItem(context, 0, 16908332, 0, 0, this.mTitle);
        this.mHomeLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (context instanceof Activity) {
                    ((Activity)context).onMenuItemSelected(0, (MenuItem)ActionBarView.this.mLogoNavItem);
                }
            }
        });
        this.mHomeLayout.setClickable(true);
        this.mHomeLayout.setFocusable(true);
        this.reloadDisplay();
    }

    private boolean getDisplayOptionValue(int flag) {
        return (this.mDisplayOptions & flag) == flag;
    }

    private void reloadDisplay() {
        if (this.mIsConstructing) {
            return;
        }
        boolean isStandard = this.mNavigationMode == 0;
        boolean isList = this.mNavigationMode == 1;
        boolean isTab = this.mNavigationMode == 2;
        boolean isTabUnderAb = isTab && this.getContext().getString(R.string.abs__tab_under_ab_tag).equals(this.mTabsView.getTag());
        boolean hasSubtitle = this.mSubtitleLayout.getText() != null && !this.mSubtitleLayout.getText().equals("");
        boolean displayHome = this.getDisplayOptionValue(2);
        boolean displayHomeAsUp = this.getDisplayOptionValue(4);
        boolean displayTitle = this.getDisplayOptionValue(8);
        boolean displayCustom = this.getDisplayOptionValue(16);
        boolean displayLogo = this.getDisplayOptionValue(1) && this.mLogo != null;
        this.mHomeLayout.setVisibility(displayHome ? 0 : 8);
        if (displayHome) {
            if (this.mHomeAsUpView != null) {
                this.mHomeAsUpView.setVisibility(displayHomeAsUp ? 0 : 8);
            }
            if (this.mIconView != null) {
                this.mIconView.setImageDrawable(displayLogo ? this.mLogo : this.mIcon);
            }
        }
        this.mSpinner.setVisibility(isList ? 0 : 8);
        this.mTabsView.setVisibility(isTab ? 0 : 8);
        if (this.mTabViewContainer != null) {
            this.mTabViewContainer.setVisibility(isTab ? 0 : 8);
        }
        this.mTitleLayout.setVisibility((isStandard || isTabUnderAb) && !displayCustom && displayTitle ? 0 : 8);
        this.mSubtitleLayout.setVisibility((isStandard || isTabUnderAb) && !displayCustom && displayTitle && hasSubtitle ? 0 : 8);
        this.mCustomView.setVisibility(isStandard && displayCustom ? 0 : 8);
    }

    public void initIndeterminateProgress() {
        this.mAllowsIndeterminateProgress = true;
    }

    public void setMenu(Menu menu, MenuPresenter.Callback cb) {
        ViewGroup oldParent;
        MenuBuilder builder;
        if (menu == this.mOptionsMenu) {
            return;
        }
        if (this.mOptionsMenu != null) {
            this.mOptionsMenu.removeMenuPresenter(this.mActionMenuPresenter);
        }
        this.mOptionsMenu = builder = (MenuBuilder)menu;
        if (this.mMenuView != null && (oldParent = (ViewGroup)this.mMenuView.getParent()) != null) {
            oldParent.removeView((View)this.mMenuView);
        }
        if (this.mActionMenuPresenter == null) {
            this.mActionMenuPresenter = new ActionMenuPresenter(this.mContext);
            this.mActionMenuPresenter.setCallback(cb);
            this.mActionMenuPresenter.setId(R.id.abs__action_menu_presenter);
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -1);
        this.configPresenters(builder);
        ActionMenuView menuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView((ViewGroup)this);
        ViewGroup oldParent2 = (ViewGroup)menuView.getParent();
        if (oldParent2 != null && oldParent2 != this) {
            oldParent2.removeView((View)menuView);
        }
        this.mActionsView.addView((View)menuView, (ViewGroup.LayoutParams)layoutParams);
        this.mMenuView = menuView;
    }

    private void configPresenters(MenuBuilder builder) {
        if (builder != null) {
            builder.addMenuPresenter(this.mActionMenuPresenter);
        } else {
            this.mActionMenuPresenter.initForMenu(this.mContext, null);
            this.mActionMenuPresenter.updateMenuView(true);
        }
    }

    public void addTab(ActionBar.Tab tab) {
        int tabCount;
        this.addTab(tab, tabCount, (tabCount = this.getTabCount()) == 0);
    }

    public void addTab(ActionBar.Tab tab, boolean setSelected) {
        this.addTab(tab, this.getTabCount(), setSelected);
    }

    public void addTab(ActionBar.Tab tab, int position) {
        this.addTab(tab, position, this.getTabCount() == 0);
    }

    public void addTab(ActionBar.Tab tab, int position, boolean setSelected) {
        this.mTabsView.addView(((TabImpl)tab).mView, position);
        if (setSelected) {
            tab.select();
        }
    }

    public View getCustomView() {
        return this.mCustomNavView;
    }

    public int getDisplayOptions() {
        return this.mDisplayOptions;
    }

    public SpinnerAdapter getDropdownAdapter() {
        return this.mSpinnerAdapter;
    }

    public int getDropdownSelectedPosition() {
        return this.mSpinner.getSelectedItemPosition();
    }

    public int getNavigationMode() {
        return this.mNavigationMode;
    }

    public ActionBar.Tab getSelectedTab() {
        int count = this.mTabsView.getChildCount();
        for (int i = 0; i < count; ++i) {
            TabImpl tab = (TabImpl)this.mTabsView.getChildAt(i).getTag();
            if (!tab.mView.isSelected()) continue;
            return tab;
        }
        return null;
    }

    public CharSequence getSubtitle() {
        if (this.mNavigationMode == 0 && !this.mSubtitleLayout.getText().equals("")) {
            return this.mSubtitleLayout.getText();
        }
        return null;
    }

    public ActionBar.Tab getTabAt(int index) {
        View view = this.mTabsView.getChildAt(index);
        return view != null ? (TabImpl)view.getTag() : null;
    }

    public int getTabCount() {
        return this.mTabsView.getChildCount();
    }

    public CharSequence getTitle() {
        if (this.mNavigationMode == 0 && !this.mTitleLayout.getText().equals("")) {
            return this.mTitleLayout.getText();
        }
        return null;
    }

    public TabImpl newTab() {
        return new TabImpl(this);
    }

    public void removeAllTabs() {
        TabImpl selected = (TabImpl)this.getSelectedTab();
        if (selected != null) {
            selected.unselect();
        }
        this.mTabsView.removeAllViews();
    }

    public void removeTab(ActionBar.Tab tab) {
        int count = this.mTabsView.getChildCount();
        for (int i = 0; i < count; ++i) {
            TabImpl existingTab = (TabImpl)this.mTabsView.getChildAt(i).getTag();
            if (!existingTab.equals(tab)) continue;
            this.removeTabAt(i);
            break;
        }
    }

    public void removeTabAt(int position) {
        TabImpl tab = (TabImpl)this.getTabAt(position);
        if (tab != null) {
            tab.unselect();
            this.mTabsView.removeViewAt(position);
            if (position > 0) {
                ((TabImpl)this.mTabsView.getChildAt(position - 1).getTag()).select();
            } else if (this.mTabsView.getChildCount() > 0) {
                ((TabImpl)this.mTabsView.getChildAt(0).getTag()).select();
            }
        }
    }

    public void setCallback(ActionBar.OnNavigationListener callback) {
        this.mCallback = callback;
    }

    public void setCustomNavigationView(View view) {
        this.mCustomNavView = view;
        this.mCustomView.removeAllViews();
        this.mCustomView.addView(view);
    }

    public void setDisplayOptions(int options) {
        this.mDisplayOptions = options;
        this.reloadDisplay();
    }

    public void setDropdownAdapter(SpinnerAdapter spinnerAdapter) {
        this.mSpinnerAdapter = spinnerAdapter;
        if (this.mSpinner != null) {
            this.mSpinner.setAdapter(this.mSpinnerAdapter);
        }
    }

    public void setDropdownSelectedPosition(int position) {
        this.mSpinner.setSelection(position);
    }

    public void setProgressBarIndeterminateVisibility(boolean visible) {
        if (this.mAllowsIndeterminateProgress) {
            this.mIndeterminateProgress.setVisibility(visible ? 0 : 8);
        }
    }

    public void setNavigationMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException("Unknown navigation mode value " + Integer.toString(mode));
        }
        if (mode != this.mNavigationMode) {
            this.mNavigationMode = mode;
            this.reloadDisplay();
        }
    }

    public void selectTab(ActionBar.Tab tab) {
        int count = this.mTabsView.getChildCount();
        for (int i = 0; i < count; ++i) {
            TabImpl existingTab = (TabImpl)this.mTabsView.getChildAt(i).getTag();
            if (!existingTab.equals(tab)) continue;
            existingTab.select();
            break;
        }
    }

    public void setSubtitle(CharSequence subtitle) {
        this.mSubtitleLayout.setText(subtitle == null ? "" : subtitle);
        this.reloadDisplay();
    }

    public void setSubtitle(int resId) {
        this.mSubtitleLayout.setText(resId);
        this.reloadDisplay();
    }

    public void setTitle(CharSequence title) {
        this.mTitleLayout.setText(title == null ? "" : title);
    }

    public void setTitle(int resId) {
        this.mTitleLayout.setText(resId);
    }

    private static class TabImpl
    extends ActionBar.Tab {
        private static final View.OnClickListener clickListener = new View.OnClickListener(){

            public void onClick(View v) {
                ((TabImpl)v.getTag()).select();
            }
        };
        final ActionBarView mActionBar;
        final View mView;
        final ImageView mIconView;
        final TextView mTextView;
        final FrameLayout mCustomView;
        ActionBar.TabListener mListener;
        Object mTag;

        TabImpl(ActionBarView actionBar) {
            this.mActionBar = actionBar;
            this.mView = LayoutInflater.from((Context)this.mActionBar.getContext()).inflate(R.layout.abs__action_bar_tab_layout, (ViewGroup)actionBar.mTabsView, false);
            this.mView.setTag((Object)this);
            this.mView.setOnClickListener(clickListener);
            this.mIconView = (ImageView)this.mView.findViewById(R.id.abs__tab_icon);
            this.mTextView = (TextView)this.mView.findViewById(R.id.abs__tab);
            this.mCustomView = (FrameLayout)this.mView.findViewById(R.id.abs__tab_custom);
        }

        void reloadDisplay() {
            boolean hasCustom = this.mCustomView.getChildCount() > 0;
            this.mIconView.setVisibility(hasCustom ? 8 : 0);
            this.mTextView.setVisibility(hasCustom ? 8 : 0);
            this.mCustomView.setVisibility(hasCustom ? 0 : 8);
        }

        @Override
        public View getCustomView() {
            return this.mCustomView.getChildAt(0);
        }

        @Override
        public Drawable getIcon() {
            return this.mIconView.getDrawable();
        }

        @Override
        public int getPosition() {
            int count = this.mActionBar.mTabsView.getChildCount();
            for (int i = 0; i < count; ++i) {
                if (!this.mActionBar.mTabsView.getChildAt(i).getTag().equals(this)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public ActionBar.TabListener getTabListener() {
            return this.mListener;
        }

        @Override
        public Object getTag() {
            return this.mTag;
        }

        @Override
        public CharSequence getText() {
            return this.mTextView.getText();
        }

        @Override
        public TabImpl setCustomView(int layoutResId) {
            this.mCustomView.removeAllViews();
            LayoutInflater.from((Context)this.mActionBar.getContext()).inflate(layoutResId, (ViewGroup)this.mCustomView, true);
            this.reloadDisplay();
            return this;
        }

        @Override
        public TabImpl setCustomView(View view) {
            this.mCustomView.removeAllViews();
            if (view != null) {
                this.mCustomView.addView(view);
            }
            this.reloadDisplay();
            return this;
        }

        @Override
        public TabImpl setIcon(Drawable icon) {
            this.mIconView.setImageDrawable(icon);
            return this;
        }

        @Override
        public TabImpl setIcon(int resId) {
            this.mIconView.setImageResource(resId);
            return this;
        }

        @Override
        public TabImpl setTabListener(ActionBar.TabListener listener) {
            this.mListener = listener;
            return this;
        }

        @Override
        public TabImpl setTag(Object obj) {
            this.mTag = obj;
            return this;
        }

        @Override
        public TabImpl setText(int resId) {
            this.mTextView.setText(resId);
            return this;
        }

        @Override
        public TabImpl setText(CharSequence text) {
            this.mTextView.setText(text);
            return this;
        }

        @Override
        public void select() {
            if (this.mView.isSelected()) {
                if (this.mListener != null) {
                    this.mListener.onTabReselected(this, null);
                }
                return;
            }
            TabImpl current = (TabImpl)this.mActionBar.getSelectedTab();
            if (current != null) {
                current.unselect();
            }
            this.mView.setSelected(true);
            if (this.mListener != null) {
                this.mListener.onTabSelected(this, null);
            }
        }

        void unselect() {
            if (this.mView.isSelected()) {
                this.mView.setSelected(false);
                if (this.mListener != null) {
                    this.mListener.onTabUnselected(this, null);
                }
            }
        }
    }
}

