/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;

public class IcsLinearLayout
extends ViewGroup {
    private static final int[] LinearLayout = new int[]{16843049, 16843562, 16843048, 16843476, 16843561, 16843047};
    private static final int LinearLayout_divider = 0;
    private static final int LinearLayout_dividerPadding = 1;
    private static final int LinearLayout_weightSum = 2;
    private static final int LinearLayout_measureWithLargestChild = 3;
    private static final int LinearLayout_showDividers = 4;
    private static final int LinearLayout_baselineAlignedChildIndex = 5;
    public static final int SHOW_DIVIDER_NONE = 0;
    public static final int SHOW_DIVIDER_BEGINNING = 1;
    public static final int SHOW_DIVIDER_MIDDLE = 2;
    public static final int SHOW_DIVIDER_END = 4;
    private boolean mBaselineAligned = true;
    private int mBaselineAlignedChildIndex = -1;
    private int mBaselineChildTop = 0;
    private int mGravity = 48;
    private int mTotalLength;
    private float mWeightSum;
    private boolean mUseLargestChild;
    private int[] mMaxAscent;
    private int[] mMaxDescent;
    private static final int VERTICAL_GRAVITY_COUNT = 4;
    private static final int INDEX_CENTER_VERTICAL = 0;
    private static final int INDEX_TOP = 1;
    private static final int INDEX_BOTTOM = 2;
    private static final int INDEX_FILL = 3;
    private Drawable mDivider;
    private int mDividerWidth;
    private int mShowDividers;
    private int mDividerPadding;

    public IcsLinearLayout(Context context) {
        super(context);
    }

    public IcsLinearLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IcsLinearLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, LinearLayout, defStyle, 0);
        this.mWeightSum = a.getFloat(2, -1.0f);
        this.mBaselineAlignedChildIndex = a.getInt(5, -1);
        this.mUseLargestChild = a.getBoolean(3, false);
        this.setDividerDrawable(a.getDrawable(0));
        this.mShowDividers = a.getInt(4, 0);
        this.mDividerPadding = a.getDimensionPixelSize(1, 0);
        a.recycle();
    }

    public void setShowDividers(int showDividers) {
        if (showDividers != this.mShowDividers) {
            this.requestLayout();
        }
        this.mShowDividers = showDividers;
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public int getShowDividers() {
        return this.mShowDividers;
    }

    public void setDividerDrawable(Drawable divider) {
        if (divider == this.mDivider) {
            return;
        }
        this.mDivider = divider;
        this.mDividerWidth = divider != null ? divider.getIntrinsicWidth() : 0;
        this.setWillNotDraw(divider == null);
        this.requestLayout();
    }

    public void setDividerPadding(int padding) {
        this.mDividerPadding = padding;
    }

    public int getDividerPadding() {
        return this.mDividerPadding;
    }

    public int getDividerWidth() {
        return this.mDividerWidth;
    }

    protected void onDraw(Canvas canvas) {
        LayoutParams lp;
        if (this.mDivider == null) {
            return;
        }
        int count = this.getVirtualChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getVirtualChildAt(i);
            if (child == null || child.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            lp = (LayoutParams)child.getLayoutParams();
            int left = child.getLeft() - lp.leftMargin;
            this.drawVerticalDivider(canvas, left);
        }
        if (this.hasDividerBeforeChildAt(count)) {
            View child = this.getVirtualChildAt(count - 1);
            int right = 0;
            if (child == null) {
                right = this.getWidth() - this.getPaddingRight() - this.mDividerWidth;
            } else {
                lp = (LayoutParams)child.getLayoutParams();
                right = child.getRight() + lp.rightMargin;
            }
            this.drawVerticalDivider(canvas, right);
        }
    }

    void drawVerticalDivider(Canvas canvas, int left) {
        this.mDivider.setBounds(left, this.getPaddingTop() + this.mDividerPadding, left + this.mDividerWidth, this.getHeight() - this.getPaddingBottom() - this.mDividerPadding);
        this.mDivider.draw(canvas);
    }

    public boolean isBaselineAligned() {
        return this.mBaselineAligned;
    }

    public void setBaselineAligned(boolean baselineAligned) {
        this.mBaselineAligned = baselineAligned;
    }

    public boolean isMeasureWithLargestChildEnabled() {
        return this.mUseLargestChild;
    }

    public void setMeasureWithLargestChildEnabled(boolean enabled) {
        this.mUseLargestChild = enabled;
    }

    public int getBaseline() {
        if (this.mBaselineAlignedChildIndex < 0) {
            return super.getBaseline();
        }
        if (this.getChildCount() <= this.mBaselineAlignedChildIndex) {
            throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout set to an index that is out of bounds.");
        }
        View child = this.getChildAt(this.mBaselineAlignedChildIndex);
        int childBaseline = child.getBaseline();
        if (childBaseline == -1) {
            if (this.mBaselineAlignedChildIndex == 0) {
                return -1;
            }
            throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout points to a View that doesn't know how to get its baseline.");
        }
        int childTop = this.mBaselineChildTop;
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        return childTop + lp.topMargin + childBaseline;
    }

    public int getBaselineAlignedChildIndex() {
        return this.mBaselineAlignedChildIndex;
    }

    public void setBaselineAlignedChildIndex(int i) {
        if (i < 0 || i >= this.getChildCount()) {
            throw new IllegalArgumentException("base aligned child index out of range (0, " + this.getChildCount() + ")");
        }
        this.mBaselineAlignedChildIndex = i;
    }

    View getVirtualChildAt(int index) {
        return this.getChildAt(index);
    }

    int getVirtualChildCount() {
        return this.getChildCount();
    }

    public float getWeightSum() {
        return this.mWeightSum;
    }

    public void setWeightSum(float weightSum) {
        this.mWeightSum = Math.max(0.0f, weightSum);
    }

    protected boolean hasDividerBeforeChildAt(int childIndex) {
        if (childIndex == 0) {
            return (this.mShowDividers & 1) != 0;
        }
        if (childIndex == this.getChildCount()) {
            return (this.mShowDividers & 4) != 0;
        }
        if ((this.mShowDividers & 2) != 0) {
            boolean hasVisibleViewBefore = false;
            for (int i = childIndex - 1; i >= 0; --i) {
                if (this.getChildAt(i).getVisibility() == 8) continue;
                hasVisibleViewBefore = true;
                break;
            }
            return hasVisibleViewBefore;
        }
        return false;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int totalLength;
        LayoutParams lp;
        int i;
        this.mTotalLength = 0;
        int maxHeight = 0;
        int childState = 0;
        int alternativeMaxHeight = 0;
        int weightedMaxHeight = 0;
        boolean allFillParent = true;
        float totalWeight = 0.0f;
        int count = this.getVirtualChildCount();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        boolean matchHeight = false;
        if (this.mMaxAscent == null || this.mMaxDescent == null) {
            this.mMaxAscent = new int[4];
            this.mMaxDescent = new int[4];
        }
        int[] maxAscent = this.mMaxAscent;
        int[] maxDescent = this.mMaxDescent;
        maxAscent[3] = -1;
        maxAscent[2] = -1;
        maxAscent[1] = -1;
        maxAscent[0] = -1;
        maxDescent[3] = -1;
        maxDescent[2] = -1;
        maxDescent[1] = -1;
        maxDescent[0] = -1;
        boolean baselineAligned = this.mBaselineAligned;
        boolean useLargestChild = this.mUseLargestChild;
        boolean isExactly = widthMode == 0x40000000;
        int largestChildWidth = Integer.MIN_VALUE;
        for (i = 0; i < count; ++i) {
            int childBaseline;
            View child = this.getVirtualChildAt(i);
            if (child == null) {
                this.mTotalLength += this.measureNullChild(i);
                continue;
            }
            if (child.getVisibility() == 8) {
                i += this.getChildrenSkipCount(child, i);
                continue;
            }
            if (this.hasDividerBeforeChildAt(i)) {
                this.mTotalLength += this.mDividerWidth;
            }
            lp = (LayoutParams)child.getLayoutParams();
            totalWeight += lp.weight;
            if (widthMode == 0x40000000 && lp.width == 0 && lp.weight > 0.0f) {
                if (isExactly) {
                    this.mTotalLength += lp.leftMargin + lp.rightMargin;
                } else {
                    totalLength = this.mTotalLength;
                    this.mTotalLength = Math.max(totalLength, totalLength + lp.leftMargin + lp.rightMargin);
                }
                if (baselineAligned) {
                    int freeSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                    child.measure(freeSpec, freeSpec);
                }
            } else {
                int oldWidth = Integer.MIN_VALUE;
                if (lp.width == 0 && lp.weight > 0.0f) {
                    oldWidth = 0;
                    lp.width = -2;
                }
                this.measureChildBeforeLayout(child, i, widthMeasureSpec, totalWeight == 0.0f ? this.mTotalLength : 0, heightMeasureSpec, 0);
                if (oldWidth != Integer.MIN_VALUE) {
                    lp.width = oldWidth;
                }
                int childWidth = child.getMeasuredWidth();
                if (isExactly) {
                    this.mTotalLength += childWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child);
                } else {
                    int totalLength2 = this.mTotalLength;
                    this.mTotalLength = Math.max(totalLength2, totalLength2 + childWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child));
                }
                if (useLargestChild) {
                    largestChildWidth = Math.max(childWidth, largestChildWidth);
                }
            }
            boolean matchHeightLocally = false;
            if (heightMode != 0x40000000 && lp.height == -1) {
                matchHeight = true;
                matchHeightLocally = true;
            }
            int margin = lp.topMargin + lp.bottomMargin;
            int childHeight = child.getMeasuredHeight() + margin;
            childState = IcsLinearLayout.combineMeasuredStatesInt(childState, IcsLinearLayout.getMeasuredStateInt(child));
            if (baselineAligned && (childBaseline = child.getBaseline()) != -1) {
                int gravity = (lp.gravity < 0 ? this.mGravity : lp.gravity) & 0x70;
                int index = (gravity >> 4 & 0xFFFFFFFE) >> 1;
                maxAscent[index] = Math.max(maxAscent[index], childBaseline);
                maxDescent[index] = Math.max(maxDescent[index], childHeight - childBaseline);
            }
            maxHeight = Math.max(maxHeight, childHeight);
            boolean bl = allFillParent = allFillParent && lp.height == -1;
            if (lp.weight > 0.0f) {
                weightedMaxHeight = Math.max(weightedMaxHeight, matchHeightLocally ? margin : childHeight);
            } else {
                alternativeMaxHeight = Math.max(alternativeMaxHeight, matchHeightLocally ? margin : childHeight);
            }
            i += this.getChildrenSkipCount(child, i);
        }
        if (this.mTotalLength > 0 && this.hasDividerBeforeChildAt(count)) {
            this.mTotalLength += this.mDividerWidth;
        }
        if (maxAscent[1] != -1 || maxAscent[0] != -1 || maxAscent[2] != -1 || maxAscent[3] != -1) {
            int ascent = Math.max(maxAscent[3], Math.max(maxAscent[0], Math.max(maxAscent[1], maxAscent[2])));
            int descent = Math.max(maxDescent[3], Math.max(maxDescent[0], Math.max(maxDescent[1], maxDescent[2])));
            maxHeight = Math.max(maxHeight, ascent + descent);
        }
        if (useLargestChild && (widthMode == Integer.MIN_VALUE || widthMode == 0)) {
            this.mTotalLength = 0;
            for (i = 0; i < count; ++i) {
                View child = this.getVirtualChildAt(i);
                if (child == null) {
                    this.mTotalLength += this.measureNullChild(i);
                    continue;
                }
                if (child.getVisibility() == 8) {
                    i += this.getChildrenSkipCount(child, i);
                    continue;
                }
                lp = (LayoutParams)child.getLayoutParams();
                if (isExactly) {
                    this.mTotalLength += largestChildWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child);
                    continue;
                }
                totalLength = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength, totalLength + largestChildWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child));
            }
        }
        this.mTotalLength += this.getPaddingLeft() + this.getPaddingRight();
        int widthSize = this.mTotalLength;
        widthSize = Math.max(widthSize, this.getSuggestedMinimumWidth());
        int widthSizeAndState = IcsLinearLayout.resolveSizeAndStateInt(widthSize, widthMeasureSpec, 0);
        int delta = (widthSize = widthSizeAndState & 0xFFFFFF) - this.mTotalLength;
        if (delta != 0 && totalWeight > 0.0f) {
            float weightSum = this.mWeightSum > 0.0f ? this.mWeightSum : totalWeight;
            maxAscent[3] = -1;
            maxAscent[2] = -1;
            maxAscent[1] = -1;
            maxAscent[0] = -1;
            maxDescent[3] = -1;
            maxDescent[2] = -1;
            maxDescent[1] = -1;
            maxDescent[0] = -1;
            maxHeight = -1;
            this.mTotalLength = 0;
            for (int i2 = 0; i2 < count; ++i2) {
                int childBaseline;
                View child = this.getVirtualChildAt(i2);
                if (child == null || child.getVisibility() == 8) continue;
                LayoutParams lp2 = (LayoutParams)child.getLayoutParams();
                float childExtra = lp2.weight;
                if (childExtra > 0.0f) {
                    int share = (int)(childExtra * (float)delta / weightSum);
                    weightSum -= childExtra;
                    delta -= share;
                    int childHeightMeasureSpec = IcsLinearLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom() + lp2.topMargin + lp2.bottomMargin), (int)lp2.height);
                    if (lp2.width != 0 || widthMode != 0x40000000) {
                        int childWidth = child.getMeasuredWidth() + share;
                        if (childWidth < 0) {
                            childWidth = 0;
                        }
                        child.measure(View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000), childHeightMeasureSpec);
                    } else {
                        child.measure(View.MeasureSpec.makeMeasureSpec((int)(share > 0 ? share : 0), (int)0x40000000), childHeightMeasureSpec);
                    }
                    childState = IcsLinearLayout.combineMeasuredStatesInt(childState, IcsLinearLayout.getMeasuredStateInt(child) & 0xFF000000);
                }
                if (isExactly) {
                    this.mTotalLength += child.getMeasuredWidth() + lp2.leftMargin + lp2.rightMargin + this.getNextLocationOffset(child);
                } else {
                    int totalLength3 = this.mTotalLength;
                    this.mTotalLength = Math.max(totalLength3, totalLength3 + child.getMeasuredWidth() + lp2.leftMargin + lp2.rightMargin + this.getNextLocationOffset(child));
                }
                boolean matchHeightLocally = heightMode != 0x40000000 && lp2.height == -1;
                int margin = lp2.topMargin + lp2.bottomMargin;
                int childHeight = child.getMeasuredHeight() + margin;
                maxHeight = Math.max(maxHeight, childHeight);
                alternativeMaxHeight = Math.max(alternativeMaxHeight, matchHeightLocally ? margin : childHeight);
                boolean bl = allFillParent = allFillParent && lp2.height == -1;
                if (!baselineAligned || (childBaseline = child.getBaseline()) == -1) continue;
                int gravity = (lp2.gravity < 0 ? this.mGravity : lp2.gravity) & 0x70;
                int index = (gravity >> 4 & 0xFFFFFFFE) >> 1;
                maxAscent[index] = Math.max(maxAscent[index], childBaseline);
                maxDescent[index] = Math.max(maxDescent[index], childHeight - childBaseline);
            }
            this.mTotalLength += this.getPaddingLeft() + this.getPaddingRight();
            if (maxAscent[1] != -1 || maxAscent[0] != -1 || maxAscent[2] != -1 || maxAscent[3] != -1) {
                int ascent = Math.max(maxAscent[3], Math.max(maxAscent[0], Math.max(maxAscent[1], maxAscent[2])));
                int descent = Math.max(maxDescent[3], Math.max(maxDescent[0], Math.max(maxDescent[1], maxDescent[2])));
                maxHeight = Math.max(maxHeight, ascent + descent);
            }
        } else {
            alternativeMaxHeight = Math.max(alternativeMaxHeight, weightedMaxHeight);
            if (useLargestChild && widthMode == 0) {
                for (int i3 = 0; i3 < count; ++i3) {
                    View child = this.getVirtualChildAt(i3);
                    if (child == null || child.getVisibility() == 8) continue;
                    LayoutParams lp3 = (LayoutParams)child.getLayoutParams();
                    float childExtra = lp3.weight;
                    if (!(childExtra > 0.0f)) continue;
                    child.measure(View.MeasureSpec.makeMeasureSpec((int)largestChildWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)child.getMeasuredHeight(), (int)0x40000000));
                }
            }
        }
        if (!allFillParent && heightMode != 0x40000000) {
            maxHeight = alternativeMaxHeight;
        }
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(widthSizeAndState | childState & 0xFF000000, IcsLinearLayout.resolveSizeAndStateInt(maxHeight, heightMeasureSpec, childState << 16));
        if (matchHeight) {
            this.forceUniformHeight(count, widthMeasureSpec);
        }
    }

    public static int combineMeasuredStatesInt(int curState, int newState) {
        return curState | newState;
    }

    public static int resolveSizeInt(int size, int measureSpec) {
        return IcsLinearLayout.resolveSizeAndStateInt(size, measureSpec, 0) & 0xFFFFFF;
    }

    public static int resolveSizeAndStateInt(int size, int measureSpec, int childMeasuredState) {
        int result = size;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        switch (specMode) {
            case 0: {
                result = size;
                break;
            }
            case -2147483648: {
                if (specSize < size) {
                    result = specSize | 0x1000000;
                    break;
                }
                result = size;
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result | childMeasuredState & 0xFF000000;
    }

    public static int getMeasuredStateInt(View child) {
        return child.getMeasuredWidth() & 0xFF000000 | child.getMeasuredHeight() >> 16 & 0xFFFFFF00;
    }

    private void forceUniformHeight(int count, int widthMeasureSpec) {
        int uniformMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0x40000000);
        for (int i = 0; i < count; ++i) {
            View child = this.getVirtualChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.height != -1) continue;
            int oldWidth = lp.width;
            lp.width = child.getMeasuredWidth();
            this.measureChildWithMargins(child, widthMeasureSpec, 0, uniformMeasureSpec, 0);
            lp.width = oldWidth;
        }
    }

    int getChildrenSkipCount(View child, int index) {
        return 0;
    }

    int measureNullChild(int childIndex) {
        return 0;
    }

    void measureChildBeforeLayout(View child, int childIndex, int widthMeasureSpec, int totalWidth, int heightMeasureSpec, int totalHeight) {
        this.measureChildWithMargins(child, widthMeasureSpec, totalWidth, heightMeasureSpec, totalHeight);
    }

    int getLocationOffset(View child) {
        return 0;
    }

    int getNextLocationOffset(View child) {
        return 0;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        boolean isLayoutRtl = false;
        int paddingTop = this.getPaddingTop();
        int height = this.getBottom() - this.getTop();
        int childBottom = height - this.getPaddingBottom();
        int childSpace = height - paddingTop - this.getPaddingBottom();
        int count = this.getVirtualChildCount();
        int minorGravity = this.mGravity & 0x70;
        boolean baselineAligned = this.mBaselineAligned;
        int[] maxAscent = this.mMaxAscent;
        int[] maxDescent = this.mMaxDescent;
        int childLeft = this.getPaddingLeft();
        int start = 0;
        int dir = 1;
        for (int i = 0; i < count; ++i) {
            int childTop;
            int gravity;
            int childIndex = start + dir * i;
            View child = this.getVirtualChildAt(childIndex);
            if (child == null) {
                childLeft += this.measureNullChild(childIndex);
                continue;
            }
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            int childBaseline = -1;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (baselineAligned && lp.height != -1) {
                childBaseline = child.getBaseline();
            }
            if ((gravity = lp.gravity) < 0) {
                gravity = minorGravity;
            }
            switch (gravity & 0x70) {
                case 48: {
                    childTop = paddingTop + lp.topMargin;
                    if (childBaseline == -1) break;
                    childTop += maxAscent[1] - childBaseline;
                    break;
                }
                case 16: {
                    childTop = paddingTop + (childSpace - childHeight) / 2 + lp.topMargin - lp.bottomMargin;
                    break;
                }
                case 80: {
                    childTop = childBottom - childHeight - lp.bottomMargin;
                    if (childBaseline == -1) break;
                    int descent = child.getMeasuredHeight() - childBaseline;
                    childTop -= maxDescent[2] - descent;
                    break;
                }
                default: {
                    childTop = paddingTop;
                }
            }
            if (this.hasDividerBeforeChildAt(childIndex)) {
                childLeft += this.mDividerWidth;
            }
            this.setChildFrame(child, (childLeft += lp.leftMargin) + this.getLocationOffset(child), childTop, childWidth, childHeight);
            childLeft += childWidth + lp.rightMargin + this.getNextLocationOffset(child);
            i += this.getChildrenSkipCount(child, childIndex);
        }
    }

    private void setChildFrame(View child, int left, int top, int width, int height) {
        child.layout(left, top, left + width, top + height);
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public float weight;
        public int gravity = -1;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            this.weight = 0.0f;
            this.gravity = -1;
        }

        public LayoutParams(int width, int height) {
            super(width, height);
            this.weight = 0.0f;
        }

        public LayoutParams(int width, int height, float weight) {
            super(width, height);
            this.weight = weight;
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }
    }
}

