/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Environment;
import com.ushahidi.android.app.net.MainHttpClient;
import com.ushahidi.android.app.util.PhotoUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageManager {
    private static final String PHOTO = "/fetched";
    private static final String PENDING = "/pending";

    public static Drawable getDrawables(Context context, String fileName) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)(ImageManager.getPhotoPath(context) + fileName), (BitmapFactory.Options)options);
        if (options != null) {
            Bitmap scaled = PhotoUtils.scaleBitmap(options, ImageManager.getPhotoPath(context) + fileName);
            return new BitmapDrawable(scaled);
        }
        return null;
    }

    public static Bitmap getBitmaps(Context context, String fileName) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)(ImageManager.getPhotoPath(context) + fileName), (BitmapFactory.Options)options);
        if (options != null) {
            return PhotoUtils.scaleBitmap(options, ImageManager.getPhotoPath(context) + fileName);
        }
        return null;
    }

    public static Drawable getDrawables2(Context context, String pathfileName) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)(ImageManager.getPhotoPath(context) + ImageManager.getPhotoPath(context, "/" + pathfileName)), (BitmapFactory.Options)options);
        if (options != null) {
            Bitmap scaled = PhotoUtils.scaleBitmap(options, ImageManager.getPhotoPath(context, "/" + pathfileName));
            return new BitmapDrawable(scaled);
        }
        return null;
    }

    public static Drawable getDrawables(Context context, String fileName, int width) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)(ImageManager.getPhotoPath(context) + fileName), (BitmapFactory.Options)options);
        if (options != null) {
            Bitmap scaled = PhotoUtils.scaleBitmapByWidth(options, width, ImageManager.getPhotoPath(context) + fileName);
            return new BitmapDrawable(scaled);
        }
        return null;
    }

    public static Bitmap getBitmaps(Context context, String fileName, int width) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)(ImageManager.getPhotoPath(context) + fileName), (BitmapFactory.Options)options);
        if (options != null) {
            return PhotoUtils.scaleBitmapByWidth(options, width, ImageManager.getPhotoPath(context) + fileName);
        }
        return null;
    }

    public static Drawable getPendingDrawables(Context context, String fileName) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)(ImageManager.getPhotoPath(context) + fileName), (BitmapFactory.Options)options);
        if (options != null) {
            Bitmap scaled = PhotoUtils.scaleBitmap(options, fileName);
            return new BitmapDrawable(scaled);
        }
        return null;
    }

    public static Drawable getPendingDrawables(Context context, String fileName, int width) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)(ImageManager.getPhotoPath(context) + fileName), (BitmapFactory.Options)options);
        if (options != null) {
            Bitmap scaled = PhotoUtils.scaleBitmapByWidth(options, width, fileName);
            return new BitmapDrawable(scaled);
        }
        return null;
    }

    public static Drawable getThumbnails(Context context, String fileName) {
        Bitmap original = BitmapFactory.decodeFile((String)(ImageManager.getPhotoPath(context) + fileName));
        if (original != null) {
            Bitmap scaled = PhotoUtils.scaleThumbnail(original);
            return new BitmapDrawable(scaled);
        }
        return null;
    }

    public static Bitmap getBitmapThumbnails(Context context, String fileName) {
        Bitmap original = BitmapFactory.decodeFile((String)(ImageManager.getPhotoPath(context) + fileName));
        if (original != null) {
            return PhotoUtils.scaleThumbnail(original);
        }
        return null;
    }

    protected static byte[] retrieveImageData(String imageUrl, Context context) throws IOException {
        MainHttpClient httpClient = new MainHttpClient(context);
        return httpClient.fetchImage(imageUrl);
    }

    public static void downloadImage(String imageUrl, String filename, Context context) {
        try {
            byte[] imageData = ImageManager.retrieveImageData(imageUrl, context);
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])imageData, (int)0, (int)imageData.length);
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 75, (OutputStream)byteArray);
            bitmap.recycle();
            ImageManager.writeImage(byteArray.toByteArray(), filename, ImageManager.getPhotoPath(context));
            byteArray.flush();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void writeImage(byte[] data, String filename, String path) {
        ImageManager.deleteImage(filename, path);
        if (data != null) {
            try {
                FileOutputStream fOut = new FileOutputStream(new File(path, filename), false);
                fOut.write(data);
                fOut.flush();
                fOut.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    public static String getSavedPhotoPath(Context context, String folder) {
        File path = new File(Environment.getExternalStorageDirectory(), String.format("%s%s%s", context.getPackageName(), "/", folder));
        if (!path.exists() && ImageManager.createDirectory(context)) {
            return path.getAbsolutePath() + "/";
        }
        return path.getAbsolutePath() + "/";
    }

    public static String getPhotoPath(Context context) {
        return ImageManager.getSavedPhotoPath(context, PHOTO);
    }

    public static String getPhotoPath(Context context, String pathfileName) {
        File path = new File(Environment.getExternalStorageDirectory(), String.format("%s%s%s", context.getPackageName(), "/", pathfileName));
        if (!path.exists()) {
            return null;
        }
        return path.getAbsolutePath();
    }

    public static String getPendingPhotoPath(Context context) {
        return ImageManager.getSavedPhotoPath(context, PENDING);
    }

    public static boolean deletePendingPhoto(Context context, String fileName) {
        return ImageManager.deleteImage2(ImageManager.getSavedPhotoPath(context, fileName));
    }

    public static boolean deleteImage2(String path) {
        File f = new File(path);
        if (f.exists()) {
            f.delete();
            return true;
        }
        return false;
    }

    public static void deleteImage(String filename, String path) {
        File f = new File(path, filename);
        if (f.exists()) {
            f.delete();
        }
    }

    private static boolean isExternalStoragePresent() {
        boolean mExternalStorageAvailable = false;
        boolean mExternalStorageWriteable = false;
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state)) {
            mExternalStorageWriteable = true;
            mExternalStorageAvailable = true;
        } else if ("mounted_ro".equals(state)) {
            mExternalStorageAvailable = true;
            mExternalStorageWriteable = false;
        } else {
            mExternalStorageWriteable = false;
            mExternalStorageAvailable = false;
        }
        return mExternalStorageAvailable && mExternalStorageWriteable;
    }

    private static boolean createDirectory(Context context) {
        File file;
        return !ImageManager.isExternalStoragePresent() || (file = new File(Environment.getExternalStorageDirectory(), context.getPackageName() + PHOTO)).exists() || file.mkdirs();
    }

    public static void deleteImages(Context context) {
        if (ImageManager.isExternalStoragePresent()) {
            File path = new File(Environment.getExternalStorageDirectory(), context.getPackageName() + PHOTO);
            ImageManager.deleteFiles(path);
        }
    }

    public static void deletePendingImages(Context context) {
        if (ImageManager.isExternalStoragePresent()) {
            File path = new File(Environment.getExternalStorageDirectory(), context.getPackageName() + PENDING);
            ImageManager.deleteFiles(path);
        }
    }

    private static boolean deleteFiles(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            if (files == null) {
                return false;
            }
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
        return true;
    }

    public static void movePendingPhotos(Context context) {
        File[] pendingPhotos = PhotoUtils.getPendingPhotos(context);
        if (pendingPhotos != null && pendingPhotos.length > 0) {
            for (File file : pendingPhotos) {
                if (!file.exists() || !file.renameTo(new File(ImageManager.getPhotoPath(context) + file.getName()))) continue;
                file.delete();
            }
        }
    }
}

