/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app;

import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.ItemizedOverlay;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import com.google.android.maps.Overlay;
import com.google.android.maps.OverlayItem;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.views.BalloonOverlayView;
import java.util.List;

public abstract class MapItemizedOverlay<Item extends OverlayItem>
extends ItemizedOverlay<Item> {
    private MapView mapView;
    private BalloonOverlayView<Item> balloonView;
    private View clickRegion;
    private View closeRegion;
    private int viewOffset;
    final MapController mc;
    private Item currentFocusedItem;
    private int currentFocusedIndex;

    public MapItemizedOverlay(Drawable marker, MapView mapView) {
        super(marker);
        this.mapView = mapView;
        this.viewOffset = 30;
        this.mc = mapView.getController();
    }

    public void setBalloonBottomOffset(int pixels) {
        this.viewOffset = pixels;
    }

    public int getBalloonBottomOffset() {
        return this.viewOffset;
    }

    protected boolean onBalloonTap(int index, Item item) {
        return false;
    }

    protected void onBalloonOpen(int index) {
    }

    public final boolean onTap(int index) {
        this.currentFocusedIndex = index;
        this.currentFocusedItem = this.createItem(index);
        this.setLastFocusedIndex(index);
        this.onBalloonOpen(index);
        this.createAndDisplayBalloonOverlay();
        this.mc.animateTo(this.currentFocusedItem.getPoint());
        return true;
    }

    protected BalloonOverlayView<Item> createBalloonOverlayView() {
        return new BalloonOverlayView(this.getMapView().getContext(), this.getBalloonBottomOffset());
    }

    protected MapView getMapView() {
        return this.mapView;
    }

    public void hideBalloon() {
        if (this.balloonView != null) {
            this.balloonView.setVisibility(8);
        }
        this.currentFocusedItem = null;
    }

    private void hideOtherBalloons(List<Overlay> overlays) {
        for (Overlay overlay : overlays) {
            if (!(overlay instanceof MapItemizedOverlay) || overlay == this) continue;
            ((MapItemizedOverlay)overlay).hideBalloon();
        }
    }

    private View.OnTouchListener createBalloonTouchListener() {
        return new View.OnTouchListener(){
            float startX;
            float startY;

            public boolean onTouch(View v, MotionEvent event) {
                View l = ((View)v.getParent()).findViewById(R.id.balloon_main_layout);
                Drawable d = l.getBackground();
                if (event.getAction() == 0) {
                    int[] states = new int[]{16842919};
                    if (d.setState(states)) {
                        d.invalidateSelf();
                    }
                    this.startX = event.getX();
                    this.startY = event.getY();
                    return true;
                }
                if (event.getAction() == 1) {
                    int[] newStates = new int[0];
                    if (d.setState(newStates)) {
                        d.invalidateSelf();
                    }
                    if (Math.abs(this.startX - event.getX()) < 40.0f && Math.abs(this.startY - event.getY()) < 40.0f) {
                        MapItemizedOverlay.this.onBalloonTap(MapItemizedOverlay.this.currentFocusedIndex, MapItemizedOverlay.this.currentFocusedItem);
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public Item getFocus() {
        return this.currentFocusedItem;
    }

    public void setFocus(Item item) {
        super.setFocus(item);
        this.currentFocusedIndex = this.getLastFocusedIndex();
        this.currentFocusedItem = item;
        if (this.currentFocusedItem == null) {
            this.hideBalloon();
        } else {
            this.createAndDisplayBalloonOverlay();
        }
    }

    private boolean createAndDisplayBalloonOverlay() {
        boolean isRecycled;
        if (this.balloonView == null) {
            this.balloonView = this.createBalloonOverlayView();
            this.clickRegion = this.balloonView.findViewById(R.id.balloon_inner_layout);
            this.clickRegion.setOnTouchListener(this.createBalloonTouchListener());
            this.closeRegion = this.balloonView.findViewById(R.id.balloon_close);
            if (this.closeRegion != null) {
                this.closeRegion.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        MapItemizedOverlay.this.hideBalloon();
                    }
                });
            }
            isRecycled = false;
        } else {
            isRecycled = true;
        }
        this.balloonView.setVisibility(8);
        List mapOverlays = this.mapView.getOverlays();
        if (mapOverlays.size() > 1) {
            this.hideOtherBalloons(mapOverlays);
        }
        if (this.currentFocusedItem != null) {
            this.balloonView.setData(this.currentFocusedItem);
        }
        GeoPoint point = this.currentFocusedItem.getPoint();
        MapView.LayoutParams params = new MapView.LayoutParams(-2, -2, point, 81);
        params.mode = 0;
        this.balloonView.setVisibility(0);
        if (isRecycled) {
            this.balloonView.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            this.mapView.addView(this.balloonView, (ViewGroup.LayoutParams)params);
        }
        return isRecycled;
    }
}

