/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.support.v4.app.FragmentMapActivity;
import android.util.Log;
import android.view.MotionEvent;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.ItemizedOverlay;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import com.google.android.maps.Overlay;
import com.google.android.maps.OverlayItem;
import com.ushahidi.android.app.R;
import java.util.Date;

public abstract class MapUserLocation
extends FragmentMapActivity
implements LocationListener {
    protected static final int ONE_MINUTE = 60000;
    protected static final int FIVE_MINUTES = 300000;
    protected static final int ACCURACY_THRESHOLD = 30;
    protected MapView mapView;
    protected MapController mapController;
    protected LocationManager locationManager;
    protected UpdatableMarker updatableMarker;
    protected Location currrentLocation;

    protected abstract void locationChanged(double var1, double var3);

    protected UpdatableMarker createUpdatableMarker(Drawable marker, GeoPoint point) {
        return new MapMarker(marker, point);
    }

    protected void setDeviceLocation() {
        this.locationManager = (LocationManager)this.getSystemService("location");
        Location lastNetLocation = null;
        Location lastGpsLocation = null;
        boolean netAvailable = this.locationManager.isProviderEnabled("network");
        boolean gpsAvailable = this.locationManager.isProviderEnabled("gps");
        if (!netAvailable && !gpsAvailable) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setTitle((CharSequence)this.getString(R.string.location_disabled)).setMessage((CharSequence)this.getString(R.string.location_reenable)).setPositiveButton(17039379, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    MapUserLocation.this.startActivity(new Intent("android.settings.LOCATION_SOURCE_SETTINGS"));
                }
            }).setNegativeButton(17039369, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    dialog.cancel();
                }
            }).create().show();
        }
        if (netAvailable) {
            lastNetLocation = this.locationManager.getLastKnownLocation("network");
        }
        if (gpsAvailable) {
            lastGpsLocation = this.locationManager.getLastKnownLocation("gps");
        }
        this.setBestLocation(lastNetLocation, lastGpsLocation);
        if (this.currrentLocation == null || new Date().getTime() - this.currrentLocation.getTime() > 60000L) {
            if (netAvailable) {
                this.locationManager.requestLocationUpdates("network", 0L, 0.0f, (LocationListener)this);
            }
            if (gpsAvailable) {
                this.locationManager.requestLocationUpdates("gps", 0L, 0.0f, (LocationListener)this);
            }
        }
    }

    public void stopLocating() {
        if (this.locationManager != null) {
            try {
                this.locationManager.removeUpdates((LocationListener)this);
            }
            catch (Exception ex) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"stopLocating", (Throwable)ex);
            }
            this.locationManager = null;
        }
    }

    protected void updateMarker(double latitude, double longitude, boolean center) {
        this.updateMarker(this.getPoint(latitude, longitude), center);
    }

    protected void updateMarker(GeoPoint point, boolean center) {
        if (this.updatableMarker == null) {
            Drawable marker = this.getResources().getDrawable(R.drawable.map_marker_green);
            marker.setBounds(0, 0, marker.getIntrinsicWidth(), marker.getIntrinsicHeight());
            this.mapController.setZoom(14);
            this.mapView.setBuiltInZoomControls(false);
            this.updatableMarker = this.createUpdatableMarker(marker, point);
            this.mapView.getOverlays().add((Overlay)this.updatableMarker);
        } else {
            this.updatableMarker.update(point);
        }
        if (center) {
            this.mapController.animateTo(point);
        }
    }

    protected GeoPoint getPoint(double latitude, double longitude) {
        return new GeoPoint((int)(latitude * 1000000.0), (int)(longitude * 1000000.0));
    }

    protected void setBestLocation(Location location1, Location location2) {
        if (location1 != null && location2 != null) {
            boolean location2MoreAccurate;
            boolean location1Newer = location1.getTime() - location2.getTime() > 300000L;
            boolean location2Newer = location2.getTime() - location1.getTime() > 300000L;
            boolean location1MoreAccurate = location1.getAccuracy() < location2.getAccuracy();
            boolean bl = location2MoreAccurate = location2.getAccuracy() < location1.getAccuracy();
            if (location1Newer || location1MoreAccurate) {
                this.locationChanged(location1.getLatitude(), location1.getLongitude());
            } else if (location2Newer || location2MoreAccurate) {
                this.locationChanged(location2.getLatitude(), location2.getLongitude());
            }
        } else if (location1 != null) {
            this.locationChanged(location1.getLatitude(), location1.getLongitude());
        } else if (location2 != null) {
            this.locationChanged(location2.getLatitude(), location2.getLongitude());
        }
    }

    protected boolean isRouteDisplayed() {
        return false;
    }

    public void onLocationChanged(Location location) {
        if (location != null) {
            this.locationChanged(location.getLatitude(), location.getLongitude());
            if (location.hasAccuracy() && location.getAccuracy() < 30.0f) {
                this.stopLocating();
            }
        }
    }

    public void onProviderDisabled(String provider) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    protected void onResume() {
        super.onResume();
        this.setDeviceLocation();
    }

    protected void onPause() {
        super.onPause();
        this.stopLocating();
    }

    protected void onDestroy() {
        super.onPause();
        this.stopLocating();
    }

    public static interface UpdatableMarker {
        public void update(GeoPoint var1);
    }

    private class MapMarker
    extends ItemizedOverlay<OverlayItem>
    implements UpdatableMarker {
        private OverlayItem myOverlayItem;
        private long lastTouchTime;

        public MapMarker(Drawable defaultMarker, GeoPoint point) {
            super(MapMarker.boundCenterBottom((Drawable)defaultMarker));
            this.lastTouchTime = -1L;
            this.update(point);
        }

        @Override
        public void update(GeoPoint point) {
            this.myOverlayItem = new OverlayItem(point, " ", " ");
            this.populate();
        }

        protected OverlayItem createItem(int i) {
            return this.myOverlayItem;
        }

        public int size() {
            return 1;
        }

        public boolean onTouchEvent(MotionEvent event, MapView mapView) {
            int action = event.getAction();
            int x = (int)event.getX();
            int y = (int)event.getY();
            if (action == 0) {
                long thisTime = System.currentTimeMillis();
                if (thisTime - this.lastTouchTime < 250L) {
                    this.lastTouchTime = -1L;
                    GeoPoint geoPoint = mapView.getProjection().fromPixels((int)event.getX(), (int)event.getY());
                    double latitude = (double)geoPoint.getLatitudeE6() / 1000000.0;
                    double longitude = (double)geoPoint.getLongitudeE6() / 1000000.0;
                    Log.i((String)this.getClass().getSimpleName(), (String)String.format("%d, %d >> %f, %f", x, y, latitude, longitude));
                    MapUserLocation.this.locationChanged(latitude, longitude);
                    return true;
                }
                this.lastTouchTime = thisTime;
            }
            return super.onTouchEvent(event, mapView);
        }
    }
}

