/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app;

import android.app.Activity;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import com.google.android.maps.MapView;
import com.google.android.maps.OverlayItem;
import com.ushahidi.android.app.MapItemizedOverlay;
import com.ushahidi.android.app.ReportMapOverlayItem;
import com.ushahidi.android.app.views.BalloonOverlayView;
import com.ushahidi.android.app.views.ReportMapBallonOverlayView;
import java.util.ArrayList;

public class ReportMapItemizedOverlay<Item extends OverlayItem>
extends MapItemizedOverlay<ReportMapOverlayItem> {
    private ArrayList<ReportMapOverlayItem> items = new ArrayList();
    private Activity mActivity;
    private Drawable marker;

    public ReportMapItemizedOverlay(Drawable marker, MapView mapView, Activity activity) {
        super(ReportMapItemizedOverlay.boundCenter((Drawable)marker), mapView);
        this.mActivity = activity;
        this.marker = marker;
    }

    public void addOverlay(ReportMapOverlayItem overlay) {
        this.items.add(overlay);
        this.populate();
    }

    protected ReportMapOverlayItem createItem(int i) {
        return this.items.get(i);
    }

    public int size() {
        return this.items.size();
    }

    @Override
    protected boolean onBalloonTap(int index, ReportMapOverlayItem item) {
        ReportMapBallonOverlayView.viewReports(index, item.getFilterCategory());
        this.hideBalloon();
        return true;
    }

    @Override
    protected BalloonOverlayView<ReportMapOverlayItem> createBalloonOverlayView() {
        return new ReportMapBallonOverlayView(this.getMapView().getContext(), this.getBalloonBottomOffset(), this.mActivity);
    }

    public void draw(Canvas canvas, MapView mapView, boolean shadow) {
        super.draw(canvas, mapView, shadow);
        ReportMapItemizedOverlay.boundCenterBottom((Drawable)this.marker);
    }
}

