/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.EditTextPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceCategory;
import android.preference.PreferenceScreen;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.ui.SeekBarPreference;
import com.ushahidi.android.app.util.Util;

public class Settings
extends PreferenceActivity
implements SharedPreferences.OnSharedPreferenceChangeListener {
    private EditTextPreference firstNamePref;
    private EditTextPreference lastNamePref;
    private EditTextPreference emailAddressPref;
    private EditTextPreference phoneNumberPref;
    private ListPreference totalReportsPref;
    private SeekBarPreference photoSizePref;
    private SharedPreferences settings;
    private SharedPreferences.Editor editor;
    public static final String EMAIL_ADDRESS_PREFERENCE = "email_address_preference";
    public static final String PHONE_NUMBER_PREFERENCE = "phone_number_preference";
    public static final String CHECKIN_PREFERENCE = "checkin_preference";
    public static final String PHOTO_SIZE_PREFERENCE = "photo_size_preference";
    private String recentReports = "";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.addPreferencesFromResource(R.xml.preferences);
        this.firstNamePref = new EditTextPreference((Context)this);
        this.lastNamePref = new EditTextPreference((Context)this);
        this.emailAddressPref = new EditTextPreference((Context)this);
        this.phoneNumberPref = new EditTextPreference((Context)this);
        this.photoSizePref = (SeekBarPreference)this.getPreferenceScreen().findPreference((CharSequence)PHOTO_SIZE_PREFERENCE);
        this.recentReports = this.getString(R.string.recent_reports);
        this.totalReportsPref = new ListPreference((Context)this);
        new ListPreference((Context)this);
        this.setPreferenceScreen(this.createPreferenceHierarchy());
        this.saveSettings();
    }

    private PreferenceScreen createPreferenceHierarchy() {
        PreferenceScreen root = this.getPreferenceManager().createPreferenceScreen((Context)this);
        PreferenceCategory basicPrefCat = new PreferenceCategory((Context)this);
        basicPrefCat.setTitle(R.string.basic_settings);
        root.addPreference((Preference)basicPrefCat);
        CharSequence[] totalReportsEntries = new CharSequence[]{"20 ".concat(this.recentReports), "40 ".concat(this.recentReports), "60 ".concat(this.recentReports), "80 ".concat(this.recentReports), "100 ".concat(this.recentReports), "250 ".concat(this.recentReports), "500 ".concat(this.recentReports), "1000 ".concat(this.recentReports)};
        CharSequence[] totalReportsValues = new CharSequence[]{"20", "40", "60", "80", "100", "250", "500", "1000"};
        this.totalReportsPref.setEntries(totalReportsEntries);
        this.totalReportsPref.setEntryValues(totalReportsValues);
        this.totalReportsPref.setDefaultValue((Object)totalReportsValues[0]);
        this.totalReportsPref.setDialogTitle(R.string.total_reports);
        this.totalReportsPref.setKey("total_reports_preference");
        this.totalReportsPref.setTitle(R.string.total_reports);
        this.totalReportsPref.setSummary(R.string.hint_total_reports);
        basicPrefCat.addPreference((Preference)this.totalReportsPref);
        this.firstNamePref.setDialogTitle(R.string.txt_first_name);
        this.firstNamePref.setKey("first_name_preference");
        this.firstNamePref.setTitle(R.string.txt_first_name);
        this.firstNamePref.setSummary(R.string.hint_first_name);
        this.firstNamePref.getEditText().setInputType(96);
        basicPrefCat.addPreference((Preference)this.firstNamePref);
        this.lastNamePref.setDialogTitle(R.string.txt_last_name);
        this.lastNamePref.setKey("last_name_preference");
        this.lastNamePref.setTitle(R.string.txt_last_name);
        this.lastNamePref.setSummary(R.string.hint_last_name);
        this.lastNamePref.getEditText().setInputType(96);
        basicPrefCat.addPreference((Preference)this.lastNamePref);
        this.emailAddressPref.setDialogTitle(R.string.txt_email);
        this.emailAddressPref.setKey(EMAIL_ADDRESS_PREFERENCE);
        this.emailAddressPref.setTitle(R.string.txt_email);
        this.emailAddressPref.setSummary(R.string.hint_email);
        this.emailAddressPref.getEditText().setInputType(32);
        basicPrefCat.addPreference((Preference)this.emailAddressPref);
        this.phoneNumberPref.setDialogTitle(R.string.txt_phonenumber);
        this.phoneNumberPref.setKey(PHONE_NUMBER_PREFERENCE);
        this.phoneNumberPref.setTitle(R.string.txt_phonenumber);
        this.phoneNumberPref.setSummary(R.string.hint_phonenumber);
        this.phoneNumberPref.getEditText().setInputType(3);
        basicPrefCat.addPreference((Preference)this.photoSizePref);
        return root;
    }

    protected void saveSettings() {
        this.settings = this.getSharedPreferences("UshahidiService", 0);
        this.editor = this.settings.edit();
        String totalReports = this.totalReportsPref.getValue();
        this.editor.putString("Domain", Preferences.domain);
        this.editor.putString("Firstname", this.firstNamePref.getText());
        this.editor.putString("Lastname", this.lastNamePref.getText());
        this.editor.putString("Email", this.emailAddressPref.getText());
        this.editor.putString("Phonenumber", this.phoneNumberPref.getText());
        this.editor.putString("TotalReports", totalReports);
        this.editor.putInt("CheckinEnabled", Preferences.isCheckinEnabled);
        this.editor.putInt("PhotoWidth", this.photoSizePref.getProgress());
        this.editor.commit();
    }

    protected void onResume() {
        super.onResume();
        this.getPreferenceScreen().getSharedPreferences().registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        this.saveSettings();
    }

    protected void onPause() {
        super.onPause();
        this.getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        if (key.equals(PHOTO_SIZE_PREFERENCE) && sharedPreferences.getInt(PHOTO_SIZE_PREFERENCE, 200) > Preferences.photoWidth) {
            Preferences.photoWidth = sharedPreferences.getInt(PHOTO_SIZE_PREFERENCE, 200);
        }
        if (key.equals(EMAIL_ADDRESS_PREFERENCE) && !Util.validateEmail(sharedPreferences.getString(EMAIL_ADDRESS_PREFERENCE, ""))) {
            Util.showToast((Context)this, R.string.invalid_email_address);
        }
        this.saveSettings();
    }
}

