/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.ActionBar;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.Menu;
import android.support.v4.view.MenuItem;
import android.view.KeyEvent;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.Toast;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.util.Objects;
import com.ushahidi.android.app.util.Util;
import com.ushahidi.android.app.views.View;
import java.lang.reflect.InvocationTargetException;

public abstract class BaseActivity<V extends View>
extends FragmentActivity {
    protected final int layout;
    protected final int menu;
    protected final Class<V> viewClass;
    protected V view;
    protected ActionBar actionBar;

    protected BaseActivity(Class<V> view, int layout2, int menu2) {
        this.viewClass = view;
        this.layout = layout2;
        this.menu = menu2;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.log("onCreate");
        this.actionBar = this.getSupportActionBar();
        this.actionBar.setDisplayHomeAsUpEnabled(true);
        if (this.layout != 0) {
            this.setContentView(this.layout);
        }
        this.view = (View)Objects.createInstance(this.viewClass, Activity.class, this);
    }

    @Override
    protected void onStart() {
        super.onStart();
        this.log("onStart");
    }

    protected void onRestart() {
        super.onRestart();
        this.log("onRestart");
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.log("onResume");
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.log("onPause");
    }

    @Override
    protected void onStop() {
        super.onStop();
        this.log("onStop");
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.log("onDestroy");
    }

    protected void setActionBarTitle(String title) {
        this.getSupportActionBar().setTitle(title);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getRepeatCount() == 0) {
            this.log("onKeyDown KEYCODE_BACK");
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.log("onActivityResult");
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu2) {
        if (this.menu != 0) {
            this.getMenuInflater().inflate(this.menu, (android.view.Menu)menu2);
            return true;
        }
        return false;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        return super.onOptionsItemSelected(item);
    }

    @Override
    public boolean onContextItemSelected(android.view.MenuItem item) {
        return super.onContextItemSelected(item);
    }

    public void openActivityOrFragment(Intent intent) {
        this.startActivity(intent);
    }

    protected void shareText(String shareItem) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.TEXT", shareItem);
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)this.getText(R.string.title_share)));
    }

    protected void sharePhoto(String path) {
        Preferences.loadSettings((Context)this);
        String reportUrl = Preferences.domain;
        String shareString = this.getString(R.string.share_template, new Object[]{" ", " " + reportUrl});
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("image/jpg");
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.parse((String)("file://" + path)));
        intent.putExtra("android.intent.extra.TEXT", shareString);
        this.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)this.getText(R.string.title_share)), 0);
        this.setResult(-1);
    }

    public static Bundle intentToFragmentArguments(Intent intent) {
        Bundle extras;
        Bundle arguments = new Bundle();
        if (intent == null) {
            return arguments;
        }
        Uri data = intent.getData();
        if (data != null) {
            arguments.putParcelable("_uri", (Parcelable)data);
        }
        if ((extras = intent.getExtras()) != null) {
            arguments.putAll(intent.getExtras());
        }
        return arguments;
    }

    public static Intent fragmentArgumentsToIntent(Bundle arguments) {
        Intent intent = new Intent();
        if (arguments == null) {
            return intent;
        }
        Uri data = (Uri)arguments.getParcelable("_uri");
        if (data != null) {
            intent.setData(data);
        }
        intent.putExtras(arguments);
        intent.removeExtra("_uri");
        return intent;
    }

    protected EditText findEditTextById(int id2) {
        return (EditText)this.findViewById(id2);
    }

    protected ListView findListViewById(int id2) {
        return (ListView)this.findViewById(id2);
    }

    protected TextView findTextViewById(int id2) {
        return (TextView)this.findViewById(id2);
    }

    protected Spinner findSpinnerById(int id2) {
        return (Spinner)this.findViewById(id2);
    }

    protected TimePicker findTimePickerById(int id2) {
        return (TimePicker)this.findViewById(id2);
    }

    protected Button findButtonById(int id2) {
        return (Button)this.findViewById(id2);
    }

    protected ImageView findImageViewById(int id2) {
        return (ImageView)this.findViewById(id2);
    }

    protected void log(String message) {
        new Util().log(message);
    }

    protected void log(String format, Object ... args) {
        new Util().log(String.format(format, args));
    }

    protected void log(String message, Exception ex) {
        new Util().log(message, ex);
    }

    protected void toastLong(String message) {
        Toast.makeText((Context)this, (CharSequence)message, (int)1).show();
    }

    protected void toastLong(int message) {
        Toast.makeText((Context)this, (CharSequence)this.getText(message), (int)1).show();
    }

    protected void toastLong(String format, Object ... args) {
        Toast.makeText((Context)this, (CharSequence)String.format(format, args), (int)1).show();
    }

    protected void toastLong(CharSequence message) {
        Toast.makeText((Context)this, (CharSequence)message.toString(), (int)1).show();
    }

    protected void toastShort(String message) {
        Toast.makeText((Context)this, (CharSequence)message, (int)0).show();
    }

    protected void toastShort(String format, Object ... args) {
        Toast.makeText((Context)this, (CharSequence)String.format(format, args), (int)0).show();
    }

    protected void toastShort(int message) {
        Toast.makeText((Context)this, (CharSequence)this.getText(message), (int)0).show();
    }

    protected void toastShort(CharSequence message) {
        Toast.makeText((Context)this, (CharSequence)message.toString(), (int)0).show();
    }

    protected <T> T createInstance(Class<?> type, Class<?> constructor, Object ... params) {
        try {
            return (T)type.getConstructor(constructor).newInstance(params);
        }
        catch (InstantiationException e) {
            this.log("InstantiationException", e);
        }
        catch (IllegalAccessException e) {
            this.log("IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            this.log("InvocationTargetException", e);
        }
        catch (NoSuchMethodException e) {
            this.log("NoSuchMethodException", e);
        }
        return null;
    }
}

