/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.activities;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.KeyEvent;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.activities.BaseActivity;
import com.ushahidi.android.app.models.Model;
import com.ushahidi.android.app.tasks.ProgressTask;
import com.ushahidi.android.app.views.View;

public abstract class BaseEditActivity<V extends View, M extends Model>
extends BaseActivity<V> {
    public BaseEditActivity(Class<V> view, int layout2, int menu2) {
        super(view, layout2, menu2);
    }

    @Override
    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getRepeatCount() == 0) {
            this.log("onBackPressed");
            this.showDialogs();
            return false;
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void showDialogs() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle(this.getText(R.string.unsaved_changes)).setMessage(this.getText(R.string.would_you_like_to_save_your_changes_)).setCancelable(false).setPositiveButton(this.getText(R.string.save), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                new SaveTask(BaseEditActivity.this).execute(new String[]{null});
            }
        }).setNeutralButton(this.getText(R.string.discard), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                new DiscardTask(BaseEditActivity.this).execute(new String[]{null});
                BaseEditActivity.this.finish();
            }
        }).setNegativeButton(this.getText(R.string.cancel), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                dialog.cancel();
            }
        }).create().show();
    }

    protected abstract boolean onSaveChanges();

    protected abstract boolean onDiscardChanges();

    protected class DiscardTask
    extends ProgressTask {
        public DiscardTask(Activity activity) {
            super(activity, R.string.discard);
        }

        protected Boolean doInBackground(String ... args) {
            return BaseEditActivity.this.onDiscardChanges();
        }

        @Override
        protected void onPostExecute(Boolean success) {
            super.onPostExecute(success);
            if (success.booleanValue()) {
                this.activity.finish();
            }
        }
    }

    protected class SaveTask
    extends ProgressTask {
        public SaveTask(Activity activity) {
            super(activity, R.string.saving_);
        }

        protected Boolean doInBackground(String ... args) {
            return BaseEditActivity.this.onSaveChanges();
        }

        @Override
        protected void onPostExecute(Boolean success) {
            super.onPostExecute(success);
            if (success.booleanValue()) {
                BaseEditActivity.this.toastLong(R.string.saved);
                this.activity.finish();
            } else {
                BaseEditActivity.this.toastLong(R.string.not_saved);
            }
        }
    }
}

