/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.activities;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.KeyEvent;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.activities.BaseMapActivity;
import com.ushahidi.android.app.models.Model;
import com.ushahidi.android.app.tasks.ProgressTask;
import com.ushahidi.android.app.views.View;

public abstract class BaseEditMapActivity<V extends View, M extends Model>
extends BaseMapActivity<V> {
    public BaseEditMapActivity(Class<V> view, int layout2, int menu2, int mapView) {
        super(view, layout2, menu2, mapView);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    protected void showDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle(this.getText(R.string.unsaved_changes)).setMessage(this.getText(R.string.would_you_like_to_save_your_changes_)).setCancelable(false).setPositiveButton(this.getText(R.string.save), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                new SaveTask((Activity)BaseEditMapActivity.this).execute(new String[]{null});
            }
        }).setNeutralButton(this.getText(R.string.discard), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                new DiscardTask((Activity)BaseEditMapActivity.this).execute(new String[]{null});
                BaseEditMapActivity.this.finish();
            }
        }).setNegativeButton(this.getText(R.string.cancel), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                dialog.cancel();
            }
        }).create().show();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getRepeatCount() == 0) {
            this.log("onBackPressed");
            this.showDialog();
            return false;
        }
        return super.onKeyDown(keyCode, event);
    }

    protected abstract boolean onSaveChanges();

    protected abstract boolean onDiscardChanges();

    protected class DiscardTask
    extends ProgressTask {
        public DiscardTask(Activity activity) {
            super(activity, R.string.discard);
        }

        protected Boolean doInBackground(String ... args) {
            return BaseEditMapActivity.this.onDiscardChanges();
        }

        @Override
        protected void onPostExecute(Boolean success) {
            super.onPostExecute(success);
            if (success.booleanValue()) {
                this.activity.finish();
            }
        }
    }

    protected class SaveTask
    extends ProgressTask {
        public SaveTask(Activity activity) {
            super(activity, R.string.saving_);
        }

        protected Boolean doInBackground(String ... args) {
            return BaseEditMapActivity.this.onSaveChanges();
        }

        @Override
        protected void onPostExecute(Boolean success) {
            super.onPostExecute(success);
            if (success.booleanValue()) {
                BaseEditMapActivity.this.toastLong(R.string.saved);
                this.activity.finish();
            } else {
                BaseEditMapActivity.this.toastLong(R.string.not_saved);
            }
        }
    }
}

