/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.activities;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.activities.BaseActivity;
import com.ushahidi.android.app.adapters.BaseListAdapter;
import com.ushahidi.android.app.models.Model;
import com.ushahidi.android.app.tasks.ProgressTask;
import com.ushahidi.android.app.util.Objects;

public abstract class BaseListActivity<V extends com.ushahidi.android.app.views.View, M extends Model, L extends BaseListAdapter<M>>
extends BaseActivity<V>
implements AdapterView.OnItemClickListener,
AdapterView.OnItemSelectedListener {
    private final int listViewId;
    private final Class<L> adapterClass;
    protected L adapter;
    protected ListView listView;

    protected BaseListActivity(Class<V> view, Class<L> adapter, int layout2, int menu2, int listView) {
        super(view, layout2, menu2);
        this.adapterClass = adapter;
        this.listViewId = listView;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.listViewId != 0) {
            this.listView = this.findListViewById(this.listViewId);
            if (this.headerView() != null) {
                this.listView.addHeaderView(this.headerView());
            }
            this.listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
            View emptyView = this.findViewById(16908292);
            if (emptyView != null) {
                this.listView.setEmptyView(emptyView);
            }
            this.adapter = (BaseListAdapter)((Object)Objects.createInstance(this.adapterClass, Context.class, this));
            this.listView.setAdapter(this.adapter);
            this.listView.setFocusable(true);
        }
    }

    protected abstract void onLoaded(boolean var1);

    protected abstract View headerView();

    @Override
    protected void onResume() {
        super.onResume();
    }

    protected M getItem(int position) {
        return (M)((Model)this.listView.getItemAtPosition(position));
    }

    protected M getSelectedItem() {
        return (M)((Model)this.listView.getSelectedItem());
    }

    public void onItemSelected(AdapterView<?> adapterView, View view, int position, long id2) {
    }

    public void onNothingSelected(AdapterView<?> adapterView) {
    }

    protected class LoadingTask
    extends ProgressTask {
        public LoadingTask(FragmentActivity activity) {
            super(activity, R.string.loading_);
        }

        protected Boolean doInBackground(String ... args) {
            ((BaseListAdapter)((Object)BaseListActivity.this.adapter)).refresh();
            return true;
        }

        @Override
        protected void onPostExecute(Boolean success) {
            super.onPostExecute(success);
            BaseListActivity.this.onLoaded(success);
        }
    }
}

