/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.location.LocationListener;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.view.Menu;
import android.widget.Toast;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapView;
import com.ushahidi.android.app.MapMarker;
import com.ushahidi.android.app.MapUserLocation;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.util.Objects;
import com.ushahidi.android.app.util.Util;
import com.ushahidi.android.app.views.View;

public abstract class BaseMapActivity<V extends View>
extends MapUserLocation
implements LocationListener {
    protected final int layout;
    protected final int menu;
    protected final int mapViewId;
    protected final Class<V> viewClass;
    protected V view;
    protected MapView mapView;
    protected LocationManager locationManager;

    protected BaseMapActivity(Class<V> view, int layout2, int menu2, int mapView) {
        this.viewClass = view;
        this.layout = layout2;
        this.menu = menu2;
        this.mapViewId = mapView;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.layout != 0) {
            this.setContentView(this.layout);
        }
        if (this.mapViewId != 0) {
            ((MapUserLocation)this).mapView = this.mapView = (MapView)this.findViewById(this.mapViewId);
        }
        if (this.locationManager == null) {
            this.locationManager = (LocationManager)this.getSystemService("location");
        }
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.view = (View)Objects.createInstance(this.viewClass, Activity.class, new Object[]{this});
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        if (this.menu != 0) {
            this.getMenuInflater().inflate(this.menu, (android.view.Menu)menu2);
            return true;
        }
        return false;
    }

    protected void shareText(String shareItem) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.TEXT", shareItem);
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)this.getText(R.string.title_share)));
    }

    protected void sharePhoto(String path) {
        Preferences.loadSettings((Context)this);
        String reportUrl = Preferences.domain;
        String shareString = this.getString(R.string.share_template, new Object[]{"", reportUrl});
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("image/jpg");
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.parse((String)("file://" + path)));
        intent.putExtra("android.intent.extra.TEXT", shareString);
        this.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)this.getText(R.string.title_share)), 0);
        this.setResult(-1);
    }

    protected void setActionBarTitle(String title) {
        this.getSupportActionBar().setTitle(title);
    }

    protected void placeMarker(int markerLatitude, int markerLongitude) {
        Drawable marker = this.getResources().getDrawable(R.drawable.map_marker_red);
        marker.setBounds(0, 0, marker.getIntrinsicWidth(), marker.getIntrinsicHeight());
        this.mapView.getController().setZoom(14);
        this.mapView.setBuiltInZoomControls(true);
        this.mapView.getOverlays().add(new MapMarker(marker, markerLatitude, markerLongitude));
    }

    protected void centerLocationWithMarker(GeoPoint centerGeoPoint) {
        this.mapView.getController().animateTo(centerGeoPoint);
        this.placeMarker(centerGeoPoint.getLatitudeE6(), centerGeoPoint.getLongitudeE6());
    }

    protected void centerAtLocation(double latitude, double longitude) {
        this.mapView.getController().setCenter(this.getPoint(latitude, longitude));
    }

    protected void centerAtLocation(double latitude, double longitude, int zoom) {
        this.mapView.getController().setCenter(this.getPoint(latitude, longitude));
        this.mapView.getController().setZoom(zoom);
    }

    @Override
    protected GeoPoint getPoint(double latitude, double longitude) {
        return new GeoPoint((int)(latitude * 1000000.0), (int)(longitude * 1000000.0));
    }

    protected void log(String message) {
        new Util().log(message);
    }

    protected void log(String format, Object ... args) {
        new Util().log(String.format(format, args));
    }

    protected void log(String message, Exception ex) {
        new Util().log(message, ex);
    }

    protected void toastLong(String message) {
        Toast.makeText((Context)this, (CharSequence)message, (int)1).show();
    }

    protected void toastLong(int message) {
        Toast.makeText((Context)this, (CharSequence)this.getText(message), (int)1).show();
    }

    protected void toastLong(CharSequence message) {
        Toast.makeText((Context)this, (CharSequence)message.toString(), (int)1).show();
    }

    protected void toastShort(String message) {
        Toast.makeText((Context)this, (CharSequence)message, (int)0).show();
    }

    protected void toastShort(int message) {
        Toast.makeText((Context)this, (CharSequence)this.getText(message), (int)0).show();
    }

    protected void toastShort(CharSequence message) {
        Toast.makeText((Context)this, (CharSequence)message.toString(), (int)0).show();
    }
}

