/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.activities;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.services.FetchReports;
import com.ushahidi.android.app.services.SyncServices;
import com.ushahidi.android.app.ui.phone.CheckinTabActivity;
import com.ushahidi.android.app.ui.phone.ListMapActivity;
import com.ushahidi.android.app.ui.phone.ReportTabActivity;
import com.ushahidi.android.app.ui.tablet.DashboardActivity;
import com.ushahidi.android.app.util.ApiUtils;
import com.ushahidi.android.app.util.Util;

public class SplashScreenActivity
extends FragmentActivity {
    private boolean active = true;
    private int splashTime = 5000;
    private BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent != null) {
                try {
                    SplashScreenActivity.this.unregisterReceiver(SplashScreenActivity.this.broadcastReceiver);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (Preferences.isCheckinEnabled == 1) {
                    SplashScreenActivity.this.goToCheckins();
                } else {
                    SplashScreenActivity.this.goToReports();
                }
            }
        }
    };

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRequestedOrientation(1);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.splash);
        Thread splashTread = new Thread(){

            @Override
            public void run() {
                try {
                    int waited = 0;
                    while (SplashScreenActivity.this.active && waited < SplashScreenActivity.this.splashTime) {
                        1.sleep(100L);
                        if (!SplashScreenActivity.this.active) continue;
                        waited += 100;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    if (!SplashScreenActivity.this.checkDefaultDeployment()) {
                        if (Util.isTablet((Context)SplashScreenActivity.this)) {
                            SplashScreenActivity.this.startActivity(new Intent((Context)SplashScreenActivity.this, DashboardActivity.class));
                            SplashScreenActivity.this.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
                            SplashScreenActivity.this.finish();
                        } else {
                            SplashScreenActivity.this.startActivity(new Intent((Context)SplashScreenActivity.this, ListMapActivity.class));
                            SplashScreenActivity.this.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
                            SplashScreenActivity.this.finish();
                        }
                    }
                }
            }
        };
        splashTread.start();
    }

    @Override
    public void onResume() {
        super.onResume();
        this.registerReceiver(this.broadcastReceiver, new IntentFilter(SyncServices.SYNC_SERVICES_ACTION));
    }

    @Override
    protected void onPause() {
        super.onPause();
        try {
            this.unregisterReceiver(this.broadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.active = false;
        }
        return true;
    }

    private boolean checkDefaultDeployment() {
        try {
            String deployment = this.getString(R.string.deployment_url);
            if (!TextUtils.isEmpty((CharSequence)deployment)) {
                Log.i((String)"Dashboard", (String)("Determing if default deployment has been set " + deployment));
                if (ApiUtils.validateUshahidiInstance(deployment)) {
                    Log.i((String)"Dashboard", (String)("Validate Domain " + deployment));
                    Preferences.domain = deployment;
                    Preferences.saveSettings((Context)this);
                    if (Preferences.appRunsFirstTime == 0) {
                        Preferences.appRunsFirstTime = 1;
                        Preferences.saveSettings((Context)this);
                        this.startService(new Intent((Context)this, FetchReports.class));
                        return true;
                    }
                }
                if (Preferences.isCheckinEnabled == 1) {
                    this.goToCheckins();
                } else {
                    this.goToReports();
                }
                return true;
            }
        }
        catch (Exception ex) {
            Log.e((String)"Dashboard", (String)"checkDefaultDeployment Exception", (Throwable)ex);
        }
        return false;
    }

    private void goToReports() {
        Intent launchIntent = new Intent((Context)this, ReportTabActivity.class);
        this.startActivityForResult(launchIntent, 0);
        this.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
        this.setResult(-1);
        this.finish();
    }

    private void goToCheckins() {
        Intent launchIntent = new Intent((Context)this, CheckinTabActivity.class);
        this.startActivityForResult(launchIntent, 0);
        this.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
        this.setResult(-1);
        this.finish();
    }
}

