/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.widget.ArrayAdapter;
import com.ushahidi.android.app.models.Model;
import com.ushahidi.android.app.util.Util;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseArrayAdapter<M extends Model>
extends ArrayAdapter<String> {
    protected final LayoutInflater inflater;
    protected final List<M> tags;
    protected int notSpecified = -1;
    protected static final int NOT_SPECIFIED = -1;
    protected Context context;

    public BaseArrayAdapter(Context context) {
        this(context, -1);
        this.context = context;
    }

    public BaseArrayAdapter(Context context, Integer notSpecified) {
        super(context, notSpecified.intValue());
        this.setDropDownViewResource(0x1090009);
        this.notSpecified = notSpecified;
        this.context = context;
        this.inflater = LayoutInflater.from((Context)context);
        this.tags = new ArrayList<M>();
    }

    public int getPosition(M m) {
        return this.getPosition(m.toString());
    }

    public void clear() {
        super.clear();
        this.tags.clear();
    }

    public void add(String label) {
        super.add((Object)label);
        this.tags.add(null);
    }

    public void add(String label, M m) {
        super.add((Object)label);
        this.tags.add(m);
    }

    public void insert(String object, int index) {
        super.insert((Object)object, index);
    }

    public M getTag(int position) {
        return (M)((Model)this.tags.get(position));
    }

    public abstract void refresh();

    protected void log(String message) {
        new Util().log(message);
    }

    protected void log(String format, Object ... args) {
        new Util().log(String.format(format, args));
    }

    protected void log(String message, Exception ex) {
        new Util().log(message, ex);
    }
}

