/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.widget.BaseAdapter;
import com.ushahidi.android.app.models.Model;
import com.ushahidi.android.app.util.Util;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseListAdapter<M extends Model>
extends BaseAdapter {
    protected final Context context;
    protected final LayoutInflater inflater;
    protected final List<M> items = new ArrayList<M>();

    public BaseListAdapter(Context context) {
        this.context = context;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public int getCount() {
        return this.items.size();
    }

    public void setItems(List<M> items) {
        this.items.clear();
        this.items.addAll(items);
        this.notifyDataSetChanged();
    }

    public void addItem(M item) {
        this.items.add(item);
        this.notifyDataSetChanged();
    }

    public M getItem(int position) {
        return (M)((Model)this.items.get(position));
    }

    public long getItemId(int position) {
        return position;
    }

    public int indexOf(M item) {
        return this.items.indexOf(item);
    }

    public void clearItems() {
        this.items.clear();
        this.notifyDataSetChanged();
    }

    public void removeItem(int position) {
        this.items.remove(position);
        this.notifyDataSetChanged();
    }

    public void removeItem(M item) {
        this.items.remove(item);
        this.notifyDataSetChanged();
    }

    public abstract void refresh();

    protected void log(String message) {
        new Util().log(message);
    }

    protected void log(String format, Object ... args) {
        new Util().log(String.format(format, args));
    }

    protected void log(String message, Exception ex) {
        new Util().log(message, ex);
    }
}

