/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.adapters;

import android.content.Context;
import android.database.DataSetObserver;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.SectionIndexer;
import com.commonsware.cwac.sacklist.SackOfViewsAdapter;
import com.ushahidi.android.app.models.Model;
import com.ushahidi.android.app.util.Util;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseSectionListAdapter<M extends Model>
extends BaseAdapter
implements SectionIndexer {
    protected ArrayList<ListAdapter> pieces = new ArrayList();
    protected final Context context;
    protected final LayoutInflater inflater;

    public BaseSectionListAdapter(Context context) {
        this.context = context;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public void addAdapter(ListAdapter adapter) {
        this.pieces.add(adapter);
        adapter.registerDataSetObserver((DataSetObserver)new CascadeDataSetObserver());
    }

    public void addView(View view) {
        this.addView(view, false);
    }

    public void addView(View view, boolean enabled) {
        ArrayList<View> list = new ArrayList<View>(1);
        list.add(view);
        this.addViews(list, enabled);
    }

    public void addViews(List<View> views) {
        this.addViews(views, false);
    }

    public void addViews(List<View> views, boolean enabled) {
        if (enabled) {
            this.addAdapter((ListAdapter)new EnabledSackAdapter(views));
        } else {
            this.addAdapter((ListAdapter)new SackOfViewsAdapter(views));
        }
    }

    public Object getItem(int position) {
        for (ListAdapter piece : this.pieces) {
            int size = piece.getCount();
            if (position < size) {
                return piece.getItem(position);
            }
            position -= size;
        }
        return null;
    }

    public void removeItem(int position) {
        this.pieces.remove(position);
        this.notifyDataSetChanged();
    }

    public ListAdapter getAdapter(int position) {
        for (ListAdapter piece : this.pieces) {
            int size = piece.getCount();
            if (position < size) {
                return piece;
            }
            position -= size;
        }
        return null;
    }

    public int getCount() {
        int total = 0;
        for (ListAdapter piece : this.pieces) {
            total += piece.getCount();
        }
        return total;
    }

    public int getViewTypeCount() {
        int total = 0;
        for (ListAdapter piece : this.pieces) {
            total += piece.getViewTypeCount();
        }
        return Math.max(total, 1);
    }

    public int getItemViewType(int position) {
        int typeOffset = 0;
        int result = -1;
        for (ListAdapter piece : this.pieces) {
            int size = piece.getCount();
            if (position < size) {
                result = typeOffset + piece.getItemViewType(position);
                break;
            }
            position -= size;
            typeOffset += piece.getViewTypeCount();
        }
        return result;
    }

    public boolean areAllItemsEnabled() {
        return false;
    }

    public boolean isEnabled(int position) {
        for (ListAdapter piece : this.pieces) {
            int size = piece.getCount();
            if (position < size) {
                return piece.isEnabled(position);
            }
            position -= size;
        }
        return false;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        for (ListAdapter piece : this.pieces) {
            int size = piece.getCount();
            if (position < size) {
                return piece.getView(position, convertView, parent);
            }
            position -= size;
        }
        return null;
    }

    public long getItemId(int position) {
        for (ListAdapter piece : this.pieces) {
            int size = piece.getCount();
            if (position < size) {
                return piece.getItemId(position);
            }
            position -= size;
        }
        return -1L;
    }

    public int getPositionForSection(int section) {
        int position = 0;
        for (ListAdapter piece : this.pieces) {
            if (piece instanceof SectionIndexer) {
                Object[] sections = ((SectionIndexer)piece).getSections();
                int numSections = 0;
                if (sections != null) {
                    numSections = sections.length;
                }
                if (section < numSections) {
                    return position + ((SectionIndexer)piece).getPositionForSection(section);
                }
                if (sections != null) {
                    section -= numSections;
                }
            }
            position += piece.getCount();
        }
        return 0;
    }

    public int getSectionForPosition(int position) {
        int section = 0;
        for (ListAdapter piece : this.pieces) {
            Object[] sections;
            int size = piece.getCount();
            if (position < size) {
                if (piece instanceof SectionIndexer) {
                    return section + ((SectionIndexer)piece).getSectionForPosition(position);
                }
                return 0;
            }
            if (piece instanceof SectionIndexer && (sections = ((SectionIndexer)piece).getSections()) != null) {
                section += sections.length;
            }
            position -= size;
        }
        return 0;
    }

    public Object[] getSections() {
        ArrayList<Object> sections = new ArrayList<Object>();
        for (ListAdapter piece : this.pieces) {
            Object[] curSections;
            if (!(piece instanceof SectionIndexer) || (curSections = ((SectionIndexer)piece).getSections()) == null) continue;
            for (Object section : curSections) {
                sections.add(section);
            }
        }
        if (sections.size() == 0) {
            return new String[0];
        }
        return sections.toArray(new Object[0]);
    }

    public abstract void refresh();

    protected void log(String message) {
        new Util().log(message);
    }

    protected void log(String format, Object ... args) {
        new Util().log(String.format(format, args));
    }

    protected void log(String message, Exception ex) {
        new Util().log(message, ex);
    }

    private class CascadeDataSetObserver
    extends DataSetObserver {
        private CascadeDataSetObserver() {
        }

        public void onChanged() {
            BaseSectionListAdapter.this.notifyDataSetChanged();
        }

        public void onInvalidated() {
            BaseSectionListAdapter.this.notifyDataSetInvalidated();
        }
    }

    private static class EnabledSackAdapter
    extends SackOfViewsAdapter {
        public EnabledSackAdapter(List<View> views) {
            super(views);
        }

        public boolean areAllItemsEnabled() {
            return true;
        }

        public boolean isEnabled(int position) {
            return true;
        }
    }
}

