/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.adapters;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.adapters.BaseArrayAdapter;
import com.ushahidi.android.app.entities.Category;
import com.ushahidi.android.app.models.ListReportModel;
import java.util.List;

public class CategorySpinnerAdater
extends BaseArrayAdapter<Category> {
    private static final String DEFAULT_COLOR = "#000000";

    public CategorySpinnerAdater(Context context) {
        super(context);
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return this.getCustomView(position, convertView, parent);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.getCustomView(position, convertView, parent);
    }

    public View getCustomView(int position, View convertView, ViewGroup parent) {
        Widgets widget;
        if (convertView == null) {
            convertView = this.inflater.inflate(R.layout.category_spinner_row_item, null);
            widget = new Widgets();
            widget.title = (TextView)convertView.findViewById(R.id.category_title);
            widget.color = (TextView)convertView.findViewById(R.id.cat_color);
            widget.root = (LinearLayout)convertView.findViewById(R.id.root_layout);
            convertView.setTag((Object)widget);
        } else {
            widget = (Widgets)convertView.getTag();
        }
        if (((Category)this.getTag(position)).getCategoryTitle() != null) {
            widget.title.setText((CharSequence)((Category)this.getTag(position)).getCategoryTitle());
        }
        if (((Category)this.getTag(position)).getCategoryColor() != null) {
            if (TextUtils.isEmpty((CharSequence)((Category)this.getTag(position)).getCategoryColor().trim())) {
                try {
                    widget.color.setBackgroundColor(Color.parseColor((String)DEFAULT_COLOR));
                }
                catch (IllegalArgumentException exception) {
                    this.log("Error parsing color hex", exception);
                }
            } else {
                try {
                    widget.color.setBackgroundColor(Color.parseColor((String)((Category)this.getTag(position)).getCategoryColor().trim()));
                }
                catch (IllegalArgumentException exception) {
                    this.log("Error parsing color", exception);
                }
            }
        }
        return convertView;
    }

    @Override
    public void refresh() {
        ListReportModel mListReportModel = new ListReportModel();
        List<Category> listCategories = mListReportModel.getParentCategories();
        if (listCategories != null && listCategories.size() > 0) {
            Category cat = new Category();
            cat.setCategoryTitle(this.context.getString(R.string.all_categories));
            cat.setCategoryPosition(0);
            cat.setDbId(0);
            cat.setCategoryId(0);
            cat.setParentId(0);
            cat.setCategoryColor("000000");
            this.add(cat.getCategoryTitle(), cat);
            for (Category category : listCategories) {
                this.add(category.getCategoryTitle(), category);
                List<Category> listChildrenCategories = mListReportModel.getChildrenCategories(category.getCategoryId());
                if (listChildrenCategories == null || listChildrenCategories.size() <= 0) continue;
                for (Category childrenCategories : listChildrenCategories) {
                    this.add(childrenCategories.getCategoryTitle(), childrenCategories);
                }
            }
        }
    }

    class Widgets {
        TextView title;
        TextView color;
        LinearLayout root;

        Widgets() {
        }
    }
}

