/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.adapters;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.adapters.BaseListAdapter;
import com.ushahidi.android.app.models.ListCommentModel;
import com.ushahidi.android.app.util.Util;
import java.util.List;

public class CommentAdapter
extends BaseListAdapter<ListCommentModel> {
    private ListCommentModel mListCommentModel;
    private List<ListCommentModel> items;
    private int[] colors = new int[]{R.drawable.odd_row_rounded_corners, R.drawable.even_row_rounded_corners};

    public CommentAdapter(Context context) {
        super(context);
    }

    public View getView(int position, View view, ViewGroup viewGroup) {
        int colorPosition = position % this.colors.length;
        View row = this.inflater.inflate(R.layout.comment_item, viewGroup, false);
        row.setBackgroundResource(this.colors[colorPosition]);
        Widgets widgets = (Widgets)row.getTag();
        if (widgets == null) {
            widgets = new Widgets(row);
            row.setTag((Object)widgets);
        }
        widgets.commentAuthor.setText((CharSequence)((ListCommentModel)this.getItem(position)).getCommentAuthor());
        widgets.commentDate.setText((CharSequence)Util.formatDate("yyyy-MM-dd HH:mm:ss", ((ListCommentModel)this.getItem(position)).getCommentDate(), "MMM dd, yyyy"));
        widgets.commentDescription.setText((CharSequence)((ListCommentModel)this.getItem(position)).getCommentDescription());
        return row;
    }

    @Override
    public void refresh() {
    }

    public void refresh(int reportId) {
        this.mListCommentModel = new ListCommentModel();
        boolean loaded = this.mListCommentModel.load(reportId);
        if (loaded) {
            this.items = this.mListCommentModel.getCommentsByReportId(reportId);
            this.setItems(this.items);
        }
    }

    public void refreshCheckinComment(int checkinId) {
        this.mListCommentModel = new ListCommentModel();
        boolean loaded = this.mListCommentModel.loadCheckinComment(checkinId);
        if (loaded) {
            this.items = this.mListCommentModel.getCommentsByCheckinId(checkinId);
            this.setItems(this.items);
        }
    }

    class Widgets
    extends com.ushahidi.android.app.views.View {
        TextView commentAuthor;
        TextView commentDate;
        TextView commentDescription;

        public Widgets(View view) {
            super(view);
            this.commentAuthor = (TextView)view.findViewById(R.id.comment_author);
            this.commentDate = (TextView)view.findViewById(R.id.comment_date);
            this.commentDescription = (TextView)view.findViewById(R.id.comment_description);
        }
    }
}

