/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.adapters;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.adapters.BaseListAdapter;
import com.ushahidi.android.app.models.ListCommentModel;
import com.ushahidi.android.app.util.Util;
import java.util.List;

public class ListCommentAdapter
extends BaseListAdapter<ListCommentModel> {
    private ListCommentModel mListCommentModel;
    private List<ListCommentModel> items;
    private int totalComments;

    public ListCommentAdapter(Context context) {
        super(context);
    }

    public View getView(int position, View view, ViewGroup viewGroup) {
        View row = this.inflater.inflate(R.layout.list_comment_item, viewGroup, false);
        Widgets widgets = (Widgets)row.getTag();
        if (widgets == null) {
            widgets = new Widgets(row);
            row.setTag((Object)widgets);
        }
        widgets.commentAuthor.setText((CharSequence)((ListCommentModel)this.getItem(position)).getCommentAuthor());
        widgets.commentDate.setText((CharSequence)Util.formatDate("yyyy-MM-dd HH:mm:ss", ((ListCommentModel)this.getItem(position)).getCommentDate(), "MMM dd, yyyy"));
        widgets.commentDescription.setText((CharSequence)((ListCommentModel)this.getItem(position)).getCommentDescription());
        widgets.total.setText((CharSequence)this.context.getResources().getQuantityString(R.plurals.no_of_comments, this.totalComments, new Object[]{this.totalComments}));
        return row;
    }

    @Override
    public void refresh() {
    }

    public void refresh(int reportId) {
        this.mListCommentModel = new ListCommentModel();
        boolean loaded = this.mListCommentModel.load(reportId);
        this.totalComments = this.mListCommentModel.totalComments();
        if (loaded) {
            this.items = this.mListCommentModel.getComments();
            this.setItems(this.items);
        }
    }

    public void refreshCheckinComment(int checkinId) {
        this.mListCommentModel = new ListCommentModel();
        boolean loaded = this.mListCommentModel.loadCheckinComment(checkinId);
        this.totalComments = this.mListCommentModel.totalComments();
        if (loaded) {
            this.items = this.mListCommentModel.getComments();
            this.setItems(this.items);
        }
    }

    class Widgets
    extends com.ushahidi.android.app.views.View {
        TextView commentAuthor;
        TextView commentDate;
        TextView commentDescription;
        TextView total;

        public Widgets(View view) {
            super(view);
            this.commentAuthor = (TextView)view.findViewById(R.id.comment_author);
            this.commentDate = (TextView)view.findViewById(R.id.comment_date);
            this.commentDescription = (TextView)view.findViewById(R.id.comment_description);
            this.total = (TextView)view.findViewById(R.id.comment_total);
        }
    }
}

