/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.adapters;

import android.content.Context;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.TextView;
import com.ushahidi.android.app.ImageManager;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.adapters.BaseListAdapter;
import com.ushahidi.android.app.entities.Checkin;
import com.ushahidi.android.app.models.ListCheckinModel;
import com.ushahidi.android.app.util.ImageViewWorker;
import com.ushahidi.android.app.views.View;
import java.util.ArrayList;
import java.util.List;

public class ListFetchedCheckinAdapter
extends BaseListAdapter<ListCheckinModel>
implements Filterable {
    private int[] colors = new int[]{R.drawable.odd_row_rounded_corners, R.drawable.even_row_rounded_corners};
    private ListCheckinModel mListCheckinModel = new ListCheckinModel();
    private List<ListCheckinModel> items;

    public ListFetchedCheckinAdapter(Context context) {
        super(context);
    }

    @Override
    public void refresh() {
        boolean loaded = this.mListCheckinModel.load();
        if (loaded) {
            this.items = this.mListCheckinModel.getCheckins(this.context);
            this.setItems(this.items);
        }
    }

    public void refresh(int userId) {
        boolean loaded = this.mListCheckinModel.loadCheckinByUser(userId);
        if (loaded) {
            this.items = this.mListCheckinModel.getCheckins(this.context);
            this.setItems(this.items);
        }
    }

    public List<ListCheckinModel> fetchedCheckins() {
        boolean loaded = this.mListCheckinModel.load();
        if (loaded) {
            return this.mListCheckinModel.getCheckins(this.context);
        }
        return null;
    }

    public android.view.View getView(int position, android.view.View view, ViewGroup viewGroup) {
        int colorPosition = position % this.colors.length;
        android.view.View row = this.inflater.inflate(R.layout.list_checkin_item, viewGroup, false);
        row.setBackgroundResource(this.colors[colorPosition]);
        Widgets widgets = (Widgets)row.getTag();
        if (widgets == null) {
            widgets = new Widgets(row);
            row.setTag((Object)widgets);
        }
        if (((ListCheckinModel)this.getItem(position)).getThumbnail() == null) {
            widgets.thumbnail.setImageResource(R.drawable.report_icon);
        } else {
            this.getPhoto(((ListCheckinModel)this.getItem(position)).getThumbnail(), widgets.thumbnail);
        }
        widgets.title.setText((CharSequence)this.items.get(position).getUsername());
        widgets.date.setText((CharSequence)this.items.get(position).getDate());
        widgets.checkinMessage.setText((CharSequence)this.items.get(position).getMessage());
        widgets.arrow.setImageDrawable(this.context.getResources().getDrawable(R.drawable.arrow));
        return row;
    }

    public void getPhoto(String fileName, ImageView imageView) {
        ImageViewWorker imageWorker = new ImageViewWorker(this.context);
        imageWorker.setImageFadeIn(true);
        imageWorker.setLoadingImage(ImageManager.drawableToBitmap(this.context.getResources().getDrawable(R.drawable.report_icon)));
        imageWorker.loadImage(fileName, imageView, true, 0);
    }

    public Filter getFilter() {
        return new ReportFilter();
    }

    public class ReportFilter
    extends Filter {
        protected Filter.FilterResults performFiltering(CharSequence constraint) {
            Filter.FilterResults results = new Filter.FilterResults();
            results.values = ListFetchedCheckinAdapter.this.items;
            results.count = ListFetchedCheckinAdapter.this.items.size();
            if (constraint != null && constraint.toString().length() > 0) {
                constraint = constraint.toString().toLowerCase();
                ArrayList<Checkin> filteredItems = new ArrayList<Checkin>();
                ArrayList itemsHolder = new ArrayList();
                itemsHolder.addAll(ListFetchedCheckinAdapter.this.items);
                for (Checkin checkin : itemsHolder) {
                    if (!checkin.getMessage().toLowerCase().contains(constraint)) continue;
                    filteredItems.add(checkin);
                }
                results.count = filteredItems.size();
                results.values = filteredItems;
            }
            return results;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            ArrayList checkins = (ArrayList)results.values;
            ListFetchedCheckinAdapter.this.setItems(checkins);
        }
    }

    class Widgets
    extends View {
        TextView title;
        TextView checkinMessage;
        TextView date;
        ImageView thumbnail;
        ImageView arrow;

        public Widgets(android.view.View view) {
            super(view);
            this.thumbnail = (ImageView)view.findViewById(R.id.checkin_thumbnail);
            this.checkinMessage = (TextView)view.findViewById(R.id.checkin_message);
            this.title = (TextView)view.findViewById(R.id.checkin_title);
            this.date = (TextView)view.findViewById(R.id.checkin_date);
            this.arrow = (ImageView)view.findViewById(R.id.checkin_arrow);
        }
    }
}

