/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.adapters;

import android.content.Context;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.TextView;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.adapters.BaseListAdapter;
import com.ushahidi.android.app.entities.Category;
import com.ushahidi.android.app.models.ListReportModel;
import com.ushahidi.android.app.util.ImageViewWorker;
import com.ushahidi.android.app.util.Util;
import com.ushahidi.android.app.views.View;
import java.util.ArrayList;
import java.util.List;

public class ListFetchedReportAdapter
extends BaseListAdapter<ListReportModel>
implements Filterable {
    private int[] colors = new int[]{R.drawable.odd_row_rounded_corners, R.drawable.even_row_rounded_corners};
    private ListReportModel mListReportModel = new ListReportModel();
    private List<ListReportModel> items;

    public ListFetchedReportAdapter(Context context) {
        super(context);
    }

    @Override
    public void refresh() {
        boolean loaded = this.mListReportModel.load();
        if (loaded) {
            this.items = this.mListReportModel.getReports(this.context);
            this.setItems(this.items);
        }
    }

    public List<ListReportModel> fetchedReports() {
        boolean loaded = this.mListReportModel.load();
        if (loaded) {
            return this.mListReportModel.getReports(this.context);
        }
        return null;
    }

    public void refresh(int categoryId) {
        boolean loaded = this.mListReportModel.loadReportByCategory(categoryId);
        if (loaded) {
            this.items = this.mListReportModel.getReports(this.context);
            this.setItems(this.items);
        }
    }

    public String fetchCategories(int reportId) {
        StringBuilder categories = new StringBuilder();
        for (Category category : this.mListReportModel.getCategoriesByReportId(reportId)) {
            if (category.getCategoryTitle().length() <= 0) continue;
            categories.append(category.getCategoryTitle() + " |");
        }
        if (categories.length() > 0) {
            categories.deleteCharAt(categories.length() - 1);
        }
        return categories.toString();
    }

    public android.view.View getView(int position, android.view.View view, ViewGroup viewGroup) {
        int colorPosition = position % this.colors.length;
        android.view.View row = this.inflater.inflate(R.layout.list_report_item, viewGroup, false);
        row.setBackgroundResource(this.colors[colorPosition]);
        Widgets widgets = (Widgets)row.getTag();
        if (widgets == null) {
            widgets = new Widgets(row);
            row.setTag((Object)widgets);
        }
        if (((ListReportModel)this.getItem(position)).getThumbnail() == null) {
            widgets.thumbnail.setImageResource(R.drawable.report_icon);
        } else {
            this.getPhoto(((ListReportModel)this.getItem(position)).getThumbnail(), widgets.thumbnail);
        }
        widgets.title.setText((CharSequence)((ListReportModel)this.getItem(position)).getTitle());
        widgets.date.setText((CharSequence)((ListReportModel)this.getItem(position)).getDate());
        widgets.description.setText((CharSequence)Util.capitalizeString(((ListReportModel)this.getItem(position)).getDesc()));
        widgets.categories.setText((CharSequence)Util.capitalizeString(Util.limitString(this.fetchCategories(((ListReportModel)this.getItem(position)).getReportId()), 100)));
        widgets.iLocation.setText((CharSequence)Util.capitalizeString(((ListReportModel)this.getItem(position)).getLocation()));
        if (((ListReportModel)this.getItem(position)).getStatus().equalsIgnoreCase(this.context.getString(R.string.verified))) {
            widgets.status.setTextColor(this.context.getResources().getColor(R.color.verified_text_color));
        } else {
            widgets.status.setTextColor(this.context.getResources().getColor(R.color.unverified_text_color));
        }
        widgets.status.setText((CharSequence)Util.capitalizeString(((ListReportModel)this.getItem(position)).getStatus()));
        widgets.arrow.setImageDrawable(((ListReportModel)this.getItem(position)).getArrow());
        return row;
    }

    public void getPhoto(String fileName, ImageView imageView) {
        ImageViewWorker imageWorker = new ImageViewWorker(this.context);
        imageWorker.setImageFadeIn(true);
        imageWorker.loadImage(fileName, imageView, true, 0);
    }

    public Filter getFilter() {
        return new ReportFilter();
    }

    public class ReportFilter
    extends Filter {
        protected Filter.FilterResults performFiltering(CharSequence constraint) {
            Filter.FilterResults results = new Filter.FilterResults();
            results.values = ListFetchedReportAdapter.this.items;
            results.count = ListFetchedReportAdapter.this.items.size();
            if (constraint != null && constraint.toString().length() > 0) {
                constraint = constraint.toString().toLowerCase();
                ArrayList<ListReportModel> filteredItems = new ArrayList<ListReportModel>();
                ArrayList itemsHolder = new ArrayList();
                itemsHolder.addAll(ListFetchedReportAdapter.this.items);
                for (ListReportModel report : itemsHolder) {
                    if (!report.getTitle().toLowerCase().contains(constraint) && !report.getLocation().toLowerCase().contains(constraint)) continue;
                    filteredItems.add(report);
                }
                results.count = filteredItems.size();
                results.values = filteredItems;
            }
            return results;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            ArrayList reports = (ArrayList)results.values;
            ListFetchedReportAdapter.this.setItems(reports);
        }
    }

    class Widgets
    extends View {
        TextView title;
        TextView iLocation;
        TextView date;
        TextView status;
        TextView categories;
        TextView description;
        ImageView thumbnail;
        ImageView arrow;

        public Widgets(android.view.View view) {
            super(view);
            this.thumbnail = (ImageView)view.findViewById(R.id.report_thumbnail);
            this.title = (TextView)view.findViewById(R.id.report_title);
            this.description = (TextView)view.findViewById(R.id.report_description);
            this.date = (TextView)view.findViewById(R.id.report_date);
            this.iLocation = (TextView)view.findViewById(R.id.report_location);
            this.categories = (TextView)view.findViewById(R.id.report_categories);
            this.status = (TextView)view.findViewById(R.id.report_status);
            this.arrow = (ImageView)view.findViewById(R.id.report_arrow);
        }
    }
}

