/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.adapters;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.TextView;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.adapters.BaseListAdapter;
import com.ushahidi.android.app.models.ListMapModel;
import java.util.ArrayList;

public class ListMapAdapter
extends BaseListAdapter<ListMapModel>
implements Filterable {
    private int[] colors;
    private ListMapModel listMapModel = new ListMapModel();

    public ListMapAdapter(Context context) {
        super(context);
        this.colors = new int[]{R.drawable.odd_row_rounded_corners, R.drawable.even_row_rounded_corners};
    }

    @Override
    public void refresh() {
        boolean loaded = this.listMapModel.load();
        if (loaded) {
            this.setItems(this.listMapModel.getMaps());
        }
    }

    public View getView(int position, View view, ViewGroup viewGroup) {
        Preferences.loadSettings(this.context);
        int mapId = Preferences.activeDeployment;
        View row = this.inflater.inflate(R.layout.list_map_item, viewGroup, false);
        int colorPosition = position % this.colors.length;
        row.setBackgroundResource(this.colors[colorPosition]);
        Widgets widget = (Widgets)row.getTag();
        if (widget == null) {
            widget = new Widgets(row);
            row.setTag((Object)widget);
        }
        widget.mapName.setText((CharSequence)((ListMapModel)this.getItem(position)).getName());
        widget.mapDesc.setText((CharSequence)((ListMapModel)this.getItem(position)).getDesc());
        widget.mapUrl.setText((CharSequence)((ListMapModel)this.getItem(position)).getUrl());
        widget.mapId.setText((CharSequence)String.valueOf(((ListMapModel)this.getItem(position)).getId()));
        if (((ListMapModel)this.getItem(position)).getId() == mapId) {
            widget.arrow.setImageResource(R.drawable.selected);
        } else {
            widget.arrow.setImageResource(R.drawable.arrow);
        }
        return row;
    }

    public Filter getFilter() {
        return new MapFilter();
    }

    public class MapFilter
    extends Filter {
        protected Filter.FilterResults performFiltering(CharSequence constraint) {
            Filter.FilterResults results = new Filter.FilterResults();
            results.values = ListMapAdapter.this.items;
            results.count = ListMapAdapter.this.items.size();
            if (constraint != null && constraint.toString().length() > 0) {
                constraint = constraint.toString().toLowerCase();
                ArrayList<ListMapModel> filteredItems = new ArrayList<ListMapModel>();
                ArrayList itemsHolder = new ArrayList();
                itemsHolder.addAll(ListMapAdapter.this.items);
                for (ListMapModel map : itemsHolder) {
                    if (!map.getName().toLowerCase().contains(constraint) && !map.getDesc().toLowerCase().contains(constraint)) continue;
                    filteredItems.add(map);
                }
                results.count = filteredItems.size();
                results.values = filteredItems;
            }
            return results;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            ArrayList reports = (ArrayList)results.values;
            ListMapAdapter.this.setItems(reports);
        }
    }

    public class Widgets
    extends com.ushahidi.android.app.views.View {
        TextView mapName;
        TextView mapDesc;
        TextView mapUrl;
        TextView mapId;
        ImageView arrow;

        public Widgets(View convertView) {
            super(convertView);
            this.mapName = (TextView)convertView.findViewById(R.id.map_list_name);
            this.mapDesc = (TextView)convertView.findViewById(R.id.map_list_desc);
            this.mapUrl = (TextView)convertView.findViewById(R.id.map_list_url);
            this.mapId = (TextView)convertView.findViewById(R.id.map_list_id);
            this.arrow = (ImageView)convertView.findViewById(R.id.map_arrow);
        }
    }
}

