/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.adapters;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.adapters.BaseListAdapter;
import com.ushahidi.android.app.models.ListReportNewsModel;
import java.util.List;

public class ListNewsAdapter
extends BaseListAdapter<ListReportNewsModel> {
    private ListReportNewsModel mListNewsModel;
    private List<ListReportNewsModel> items;
    private int totalNews;

    public ListNewsAdapter(Context context) {
        super(context);
    }

    public View getView(int position, View view, ViewGroup viewGroup) {
        View row = this.inflater.inflate(R.layout.list_news_item, viewGroup, false);
        Widgets widgets = (Widgets)row.getTag();
        if (widgets == null) {
            widgets = new Widgets(row);
            row.setTag((Object)widgets);
        }
        widgets.newsTitle.setText((CharSequence)((ListReportNewsModel)this.getItem(position)).getTitle());
        widgets.total.setText((CharSequence)this.context.getResources().getQuantityString(R.plurals.no_of_news, this.totalNews, new Object[]{this.totalNews}));
        return row;
    }

    @Override
    public void refresh() {
    }

    public void refresh(int reportId) {
        this.mListNewsModel = new ListReportNewsModel();
        boolean loaded = this.mListNewsModel.load(reportId);
        this.totalNews = this.mListNewsModel.totalReportNews();
        if (loaded) {
            this.items = this.mListNewsModel.getNews();
            this.setItems(this.items);
        }
    }

    class Widgets
    extends com.ushahidi.android.app.views.View {
        TextView newsTitle;
        TextView total;

        public Widgets(View view) {
            super(view);
            this.newsTitle = (TextView)view.findViewById(R.id.news_title);
            this.total = (TextView)view.findViewById(R.id.news_total);
        }
    }
}

