/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.adapters;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.adapters.BaseListAdapter;
import com.ushahidi.android.app.entities.Photo;
import com.ushahidi.android.app.models.ListPhotoModel;
import com.ushahidi.android.app.util.ImageViewWorker;
import java.util.List;

public class ListPhotoAdapter
extends BaseListAdapter<Photo> {
    private ListPhotoModel mListPhotoModel;
    private List<Photo> items;
    private int totalPhotos;

    public ListPhotoAdapter(Context context) {
        super(context);
    }

    public View getView(int position, View view, ViewGroup viewGroup) {
        View row = this.inflater.inflate(R.layout.list_photo_item, viewGroup, false);
        Widgets widgets = (Widgets)row.getTag();
        if (widgets == null) {
            widgets = new Widgets(row);
            row.setTag((Object)widgets);
        }
        this.getPhoto(((Photo)this.getItem(position)).getPhoto(), widgets.photo);
        widgets.total.setText((CharSequence)this.context.getResources().getQuantityString(R.plurals.no_of_images, this.totalPhotos, new Object[]{this.totalPhotos}));
        return row;
    }

    @Override
    public void refresh() {
    }

    public void refresh(int reportId) {
        this.mListPhotoModel = new ListPhotoModel();
        boolean loaded = this.mListPhotoModel.load(reportId);
        this.totalPhotos = this.mListPhotoModel.totalReportPhoto();
        if (loaded) {
            this.items = this.mListPhotoModel.getPhotos();
            this.setItems(this.items);
        }
    }

    public void refreshCheckinPhotos(int checkinId) {
        this.mListPhotoModel = new ListPhotoModel();
        boolean loaded = this.mListPhotoModel.loadCheckinPhoto(checkinId);
        this.totalPhotos = this.mListPhotoModel.totalReportPhoto();
        if (loaded) {
            this.items = this.mListPhotoModel.getPhotos();
            this.setItems(this.items);
        }
    }

    public void getPhoto(String fileName, ImageView imageView) {
        ImageViewWorker imageWorker = new ImageViewWorker(this.context);
        imageWorker.setImageFadeIn(true);
        imageWorker.loadImage(fileName, imageView, true, 0);
    }

    class Widgets
    extends com.ushahidi.android.app.views.View {
        ImageView photo;
        TextView total;

        public Widgets(View view) {
            super(view);
            this.photo = (ImageView)view.findViewById(R.id.list_report_photo);
            this.total = (TextView)view.findViewById(R.id.photo_total);
        }
    }
}

