/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.adapters;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.adapters.BaseListAdapter;
import com.ushahidi.android.app.models.ListReportVideoModel;
import java.util.List;

public class ListVideoAdapter
extends BaseListAdapter<ListReportVideoModel> {
    private ListReportVideoModel mListReportVideoModel;
    private List<ListReportVideoModel> items;
    private int totalVideos;

    public ListVideoAdapter(Context context) {
        super(context);
    }

    public View getView(int position, View view, ViewGroup viewGroup) {
        View row = this.inflater.inflate(R.layout.list_video_item, viewGroup, false);
        Widgets widgets = (Widgets)row.getTag();
        if (widgets == null) {
            widgets = new Widgets(row);
            row.setTag((Object)widgets);
        }
        widgets.video.setText((CharSequence)((ListReportVideoModel)this.getItem(position)).getVideo());
        widgets.total.setText((CharSequence)this.context.getResources().getQuantityString(R.plurals.no_of_videos, this.totalVideos, new Object[]{this.totalVideos}));
        return row;
    }

    @Override
    public void refresh() {
    }

    public void refresh(int reportId) {
        this.mListReportVideoModel = new ListReportVideoModel();
        boolean loaded = this.mListReportVideoModel.load(reportId);
        this.totalVideos = this.mListReportVideoModel.totalReportVideos();
        if (loaded) {
            this.items = this.mListReportVideoModel.getVideos();
            this.setItems(this.items);
        }
    }

    class Widgets
    extends com.ushahidi.android.app.views.View {
        TextView video;
        TextView total;

        public Widgets(View view) {
            super(view);
            this.video = (TextView)view.findViewById(R.id.report_video_webview);
            this.total = (TextView)view.findViewById(R.id.video_total);
        }
    }
}

